/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTabViewItem;
import org.eclipse.swt.internal.cocoa.NSValue;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TabFolder;

public class TabItem
extends Item {
    TabFolder parent;
    Control control;
    String toolTipText;
    NSTabViewItem nsItem;

    public TabItem(TabFolder tabFolder, int n) {
        super(tabFolder, n);
        this.parent = tabFolder;
        tabFolder.createItem(this, tabFolder.getItemCount());
    }

    public TabItem(TabFolder tabFolder, int n, int n2) {
        super(tabFolder, n);
        this.parent = tabFolder;
        tabFolder.createItem(this, n2);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Rectangle getBounds() {
        this.checkWidget();
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        if (this.nsItem.respondsToSelector(OS.sel_accessibilityAttributeValue_)) {
            int n = OS.objc_msgSend(this.nsItem.id, OS.sel_accessibilityAttributeValue_, OS.NSAccessibilityPositionAttribute());
            int n2 = OS.objc_msgSend(this.nsItem.id, OS.sel_accessibilityAttributeValue_, OS.NSAccessibilitySizeAttribute());
            NSValue nSValue = new NSValue(n);
            NSPoint nSPoint = nSValue.pointValue();
            NSWindow nSWindow = this.parent.view.window();
            nSPoint.y = this.display.getPrimaryFrame().height - nSPoint.y;
            nSPoint = this.parent.view.convertPoint_fromView_(nSPoint, null);
            nSPoint = nSWindow.convertScreenToBase(nSPoint);
            rectangle.x = (int)nSPoint.x;
            rectangle.y = (int)nSPoint.y;
            nSValue = new NSValue(n2);
            NSSize nSSize = nSValue.sizeValue();
            rectangle.width = (int)Math.ceil(nSSize.width);
            rectangle.height = (int)Math.ceil(nSSize.height);
        }
        return rectangle;
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public TabFolder getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.nsItem != null) {
            this.nsItem.release();
        }
        this.nsItem = null;
        this.parent = null;
    }

    void releaseParent() {
        super.releaseParent();
        int n = this.parent.indexOf(this);
        if (n == this.parent.getSelectionIndex() && this.control != null) {
            this.control.setVisible(false);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.control = null;
    }

    public void setControl(Control control) {
        NSView nSView;
        Object object;
        int n;
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if (this.control != null && this.control.isDisposed()) {
            this.control = null;
        }
        Control control2 = this.control;
        Control control3 = control;
        this.control = control;
        int n2 = this.parent.indexOf(this);
        if (n2 != (n = this.parent.getSelectionIndex())) {
            if (control3 != null) {
                boolean bl = true;
                if (n != -1 && (object = this.parent.getItem(n).getControl()) == control3) {
                    bl = false;
                }
                if (bl) {
                    control3.setVisible(false);
                }
            }
        } else {
            if (control3 != null) {
                control3.setVisible(true);
            }
            if (control2 != null) {
                control2.setVisible(false);
            }
        }
        if (control3 != null) {
            nSView = control3.topView();
        } else {
            nSView = (NSView)new NSView().alloc();
            nSView.init();
            nSView.autorelease();
        }
        this.nsItem.setView(nSView);
        if (control2 != null && ((NSView)(object = control2.topView())).superview() == null) {
            this.parent.contentView().addSubview((NSView)object, -1, null);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return;
        }
        super.setImage(image);
    }

    public void setText(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = this.parent.indexOf(this)) == -1) {
            return;
        }
        super.setText(string);
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        int n2 = this.fixMnemonic(cArray);
        NSString nSString = NSString.stringWithCharacters(cArray, n2);
        this.nsItem.setLabel(nSString);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        this.parent.checkToolTip(this);
    }

    String tooltipText() {
        return this.toolTipText;
    }

    void update() {
        this.setText(this.text);
        this.setImage(this.image);
        this.setToolTipText(this.toolTipText);
    }
}

