/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Tree;

public class TreeDropTargetEffect
extends DropTargetEffect {
    static final int SCROLL_HYSTERESIS = 150;
    static final int EXPAND_HYSTERESIS = 1000;
    int scrollIndex = -1;
    long scrollBeginTime;
    int expandIndex = -1;
    long expandBeginTime;

    public TreeDropTargetEffect(Tree tree) {
        super(tree);
    }

    int checkEffect(int n) {
        if ((n & 1) != 0) {
            n = n & 0xFFFFFFFB & 0xFFFFFFFD;
        }
        if ((n & 2) != 0) {
            n &= 0xFFFFFFFB;
        }
        return n;
    }

    public void dragEnter(DropTargetEvent dropTargetEvent) {
        this.expandBeginTime = 0L;
        this.expandIndex = -1;
        this.scrollBeginTime = 0L;
        this.scrollIndex = -1;
    }

    public void dragLeave(DropTargetEvent dropTargetEvent) {
        Tree tree = (Tree)this.control;
        long l = tree.handle;
        OS.gtk_tree_view_set_drag_dest_row(l, 0L, 0);
        this.scrollBeginTime = 0L;
        this.scrollIndex = -1;
        this.expandBeginTime = 0L;
        this.expandIndex = -1;
    }

    public void dragOver(DropTargetEvent dropTargetEvent) {
        long l;
        Tree tree = (Tree)this.control;
        int n = this.checkEffect(dropTargetEvent.feedback);
        long l2 = tree.handle;
        Point point = new Point(dropTargetEvent.x, dropTargetEvent.y);
        point = tree.toControl(point);
        long[] lArray = new long[1];
        OS.gtk_tree_view_get_path_at_pos(l2, point.x, point.y, lArray, null, null, null);
        int n2 = -1;
        if (lArray[0] != 0L && (l = OS.gtk_tree_path_get_indices(lArray[0])) != 0L) {
            int n3 = OS.gtk_tree_path_get_depth(lArray[0]);
            int[] nArray = new int[n3];
            OS.memmove(nArray, l, (long)(nArray.length * 4));
            n2 = nArray[nArray.length - 1];
        }
        if ((n & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollIndex = -1;
        } else if (n2 != -1 && this.scrollIndex == n2 && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                GdkRectangle gdkRectangle = new GdkRectangle();
                OS.gtk_tree_view_get_cell_area(l2, lArray[0], 0L, gdkRectangle);
                if (gdkRectangle.y < gdkRectangle.height) {
                    int[] nArray = new int[1];
                    int[] nArray2 = new int[1];
                    OS.gtk_tree_view_widget_to_tree_coords(l2, gdkRectangle.x, gdkRectangle.y - gdkRectangle.height, nArray, nArray2);
                    OS.gtk_tree_view_scroll_to_point(l2, -1, nArray2[0]);
                } else {
                    OS.gtk_tree_view_get_path_at_pos(l2, point.x, point.y + gdkRectangle.height, lArray, null, null, null);
                    if (lArray[0] != 0L) {
                        OS.gtk_tree_view_scroll_to_cell(l2, lArray[0], 0L, false, 0.0f, 0.0f);
                        OS.gtk_tree_path_free(lArray[0]);
                        lArray[0] = 0L;
                    }
                    OS.gtk_tree_view_get_path_at_pos(l2, point.x, point.y, lArray, null, null, null);
                }
                this.scrollBeginTime = 0L;
                this.scrollIndex = -1;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 150L;
            this.scrollIndex = n2;
        }
        if ((n & 0x10) == 0) {
            this.expandBeginTime = 0L;
            this.expandIndex = -1;
        } else if (n2 != -1 && this.expandIndex == n2 && this.expandBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.expandBeginTime) {
                OS.gtk_tree_view_expand_row(l2, lArray[0], false);
                this.expandBeginTime = 0L;
                this.expandIndex = -1;
            }
        } else {
            this.expandBeginTime = System.currentTimeMillis() + 1000L;
            this.expandIndex = n2;
        }
        if (lArray[0] != 0L) {
            int n4 = -1;
            if ((n & 1) != 0) {
                n4 = 2;
            }
            if ((n & 2) != 0) {
                n4 = 0;
            }
            if ((n & 4) != 0) {
                n4 = 1;
            }
            if (n4 != -1) {
                OS.gtk_tree_view_set_drag_dest_row(l2, lArray[0], n4);
            } else {
                OS.gtk_tree_view_set_drag_dest_row(l2, 0L, 0);
            }
        } else {
            OS.gtk_tree_view_set_drag_dest_row(l2, 0L, 0);
        }
        if (lArray[0] != 0L) {
            OS.gtk_tree_path_free(lArray[0]);
        }
    }
}

