/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GtkAdjustment;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ScrollBar
extends Widget {
    Scrollable parent;
    long adjustmentHandle;
    int detail;
    boolean dragSent;

    ScrollBar() {
    }

    ScrollBar(Scrollable scrollable, int n) {
        super(scrollable, ScrollBar.checkStyle(n));
        this.parent = scrollable;
        this.createWidget(0);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return ScrollBar.checkBits(n, 256, 512, 0, 0, 0, 0);
    }

    void deregister() {
        super.deregister();
        if (this.adjustmentHandle != 0L) {
            this.display.removeWidget(this.adjustmentHandle);
        }
    }

    void destroyHandle() {
        super.destroyWidget();
    }

    void destroyWidget() {
        this.parent.destroyScrollBar(this);
        this.releaseHandle();
    }

    public boolean getEnabled() {
        this.checkWidget();
        if (this.handle != 0L) {
            return OS.GTK_WIDGET_SENSITIVE(this.handle);
        }
        return true;
    }

    public int getIncrement() {
        this.checkWidget();
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, this.adjustmentHandle);
        return (int)gtkAdjustment.step_increment;
    }

    public int getMaximum() {
        this.checkWidget();
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, this.adjustmentHandle);
        return (int)gtkAdjustment.upper;
    }

    public int getMinimum() {
        this.checkWidget();
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, this.adjustmentHandle);
        return (int)gtkAdjustment.lower;
    }

    public int getPageIncrement() {
        this.checkWidget();
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, this.adjustmentHandle);
        return (int)gtkAdjustment.page_increment;
    }

    public Scrollable getParent() {
        this.checkWidget();
        return this.parent;
    }

    public int getSelection() {
        this.checkWidget();
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, this.adjustmentHandle);
        return (int)gtkAdjustment.value;
    }

    public Point getSize() {
        this.checkWidget();
        if (this.handle == 0L) {
            return new Point(0, 0);
        }
        GtkRequisition gtkRequisition = new GtkRequisition();
        OS.gtk_widget_size_request(this.handle, gtkRequisition);
        return new Point(gtkRequisition.width, gtkRequisition.height);
    }

    public int getThumb() {
        this.checkWidget();
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, this.adjustmentHandle);
        return (int)gtkAdjustment.page_size;
    }

    public boolean getVisible() {
        this.checkWidget();
        long l = this.parent.scrolledHandle;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gtk_scrolled_window_get_policy(l, nArray, nArray2);
        if ((this.style & 0x100) != 0) {
            return nArray[0] != 2;
        }
        return nArray2[0] != 2;
    }

    long gtk_button_press_event(long l, long l2) {
        long l3 = super.gtk_button_press_event(l, l2);
        if (l3 != 0L) {
            return l3;
        }
        this.detail = 0;
        this.dragSent = false;
        return l3;
    }

    long gtk_change_value(long l, long l2, long l3, long l4) {
        this.detail = (int)l2;
        return 0L;
    }

    long gtk_value_changed(long l) {
        Event event = new Event();
        this.dragSent = this.detail == 1;
        switch (this.detail) {
            case 0: {
                event.detail = 0;
                break;
            }
            case 1: {
                event.detail = 1;
                break;
            }
            case 14: {
                event.detail = 0x1000007;
                break;
            }
            case 15: {
                event.detail = 0x1000008;
                break;
            }
            case 5: 
            case 9: 
            case 13: {
                event.detail = 0x1000006;
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                event.detail = 0x1000005;
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                event.detail = 0x1000002;
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                event.detail = 0x1000001;
            }
        }
        this.detail = 0;
        if (!this.dragSent) {
            this.detail = 0;
        }
        this.postEvent(13, event);
        this.parent.updateScrollBarValue(this);
        return 0L;
    }

    long gtk_event_after(long l, long l2) {
        GdkEvent gdkEvent = new GdkEvent();
        OS.memmove(gdkEvent, l2, (long)GdkEvent.sizeof);
        switch (gdkEvent.type) {
            case 7: {
                GdkEventButton gdkEventButton = new GdkEventButton();
                OS.memmove(gdkEventButton, l2, (long)GdkEventButton.sizeof);
                if (gdkEventButton.button == 1 && this.detail == 1) {
                    if (!this.dragSent) {
                        Event event = new Event();
                        event.detail = 1;
                        this.postEvent(13, event);
                    }
                    this.postEvent(13);
                }
                this.detail = 0;
                this.dragSent = false;
            }
        }
        return super.gtk_event_after(l, l2);
    }

    void hookEvents() {
        super.hookEvents();
        if (OS.GTK_VERSION >= OS.VERSION(2, 6, 0)) {
            OS.g_signal_connect_closure(this.handle, OS.change_value, this.display.closures[7], false);
        }
        OS.g_signal_connect_closure(this.adjustmentHandle, OS.value_changed, this.display.closures[57], false);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[16], 0, this.display.closures[16], false);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[2], 0, this.display.closures[2], false);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.getParent().getEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.getParent().isVisible();
    }

    void register() {
        super.register();
        if (this.adjustmentHandle != 0L) {
            this.display.addWidget(this.adjustmentHandle, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    void releaseParent() {
        super.releaseParent();
        if (this.parent.horizontalBar == this) {
            this.parent.horizontalBar = null;
        }
        if (this.parent.verticalBar == this) {
            this.parent.verticalBar = null;
        }
    }

    void releaseWidget() {
        super.releaseWidget();
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        if (this.handle != 0L) {
            OS.gtk_widget_set_sensitive(this.handle, bl);
        }
    }

    public void setIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, this.adjustmentHandle);
        gtkAdjustment.step_increment = n;
        OS.memmove(this.adjustmentHandle, gtkAdjustment);
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_adjustment_changed(this.adjustmentHandle);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setMaximum(int n) {
        this.checkWidget();
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, this.adjustmentHandle);
        int n2 = (int)gtkAdjustment.lower;
        if (n <= n2) {
            return;
        }
        gtkAdjustment.upper = n;
        gtkAdjustment.page_size = Math.min((int)gtkAdjustment.page_size, n - n2);
        gtkAdjustment.value = Math.min((int)gtkAdjustment.value, (int)((double)n - gtkAdjustment.page_size));
        OS.memmove(this.adjustmentHandle, gtkAdjustment);
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_adjustment_changed(this.adjustmentHandle);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setMinimum(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, this.adjustmentHandle);
        int n2 = (int)gtkAdjustment.upper;
        if (n >= n2) {
            return;
        }
        gtkAdjustment.lower = n;
        gtkAdjustment.page_size = Math.min((int)gtkAdjustment.page_size, n2 - n);
        gtkAdjustment.value = Math.max((int)gtkAdjustment.value, n);
        OS.memmove(this.adjustmentHandle, gtkAdjustment);
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_adjustment_changed(this.adjustmentHandle);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
    }

    void setOrientation() {
        super.setOrientation();
        if ((this.parent.style & 0x8000000) != 0 && (this.parent.state & 2) != 0 && (this.style & 0x100) != 0) {
            OS.gtk_range_set_inverted(this.handle, true);
        }
    }

    public void setPageIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, this.adjustmentHandle);
        gtkAdjustment.page_increment = n;
        OS.memmove(this.adjustmentHandle, gtkAdjustment);
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_adjustment_changed(this.adjustmentHandle);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setSelection(int n) {
        this.checkWidget();
        n = Math.min(n, this.getMaximum() - this.getThumb());
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_adjustment_set_value(this.adjustmentHandle, n);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setThumb(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, this.adjustmentHandle);
        n = Math.min(n, (int)(gtkAdjustment.upper - gtkAdjustment.lower));
        gtkAdjustment.page_size = n;
        gtkAdjustment.value = Math.min((int)gtkAdjustment.value, (int)(gtkAdjustment.upper - (double)n));
        OS.memmove(this.adjustmentHandle, gtkAdjustment);
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_adjustment_changed(this.adjustmentHandle);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setValues(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        if (n3 < 0) {
            return;
        }
        if (n4 < 1) {
            return;
        }
        if (n5 < 1) {
            return;
        }
        if (n6 < 1) {
            return;
        }
        n4 = Math.min(n4, n3 - n2);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, this.adjustmentHandle);
        gtkAdjustment.lower = n2;
        gtkAdjustment.upper = n3;
        gtkAdjustment.step_increment = n5;
        gtkAdjustment.page_increment = n6;
        gtkAdjustment.page_size = n4;
        gtkAdjustment.value = Math.min(Math.max(n, n2), n3 - n4);
        OS.memmove(this.adjustmentHandle, gtkAdjustment);
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_adjustment_changed(this.adjustmentHandle);
        OS.gtk_adjustment_value_changed(this.adjustmentHandle);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (this.parent.setScrollBarVisible(this, bl)) {
            this.sendEvent(bl ? 22 : 23);
            this.parent.sendEvent(11);
        }
    }
}

