/*
 * Decompiled with CFR 0.152.
 */
package jnlp.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class Main {
    static Shell shell = new Shell(Display.getDefault());
    private static URL url = Main.locateTemplateURL(shell);

    public static void main(String[] args) {
        Main.showMessage(shell, url.toString());
        shell.dispose();
    }

    private static void showMessage(Shell shell, String msg) {
        MessageBox box = new MessageBox(shell);
        box.setMessage(msg);
        box.open();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static URL locateTemplateURL(Shell shell) {
        URL result = Main.class.getResource("resource/template.html");
        if (!result.toString().startsWith("jar")) return result;
        URL jarURL = Main.class.getProtectionDomain().getCodeSource().getLocation();
        String decodedPath = jarURL.toString();
        File daJar = null;
        if (jarURL.getProtocol().equals("file")) {
            try {
                decodedPath = URLDecoder.decode(jarURL.getPath(), "UTF-8");
                daJar = new File(decodedPath);
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace();
                Main.showMessage(shell, e1.getMessage());
            }
        } else {
            try {
                final Path jar = Files.createTempFile("jnlptest", ".jar", new FileAttribute[0]);
                Files.copy(jarURL.openStream(), jar, StandardCopyOption.REPLACE_EXISTING);
                decodedPath = jar.toString();
                daJar = jar.toFile();
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        try {
                            Files.delete(jar);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
                Main.showMessage(shell, e.getMessage());
            }
        }
        String unpackDirectory = System.getProperty("user.dir");
        String tempDirectory = System.getProperty("java.io.tmpdir");
        Main.showMessage(shell, "location URL: " + Main.class.getProtectionDomain().getCodeSource().getLocation() + "\n" + "path: " + decodedPath + "\n" + "unpack dir: " + unpackDirectory + "\n" + "temp dir: " + tempDirectory);
        if (decodedPath == null) return result;
        try {
            Throwable throwable = null;
            Object var8_12 = null;
            try (JarFile jarFile = new JarFile(daJar);){
                Path tempDir;
                Path path = tempDir = unpackDirectory == null ? Files.createTempDirectory("jnlptest", new FileAttribute[0]) : Files.createDirectories(Paths.get(unpackDirectory, new String[0]), new FileAttribute[0]);
                if (unpackDirectory == null) {
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        @Override
                        public void run() {
                            try {
                                Files.walkFileTree(tempDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                                    @Override
                                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                        Files.delete(file);
                                        return FileVisitResult.CONTINUE;
                                    }

                                    @Override
                                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                                        Files.delete(dir);
                                        return FileVisitResult.CONTINUE;
                                    }
                                });
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
                Enumeration<JarEntry> entries = jarFile.entries();
                while (true) {
                    File file;
                    String name;
                    block35: {
                        if (!entries.hasMoreElements()) {
                            return result;
                        }
                        JarEntry entry = entries.nextElement();
                        name = entry.getName();
                        if (!name.startsWith("jnlp/test/resource")) continue;
                        file = new File(tempDir.toAbsolutePath() + File.separator + name);
                        if (!file.exists()) {
                            if (entry.isDirectory()) {
                                file.mkdirs();
                            } else {
                                Throwable throwable2 = null;
                                Object var16_22 = null;
                                try {
                                    InputStream is = jarFile.getInputStream(entry);
                                    try {
                                        try (FileOutputStream os = new FileOutputStream(file);){
                                            while (is.available() > 0) {
                                                ((OutputStream)os).write(is.read());
                                            }
                                        }
                                        if (is == null) break block35;
                                    }
                                    catch (Throwable throwable3) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable3;
                                        } else if (throwable2 != throwable3) {
                                            throwable2.addSuppressed(throwable3);
                                        }
                                        if (is == null) throw throwable2;
                                        is.close();
                                        throw throwable2;
                                    }
                                    is.close();
                                }
                                catch (Throwable throwable4) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable4;
                                        throw throwable2;
                                    }
                                    if (throwable2 == throwable4) throw throwable2;
                                    throwable2.addSuppressed(throwable4);
                                    throw throwable2;
                                }
                            }
                        }
                    }
                    if (!name.endsWith("template.html")) continue;
                    result = file.toURI().toURL();
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Main.showMessage(shell, e.getMessage());
        }
        return result;
    }
}

