/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Config;

public class ProcessTaskManager {
    private final Compiler compiler;
    private final int startingIndex;
    private volatile Future<?> processingTask;
    CompilationUnitDeclaration unitToProcess;
    private Throwable caughtException;
    volatile int currentIndex;
    volatile int availableIndex;
    volatile int size;
    volatile int sleepCount;
    private final CompilationUnitDeclaration[] units;
    public static final int PROCESSED_QUEUE_SIZE = 100;
    private static final ExecutorService executor = Executors.newCachedThreadPool(r -> {
        Thread t = new Thread(r, "Compiler Processing Task");
        t.setDaemon(true);
        return t;
    });
    private Config sharedConfig;

    private void setConfig(Config config) {
        this.sharedConfig = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessTaskManager(Compiler compiler, int startingIndex) {
        this.compiler = compiler;
        this.startingIndex = startingIndex;
        this.currentIndex = 0;
        this.availableIndex = 0;
        this.size = 100;
        this.sleepCount = 0;
        this.units = new CompilationUnitDeclaration[this.size];
        ProcessTaskManager processTaskManager = this;
        synchronized (processTaskManager) {
            this.setConfig(Config.getConfig());
            this.processingTask = executor.submit(this::compile);
        }
    }

    private synchronized void addNextUnit(CompilationUnitDeclaration newElement) {
        while (this.units[this.availableIndex] != null) {
            this.sleepCount = 1;
            try {
                this.wait(250L);
            }
            catch (InterruptedException interruptedException) {}
            this.sleepCount = 0;
        }
        this.units[this.availableIndex++] = newElement;
        if (this.availableIndex >= this.size) {
            this.availableIndex = 0;
        }
        if (this.sleepCount <= -1) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CompilationUnitDeclaration removeNextUnit() throws Error {
        CompilationUnitDeclaration next = null;
        boolean yield = false;
        ProcessTaskManager processTaskManager = this;
        synchronized (processTaskManager) {
            next = this.units[this.currentIndex];
            if (next == null || this.caughtException != null) {
                do {
                    if (this.processingTask == null) {
                        if (this.caughtException == null) {
                            return null;
                        }
                        if (this.caughtException instanceof Error) {
                            throw (Error)this.caughtException;
                        }
                        throw (RuntimeException)this.caughtException;
                    }
                    this.sleepCount = -1;
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                    this.sleepCount = 0;
                } while ((next = this.units[this.currentIndex]) == null);
            }
            this.units[this.currentIndex++] = null;
            if (this.currentIndex >= this.size) {
                this.currentIndex = 0;
            }
            if (this.sleepCount >= 1 && ++this.sleepCount > 4) {
                this.notify();
                yield = this.sleepCount > 8;
            }
        }
        if (yield) {
            Thread.yield();
        }
        return next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compile() {
        int unitIndex = this.startingIndex;
        ProcessTaskManager processTaskManager = this;
        synchronized (processTaskManager) {
        }
        Config.addConfig(this.sharedConfig);
        boolean noAnnotations = this.compiler.annotationProcessorManager == null;
        while (this.processingTask != null) {
            this.unitToProcess = null;
            int index = -1;
            boolean cleanup = noAnnotations || this.compiler.shouldCleanup(unitIndex);
            try {
                ProcessTaskManager processTaskManager2 = this;
                synchronized (processTaskManager2) {
                    if (this.processingTask == null) {
                        return;
                    }
                    this.unitToProcess = this.compiler.getUnitToProcess(unitIndex);
                    if (this.unitToProcess == null) {
                        this.processingTask = null;
                        return;
                    }
                    index = unitIndex++;
                    if (this.unitToProcess.compilationResult.hasBeenAccepted) {
                        continue;
                    }
                }
                try {
                    this.compiler.reportProgress(Messages.bind(Messages.compilation_processing, new String(this.unitToProcess.getFileName())));
                    if (this.compiler.options.verbose) {
                        this.compiler.out.println(Messages.bind(Messages.compilation_process, new String[]{String.valueOf(index + 1), String.valueOf(this.compiler.totalUnits), new String(this.unitToProcess.getFileName())}));
                    }
                    try {
                        this.compiler.process(this.unitToProcess, index);
                    }
                    catch (AbortCompilation keptCancelation) {
                        throw keptCancelation;
                    }
                    catch (Error | RuntimeException e) {
                        throw new RuntimeException("Internal Error compiling " + new String(this.unitToProcess.getFileName()), e);
                    }
                }
                finally {
                    if (this.unitToProcess != null && cleanup) {
                        this.unitToProcess.cleanUp();
                    }
                }
                this.addNextUnit(this.unitToProcess);
            }
            catch (Error | RuntimeException e) {
                ProcessTaskManager processTaskManager3 = this;
                synchronized (processTaskManager3) {
                    this.processingTask = null;
                    this.caughtException = e;
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            Future<?> t = null;
            ProcessTaskManager processTaskManager = this;
            synchronized (processTaskManager) {
                t = this.processingTask;
                if (t != null) {
                    this.processingTask = null;
                    this.notifyAll();
                }
            }
            if (t != null) {
                t.get(250L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {}
    }
}

