/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.MemberTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.PotentialLowerExpression;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.StateHelper;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.Lifting;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ITeamAnchor;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.mappings.CalloutImplementorDyn;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;

public class BaseAllocationExpression
extends Assignment {
    public Expression[] arguments;
    public Expression enclosingInstance;
    public boolean isExpression = false;
    private boolean isAstCreated = false;
    private Boolean checkResult = null;

    public BaseAllocationExpression(int start, int end) {
        super(new SingleNameReference(IOTConstants._OT_BASE, 0L), null, end);
        this.sourceStart = start;
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.isExpression) {
            return this.expression.analyseCode(currentScope, flowContext, flowInfo);
        }
        if (((AbstractMethodDeclaration)currentScope.methodScope().referenceContext).ignoreFurtherInvestigation) {
            return flowInfo;
        }
        return super.analyseCode(currentScope, flowContext, flowInfo);
    }

    private void createAst(BlockScope scope) {
        Expression allocation;
        if (this.isAstCreated) {
            return;
        }
        this.isAstCreated = true;
        ReferenceBinding baseclass = null;
        SourceTypeBinding enclType = scope.enclosingSourceType();
        AbstractMethodDeclaration enclMethodDecl = (AbstractMethodDeclaration)scope.methodScope().referenceContext;
        if (enclType.isDirectRole()) {
            baseclass = ((MemberTypeBinding)enclType).baseclass();
        }
        if (baseclass == null || !enclMethodDecl.isConstructor()) {
            scope.problemReporter().baseConstructorCallInWrongMethod(this, scope.methodScope().referenceContext);
            return;
        }
        ConstructorDeclaration enclCtor = (ConstructorDeclaration)enclMethodDecl;
        if (this.isExpression) {
            if (!this.isArgOfOtherCtor(enclCtor, scope)) {
                scope.problemReporter().baseConstructorExpressionOutsideCtorCall(this);
            }
        } else if (enclCtor.statements[0] != this) {
            scope.problemReporter().baseConstructorCallIsNotFirst(this);
        }
        AstGenerator gen = new AstGenerator(this.sourceStart, this.sourceEnd);
        if (this.enclosingInstance != null) {
            this.enclosingInstance = new PotentialLowerExpression(this.enclosingInstance, baseclass.enclosingType());
        }
        if (baseclass.isDirectRole()) {
            Expression receiver;
            if (RoleTypeBinding.isRoleWithExplicitAnchor(baseclass)) {
                RoleTypeBinding baseRole = (RoleTypeBinding)baseclass;
                ITeamAnchor anchor = baseRole._teamAnchor;
                ReferenceBinding startClass = anchor.getFirstDeclaringClass();
                char[][] tokens = anchor.tokens();
                if (startClass != null) {
                    TypeReference startReference = gen.typeReference(startClass);
                    startReference.setBaseclassDecapsulation(Expression.DecapsulationState.ALLOWED);
                    receiver = gen.qualifiedThisReference(startReference);
                    int i = 0;
                    while (i < tokens.length) {
                        receiver = gen.fieldReference(receiver, tokens[i]);
                        ++i;
                    }
                } else {
                    receiver = gen.qualifiedNameReference(tokens);
                }
            } else {
                receiver = this.enclosingInstance != null ? this.enclosingInstance : (TypeBinding.equalsEquals(baseclass.enclosingType(), enclType.enclosingType()) ? gen.thisReference() : gen.qualifiedThisReference(gen.typeReference(baseclass.enclosingType())));
            }
            char[] selector = CharOperation.concat(IOTConstants.CREATOR_PREFIX_NAME, baseclass.sourceName());
            MessageSend allocSend = new MessageSend(){

                @Override
                public boolean isDecapsulationAllowed(Scope scope2) {
                    return true;
                }

                @Override
                public Expression.DecapsulationState getBaseclassDecapsulation() {
                    return Expression.DecapsulationState.ALLOWED;
                }
            };
            gen.setPositions(allocSend);
            allocSend.receiver = receiver;
            allocSend.selector = selector;
            allocSend.arguments = this.arguments;
            allocSend.accessId = -1;
            allocation = allocSend;
        } else {
            AllocationExpression alloc = this.newAllocation(baseclass, gen);
            alloc.type.setBaseclassDecapsulation(Expression.DecapsulationState.ALLOWED);
            alloc.arguments = this.arguments;
            alloc.sourceStart = this.sourceStart;
            alloc.sourceEnd = this.sourceEnd;
            alloc.statementEnd = this.statementEnd;
            allocation = alloc;
        }
        this.arguments = null;
        ExplicitConstructorCall selfcall = enclCtor.constructorCall;
        if (selfcall.isImplicitSuper() && ((ReferenceBinding)enclType).superclass().isDirectRole() && ((ReferenceBinding)enclType).superclass().baseclass() != null) {
            enclCtor.constructorCall = this.genLiftCtorCall(allocation);
            enclCtor.statements[0] = new AstGenerator(this.sourceStart, this.sourceEnd).emptyStatement();
        } else if (this.isExpression) {
            this.expression = allocation;
        } else {
            this.expression = allocation;
            if (!enclType.roleModel.hasBaseclassProblem() && !scope.referenceType().ignoreFurtherInvestigation) {
                MethodModel.setCallsBaseCtor(enclCtor);
                RoleModel boundRootRoleModel = enclType.roleModel.getBoundRootRole();
                if (boundRootRoleModel == null) {
                    throw new InternalCompilerError("Unexpected: role has neither baseclassProblem nor boundRootRole");
                }
                Statement[] regStats = Lifting.genRoleRegistrationStatements(scope, boundRootRoleModel, baseclass, enclCtor, gen);
                int len = enclCtor.statements.length;
                Statement[] newStats = new Statement[len + regStats.length];
                newStats[0] = this;
                System.arraycopy(regStats, 0, newStats, 1, regStats.length);
                System.arraycopy(enclCtor.statements, 1, newStats, regStats.length + 1, len - 1);
                enclCtor.setStatements(newStats);
            }
        }
    }

    public static Expression convertToDynAccess(BlockScope scope, AllocationExpression expression, int accessId) {
        TypeBinding baseclass = expression.resolvedType;
        AstGenerator gen = new AstGenerator(expression);
        TypeReference receiver = gen.typeReference(baseclass);
        char[] selector = CalloutImplementorDyn.OT_ACCESS_STATIC;
        int modifiers = 9;
        Expression[] arguments = expression.arguments;
        Expression enclosingInstance = null;
        ReferenceBinding enclosingTeam = null;
        if (expression instanceof QualifiedAllocationExpression) {
            enclosingInstance = ((QualifiedAllocationExpression)expression).enclosingInstance;
        } else if (baseclass.isMemberType() && (enclosingTeam = scope.enclosingReceiverType().enclosingType()) != null && TypeBinding.equalsEquals(baseclass.enclosingType(), enclosingTeam.baseclass)) {
            enclosingInstance = gen.fieldReference(gen.qualifiedThisReference(gen.typeReference(enclosingTeam)), IOTConstants._OT_BASE);
            enclosingInstance.resolve(scope);
        }
        if (enclosingInstance != null) {
            if (arguments == null) {
                arguments = new Expression[]{enclosingInstance};
            } else {
                int len = arguments.length;
                Expression[] expressionArray = arguments;
                arguments = new Expression[len + 1];
                System.arraycopy(expressionArray, 0, arguments, 1, len);
                arguments[0] = enclosingInstance;
            }
        }
        MessageSend allocSend = new MessageSend(){

            @Override
            public boolean isDecapsulationAllowed(Scope scope2) {
                return true;
            }

            @Override
            public Expression.DecapsulationState getBaseclassDecapsulation() {
                return Expression.DecapsulationState.ALLOWED;
            }
        };
        gen.setPositions(allocSend);
        allocSend.receiver = receiver;
        allocSend.selector = selector;
        allocSend.constant = Constant.NotAConstant;
        allocSend.actualReceiverType = baseclass;
        allocSend.accessId = accessId;
        allocSend.arguments = BaseAllocationExpression.createResolvedAccessArguments(gen, accessId, arguments, enclosingTeam, scope);
        allocSend.binding = new MethodBinding(modifiers, new TypeBinding[]{TypeBinding.INT, TypeBinding.INT, scope.createArrayType(scope.getJavaLangObject(), 1), scope.getOrgObjectteamsITeam()}, Binding.NO_EXCEPTIONS, (ReferenceBinding)baseclass);
        allocSend.binding.returnType = scope.getJavaLangObject();
        allocSend.binding.selector = selector;
        return gen.resolvedCastExpression(allocSend, baseclass, 2);
    }

    private static Expression[] createResolvedAccessArguments(AstGenerator gen, int accessId, Expression[] arguments, ReferenceBinding enclosingTeam, BlockScope scope) {
        TeamModel.UpdatableIntLiteral accessIdLiteral = gen.updatableIntLiteral(accessId);
        accessIdLiteral.resolveType(scope);
        if (enclosingTeam != null) {
            enclosingTeam.getTeamModel().recordUpdatableAccessId(accessIdLiteral);
        }
        IntLiteral opKindLiteral = gen.intLiteral(0);
        opKindLiteral.resolveType(scope);
        Expression[] boxedArgs = null;
        if (arguments != null) {
            boxedArgs = new Expression[arguments.length];
            int i = 0;
            while (i < arguments.length) {
                Expression argument = arguments[i];
                if (argument.resolvedType.isPrimitiveType()) {
                    BaseTypeBinding baseType = (BaseTypeBinding)argument.resolvedType;
                    MessageSend boxingSend = gen.createBoxing(argument, baseType);
                    boxingSend.resolvedType = scope.environment().computeBoxingType(baseType);
                    boxingSend.binding = scope.getMethod(boxingSend.resolvedType, TypeConstants.VALUEOF, new TypeBinding[]{baseType}, boxingSend);
                    boxingSend.actualReceiverType = boxingSend.resolvedType;
                    boxingSend.argumentTypes = new TypeBinding[]{baseType};
                    boxingSend.constant = Constant.NotAConstant;
                    argument = boxingSend;
                }
                boxedArgs[i] = argument;
                ++i;
            }
        }
        ArrayAllocationExpression packedArgs = gen.arrayAllocation(gen.qualifiedTypeReference(TypeConstants.JAVA_LANG_OBJECT), boxedArgs != null ? 1 : 0, boxedArgs);
        ArrayBinding objectArray = scope.createArrayType(scope.getJavaLangObject(), 1);
        if (packedArgs.initializer != null) {
            packedArgs.initializer.binding = objectArray;
        } else {
            packedArgs.dimensions[0].resolveType(scope);
        }
        packedArgs.resolvedType = objectArray;
        packedArgs.constant = Constant.NotAConstant;
        Reference teamReference = gen.qualifiedThisReference(scope.enclosingSourceType().enclosingType());
        teamReference.resolveType(scope);
        return new Expression[]{accessIdLiteral, opKindLiteral, packedArgs, teamReference};
    }

    private boolean isArgOfOtherCtor(ConstructorDeclaration constructorDecl, BlockScope scope) {
        class NotFoundException
        extends RuntimeException {
            NotFoundException() {
            }
        }
        class FoundException
        extends RuntimeException {
            FoundException() {
            }
        }
        try {
            constructorDecl.traverse(new ASTVisitor(){
                int inCtorCall = 0;

                @Override
                public boolean visit(ExplicitConstructorCall ctorCall, BlockScope aScope) {
                    ++this.inCtorCall;
                    return super.visit(ctorCall, aScope);
                }

                @Override
                public void endVisit(ExplicitConstructorCall explicitConstructor, BlockScope aScope) {
                    super.endVisit(explicitConstructor, aScope);
                    --this.inCtorCall;
                }

                @Override
                public boolean visit(Assignment assig, BlockScope aScope) {
                    if (assig == BaseAllocationExpression.this) {
                        if (this.inCtorCall > 0) {
                            throw new FoundException();
                        }
                        throw new NotFoundException();
                    }
                    return super.visit(assig, aScope);
                }
            }, scope.classScope());
        }
        catch (FoundException foundException) {
            return true;
        }
        catch (NotFoundException notFoundException) {
            return false;
        }
        return false;
    }

    private AllocationExpression newAllocation(ReferenceBinding baseclass, AstGenerator gen) {
        if (this.enclosingInstance == null) {
            AllocationExpression alloc = new AllocationExpression();
            alloc.type = gen.typeReference(baseclass);
            return alloc;
        }
        QualifiedAllocationExpression alloc = new QualifiedAllocationExpression();
        alloc.enclosingInstance = this.enclosingInstance;
        alloc.type = gen.singleTypeReference(baseclass.sourceName);
        return alloc;
    }

    private ExplicitConstructorCall genLiftCtorCall(Expression baseExpr) {
        ExplicitConstructorCall constructorCall = new ExplicitConstructorCall(2);
        constructorCall.arguments = new Expression[]{baseExpr};
        constructorCall.sourceStart = this.sourceStart;
        constructorCall.sourceEnd = this.sourceEnd;
        return constructorCall;
    }

    public boolean checkGenerate(BlockScope scope) {
        if (this.checkResult != null) {
            return this.checkResult;
        }
        this.checkResult = Boolean.TRUE;
        this.checkResult = this.internalCheckGenerate(scope);
        return this.checkResult;
    }

    private boolean internalCheckGenerate(BlockScope scope) {
        if (scope == null) {
            return false;
        }
        ReferenceContext referenceContext = scope.methodScope().referenceContext;
        if (!(referenceContext instanceof AbstractMethodDeclaration)) {
            scope.problemReporter().baseConstructorCallInWrongMethod(this, referenceContext);
            return false;
        }
        AbstractMethodDeclaration enclosingMethodDeclaration = (AbstractMethodDeclaration)referenceContext;
        if (!enclosingMethodDeclaration.ignoreFurtherInvestigation) {
            this.createAst(scope);
            return this.expression != null;
        }
        return false;
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        TypeDeclaration enclType;
        TypeDeclaration typeDeclaration = enclType = scope != null ? scope.referenceType() : null;
        if (enclType != null && enclType.isDirectRole() && StateHelper.hasState(enclType.binding, 8)) {
            if (this.checkGenerate(scope)) {
                if (this.isExpression && this.expression != null) {
                    this.expression.traverse(visitor, scope);
                } else {
                    super.traverse(visitor, scope);
                }
            }
        } else if (this.expression != null) {
            super.traverse(visitor, scope);
        }
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        TypeDeclaration roleDecl = scope.referenceType();
        if (roleDecl != null && roleDecl.isRole() && roleDecl.getRoleModel()._playedByEnclosing) {
            scope.problemReporter().baseAllocationDespiteBaseclassCycle(this, roleDecl);
            return null;
        }
        if (!this.checkGenerate(scope)) {
            return null;
        }
        if (this.isExpression) {
            this.resolvedType = this.expression.resolveType(scope);
            return this.resolvedType;
        }
        if (!scope.methodScope().referenceContext.hasErrors()) {
            return super.resolveType(scope);
        }
        return null;
    }

    @Override
    public void computeConversion(Scope scope, TypeBinding runtimeType, TypeBinding compileTimeType) {
        if (this.isExpression) {
            this.expression.computeConversion(scope, runtimeType, compileTimeType);
        } else {
            super.computeConversion(scope, runtimeType, compileTimeType);
        }
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        if (this.isExpression) {
            this.expression.generateCode(currentScope, codeStream, valueRequired);
        } else {
            super.generateCode(currentScope, codeStream, valueRequired);
        }
    }

    @Override
    public String toString() {
        if (this.expression == null) {
            return "unresolved base() call";
        }
        return this.expression.toString();
    }

    @Override
    public StringBuilder printExpression(int indent, StringBuilder output) {
        if (this.expression != null) {
            return super.printExpression(indent, output);
        }
        return output.append("<no expression yet>");
    }

    @Override
    public StringBuilder printExpressionNoParenthesis(int indent, StringBuilder output) {
        if (this.expression != null) {
            return super.printExpressionNoParenthesis(indent, output);
        }
        return output.append("<no expression yet>");
    }
}

