/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.AbstractMethodMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.CallinMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.CalloutMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.FieldAccessSpec;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.MethodSpec;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.CallinCalloutBinding;

public class CallinCalloutScope
extends MethodScope {
    public CallinCalloutScope(ClassScope parent, ReferenceContext context) {
        super(parent, context, false);
        this.kind = 6;
        this.referenceContext = context;
    }

    public CallinCalloutBinding createBinding(AbstractMethodMappingDeclaration bindingDeclaration) {
        this.referenceContext = bindingDeclaration;
        bindingDeclaration.scope = this;
        SourceTypeBinding declaringClass = this.referenceType().binding;
        if (bindingDeclaration instanceof CallinMappingDeclaration) {
            CallinMappingDeclaration callinBindingDeclaration = (CallinMappingDeclaration)bindingDeclaration;
            bindingDeclaration.binding = new CallinCalloutBinding((ReferenceBinding)declaringClass, callinBindingDeclaration);
        } else {
            CalloutMappingDeclaration calloutBindingDeclaration = (CalloutMappingDeclaration)bindingDeclaration;
            int calloutModifier = 0;
            if (calloutBindingDeclaration.baseMethodSpec instanceof FieldAccessSpec) {
                calloutModifier = ((FieldAccessSpec)calloutBindingDeclaration.baseMethodSpec).calloutModifier;
            }
            bindingDeclaration.binding = new CallinCalloutBinding(calloutBindingDeclaration.isCalloutOverride(), null, declaringClass, calloutModifier, calloutBindingDeclaration.declaredModifiers);
        }
        TypeParameter[] typeParameters = bindingDeclaration.roleMethodSpec.typeParameters;
        bindingDeclaration.binding.typeVariables = typeParameters == null || this.compilerOptions().sourceLevel < 0x310000L ? Binding.NO_TYPE_VARIABLES : this.createTypeVariables(typeParameters, bindingDeclaration.binding);
        return bindingDeclaration.binding;
    }

    @Override
    public boolean connectTypeVariables(TypeParameter[] typeParameters, boolean checkForErasedCandidateCollisions) {
        return super.connectTypeVariables(typeParameters, checkForErasedCandidateCollisions);
    }

    @Override
    public TypeBinding getType(char[] name) {
        TypeVariableBinding typeVariable;
        AbstractMethodMappingDeclaration mapping = (AbstractMethodMappingDeclaration)this.referenceContext;
        if (mapping != null && mapping.binding != null && mapping.binding.isValidBinding() && (typeVariable = mapping.binding.getTypeVariable(name)) != null) {
            return typeVariable;
        }
        return this.parent.getType(name);
    }

    @Override
    public MethodBinding referenceMethodBinding() {
        if (this.referenceContext instanceof CalloutMappingDeclaration) {
            return ((CalloutMappingDeclaration)this.referenceContext).roleMethodSpec.resolvedMethod;
        }
        return super.referenceMethodBinding();
    }

    public static Binding maybeReResolveReference(SingleNameReference singleNameReference, Binding binding) {
        CallinCalloutScope mappingScope;
        if (!(binding instanceof LocalVariableBinding)) {
            return binding;
        }
        LocalVariableBinding localBinding = (LocalVariableBinding)binding;
        if (localBinding.declaringScope != null && localBinding.declaringScope.isMethodMappingWrapper() && (mappingScope = localBinding.declaringScope.methodScope().getDeclaringMappingScope()) != null) {
            binding = mappingScope.getSurfaceBinding(singleNameReference, singleNameReference.baseclassDecapsulation.isAllowed());
        }
        return binding;
    }

    private Binding getSurfaceBinding(SingleNameReference nameReference, boolean isBaseSide) {
        if (isBaseSide) {
            MethodSpec[] methodSpecArray = ((AbstractMethodMappingDeclaration)this.referenceContext).getBaseMethodSpecs();
            int n = methodSpecArray.length;
            int n2 = 0;
            while (n2 < n) {
                MethodSpec spec = methodSpecArray[n2];
                if (spec instanceof FieldAccessSpec) {
                    if (CharOperation.equals(((FieldAccessSpec)spec).selector, nameReference.token)) {
                        return ((FieldAccessSpec)spec).resolvedField;
                    }
                } else if (spec.arguments != null) {
                    Argument[] argumentArray = spec.arguments;
                    int n3 = spec.arguments.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Argument arg = argumentArray[n4];
                        if (CharOperation.equals(arg.name, nameReference.token)) {
                            return arg.binding;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        } else {
            MethodSpec spec = ((AbstractMethodMappingDeclaration)this.referenceContext).roleMethodSpec;
            if (spec.arguments != null) {
                Argument[] argumentArray = spec.arguments;
                int n = spec.arguments.length;
                int n5 = 0;
                while (n5 < n) {
                    Argument arg = argumentArray[n5];
                    if (CharOperation.equals(arg.name, nameReference.token)) {
                        return arg.binding;
                    }
                    ++n5;
                }
            }
        }
        if (isBaseSide) {
            return this.enclosingSourceType().baseclass().getField(nameReference.token, true);
        }
        return this.enclosingSourceType().getField(nameReference.token, true);
    }
}

