/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.search;

import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.internal.server.search.SearchScope;
import org.eclipse.orion.server.core.metastore.ProjectInfo;
import org.eclipse.orion.server.core.metastore.WorkspaceInfo;
import org.json.JSONException;
import org.json.JSONObject;

public class SearchResult
extends SearchScope {
    public SearchResult(IFileStore fileStore, WorkspaceInfo workspace, ProjectInfo project) {
        super(fileStore, workspace, project);
    }

    public JSONObject toJSON(String contextPath) throws URISyntaxException, JSONException, CoreException {
        JSONObject doc = new JSONObject();
        IFileInfo fileInfo = this.getFileStore().fetchInfo();
        doc.put("Name", (Object)fileInfo.getName());
        doc.put("Length", fileInfo.getLength());
        doc.put("Directory", fileInfo.isDirectory());
        doc.put("LastModified", fileInfo.getLastModified());
        IFileStore projectStore = this.getProject().getProjectStore();
        int projectLocationLength = projectStore.toURI().toString().length();
        IPath projectLocation = contextPath.length() != 0 ? new Path(contextPath).append("/file").append(this.getWorkspace().getUniqueId()).append(this.getProject().getFullName()).addTrailingSeparator() : new Path("/file").append(this.getWorkspace().getUniqueId()).append(this.getProject().getFullName()).addTrailingSeparator();
        String projectRelativePath = this.getFileStore().toURI().toString().substring(projectLocationLength);
        IPath fileLocation = projectLocation.append(projectRelativePath);
        doc.put("Location", (Object)fileLocation.toString());
        String projectName = this.getProject().getFullName();
        if (projectName != null) {
            doc.put("Path", (Object)new Path(projectName).append(projectRelativePath));
        }
        return doc;
    }
}

