/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.core.tasks;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.internal.server.core.tasks.TaskDescription;
import org.eclipse.orion.server.core.IOUtilities;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.resources.Base64;

public class TaskStore {
    private final File root;
    private static final String tempDirectory = "temp";

    public TaskStore(File root) {
        this.root = root;
        if (!root.exists()) {
            LogHelper.log((IStatus)new Status(1, "org.eclipse.orion.server.core", "Creating tasks folder " + root.toString()));
            if (!this.root.mkdirs()) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.core", "Problem creating tasks folder " + root.toString()));
            }
        }
    }

    private String getUserDirectory(String userId) {
        return new String(Base64.encode(userId.getBytes()));
    }

    private String getUserName(String userDirectoryName) {
        try {
            return new String(Base64.decode(userDirectoryName.getBytes()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public synchronized String readTask(TaskDescription td) {
        File directory = new File(this.root, this.getUserDirectory(td.getUserId()));
        if (!directory.exists()) {
            return null;
        }
        if (!td.isKeep() && !(directory = new File(directory, tempDirectory)).exists()) {
            return null;
        }
        File taskFile = new File(directory, td.getTaskId());
        if (!taskFile.exists()) {
            return null;
        }
        FileReader reader = null;
        try {
            reader = new FileReader(taskFile);
            StringWriter writer = new StringWriter();
            IOUtilities.pipe(reader, writer, true, false);
            String string = writer.toString();
            return string;
        }
        catch (IOException e) {
            LogHelper.log(e);
            return null;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LogHelper.log(e);
                    return null;
                }
            }
        }
    }

    public synchronized void writeTask(TaskDescription td, String representation) {
        try {
            File directory = new File(this.root, this.getUserDirectory(td.getUserId()));
            if (!directory.exists()) {
                directory.mkdir();
            }
            if (!td.isKeep() && !(directory = new File(directory, tempDirectory)).exists()) {
                directory.mkdir();
            }
            File taskFile = new File(directory, td.getTaskId());
            FileWriter writer = new FileWriter(taskFile);
            StringReader reader = new StringReader(representation);
            IOUtilities.pipe(reader, writer, true, true);
        }
        catch (IOException e) {
            LogHelper.log(e);
        }
    }

    public synchronized boolean removeTask(TaskDescription td) {
        File directory = new File(this.root, this.getUserDirectory(td.getUserId()));
        if (!directory.exists()) {
            return false;
        }
        if (!td.isKeep() && !(directory = new File(directory, tempDirectory)).exists()) {
            return false;
        }
        File taskFile = new File(directory, td.getTaskId());
        if (!taskFile.exists()) {
            return false;
        }
        return taskFile.delete();
    }

    private void delete(File f) throws IOException {
        if (f.isDirectory()) {
            File[] fileArray = f.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File c = fileArray[n2];
                this.delete(c);
                ++n2;
            }
        }
        if (!f.delete()) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.core", "Cannot delete file " + f.getName()));
        }
    }

    public synchronized void removeAllTempTasks() {
        File[] children = this.root.listFiles();
        if (children == null) {
            return;
        }
        File[] fileArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File userDirectory = fileArray[n2];
            if (userDirectory.isDirectory()) {
                this.removeAllTempTasks(userDirectory);
            }
            ++n2;
        }
    }

    private synchronized void removeAllTempTasks(File userDirectory) {
        if (!userDirectory.exists()) {
            return;
        }
        File directory = new File(userDirectory, tempDirectory);
        if (!directory.exists()) {
            return;
        }
        try {
            this.delete(directory);
        }
        catch (IOException e) {
            LogHelper.log(e);
        }
    }

    private List<TaskDescription> internalReadAllTasksDescriptions(File userDirectory) {
        ArrayList<TaskDescription> result = new ArrayList<TaskDescription>();
        String userId = this.getUserName(userDirectory.getName());
        if (userId == null) {
            return result;
        }
        File[] fileArray = userDirectory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File taskFile = fileArray[n2];
            if (taskFile.isFile()) {
                result.add(new TaskDescription(userId, taskFile.getName(), true));
            }
            ++n2;
        }
        return result;
    }

    public synchronized List<TaskDescription> readAllTasks(String userId) {
        File userDirectory = new File(this.root, this.getUserDirectory(userId));
        if (!userDirectory.exists()) {
            return new ArrayList<TaskDescription>();
        }
        return this.internalReadAllTasksDescriptions(userDirectory);
    }

    public synchronized List<TaskDescription> readAllTasks() {
        ArrayList<TaskDescription> result = new ArrayList<TaskDescription>();
        if (this.root.exists() && this.root.isDirectory()) {
            File[] fileArray = this.root.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File userDirectory = fileArray[n2];
                if (userDirectory.isDirectory()) {
                    result.addAll(this.internalReadAllTasksDescriptions(userDirectory));
                }
                ++n2;
            }
        } else {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.core", "Tasks folder is not a directory " + this.root.toString()));
        }
        return result;
    }
}

