/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.core.resources;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.orion.server.core.IOUtilities;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.osgi.util.NLS;

public class FileLocker {
    private File lockFile;
    private RandomAccessFile raFile = null;
    private int counter = 0;
    private FileLock fileLock = null;
    ReadWriteLock lock = new ReentrantReadWriteLock();
    private static final boolean locking = Boolean.parseBoolean(PreferenceHelper.getString("orion.file.content.locking"));

    public FileLocker(File toLock) {
        this.lockFile = toLock;
    }

    public Lock lock(boolean shared) throws IOException {
        try {
            if (shared) {
                this.lock.readLock().lock();
            } else {
                this.lock.writeLock().lock();
            }
            this.acquireLock(shared);
        }
        catch (IOException ioe) {
            if (shared) {
                this.lock.readLock().unlock();
            } else {
                this.lock.writeLock().unlock();
            }
            String specificMessage = NLS.bind((String)"An error occurred while locking file \"{0}\": \"{1}\". A common reason is that the file system or Runtime Environment does not support file locking for that location.", (Object[])new Object[]{this.fileLock, ioe.getMessage()});
            this.fileLock = null;
            throw new IOException(specificMessage, ioe);
        }
        return new Lock(shared);
    }

    private synchronized void acquireLock(boolean shared) throws IOException {
        try {
            boolean locked = false;
            do {
                if (locking && this.counter == 0) {
                    this.lockFile.getParentFile().mkdirs();
                    this.lockFile.createNewFile();
                    if (this.raFile == null) {
                        this.raFile = new RandomAccessFile(this.lockFile, "rw");
                    }
                    try {
                        this.fileLock = shared ? this.raFile.getChannel().lock(0L, 1L, true) : this.raFile.getChannel().lock(0L, 1L, false);
                        locked = true;
                    }
                    catch (OverlappingFileLockException overlappingFileLockException) {}
                    continue;
                }
                locked = true;
            } while (!locked);
            ++this.counter;
        }
        finally {
            if (this.fileLock == null) {
                IOUtilities.safeClose(this.raFile);
                this.raFile = null;
            }
        }
    }

    private synchronized void releaseLock() {
        if (--this.counter == 0) {
            if (!locking) {
                return;
            }
            if (this.fileLock != null) {
                try {
                    this.fileLock.release();
                }
                catch (IOException iOException) {}
            }
            if (this.raFile != null) {
                IOUtilities.safeClose(this.raFile);
            }
            this.raFile = null;
        }
    }

    public class Lock {
        private boolean isShared;

        public Lock(boolean isShared) {
            this.isShared = isShared;
        }

        public void release() {
            FileLocker.this.releaseLock();
            if (this.isShared) {
                FileLocker.this.lock.readLock().unlock();
            } else {
                FileLocker.this.lock.writeLock().unlock();
            }
        }
    }
}

