/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EContent;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EPosition;
import org.eclipse.mylyn.reviews.r4e.core.model.R4ETextPosition;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIPosition;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;

public class R4EUITextPosition
implements IR4EUIPosition {
    private R4ETextPosition fPosition;
    private int fOffset = 0;
    private int fLength = -1;
    private int fStartLine = -1;
    private int fEndLine = -1;
    private String fName = null;

    public R4EUITextPosition(int aOffset, int aLength, IFile aSourceFile) throws CoreException {
        this.setPositionValues(aOffset, aLength, this.getDocument(aSourceFile));
    }

    public R4EUITextPosition(int aOffset, int aLength, IDocument aDocument) {
        this.setPositionValues(aOffset, aLength, aDocument);
    }

    public R4EUITextPosition(int aOffset, int aLength, int aStartLine, int aEndLine) {
        this.fOffset = aOffset;
        this.fLength = aLength;
        this.fStartLine = aStartLine + 1;
        this.fEndLine = aEndLine + 1;
    }

    public R4EUITextPosition(R4EPosition aModelPosition) {
        this.fPosition = (R4ETextPosition)aModelPosition;
        this.fOffset = ((R4ETextPosition)aModelPosition).getStartPosition();
        this.fLength = ((R4ETextPosition)aModelPosition).getLength();
        this.fStartLine = ((R4ETextPosition)aModelPosition).getStartLine();
        this.fEndLine = ((R4ETextPosition)aModelPosition).getEndLine();
        this.fName = ((R4EContent)this.fPosition.eContainer()).getInfo();
    }

    public void setPositionInModel(R4EPosition aModelPosition) throws ResourceHandlingException, OutOfSyncException {
        this.fPosition = (R4ETextPosition)aModelPosition;
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fPosition, R4EUIModelController.getReviewer());
        this.fPosition.setStartLine(this.fStartLine);
        this.fPosition.setEndLine(this.fEndLine);
        this.fPosition.setStartPosition(this.fOffset);
        this.fPosition.setLength(this.fLength);
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        R4EContent content = (R4EContent)this.fPosition.eContainer();
        bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)content, R4EUIModelController.getReviewer());
        content.setInfo(this.fName);
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
    }

    private IDocument getDocument(IFile aSourceFile) throws CoreException {
        TextFileDocumentProvider provider = new TextFileDocumentProvider();
        provider.connect((Object)aSourceFile);
        return provider.getDocument((Object)aSourceFile);
    }

    private void setPositionValues(int aOffset, int aLength, IDocument aDocument) {
        try {
            if (aDocument != null) {
                this.fOffset = aOffset;
                this.fLength = aLength != -1 ? aLength : aDocument.getLength();
                this.fStartLine = aDocument.getLineOfOffset(this.fOffset) + 1;
                int endOffset = this.fOffset + this.fLength;
                if (this.fLength != 0) {
                    --endOffset;
                }
                this.fEndLine = aDocument.getLineOfOffset(endOffset) + 1;
                return;
            }
        }
        catch (BadLocationException e) {
            R4EUIPlugin.Ftracer.traceWarning("Exception: " + e.toString() + " (" + e.getMessage() + ").  " + "Setting text position to default values");
            R4EUIPlugin.getDefault().logWarning("Exception: " + e.toString(), (Exception)((Object)e));
            this.fEndLine = this.fStartLine;
            this.fLength = 0;
        }
    }

    public void setStartLine(int aStartLine) {
        this.fStartLine = aStartLine;
    }

    public int getStartLine() {
        return this.fStartLine;
    }

    public void setEndLine(int aEndLine) {
        this.fEndLine = aEndLine;
    }

    public int getEndLine() {
        return this.fEndLine;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public int getLength() {
        return this.fLength;
    }

    public void setName(String aName) {
        this.fName = aName;
    }

    public String getName() {
        return this.fName;
    }

    public boolean isSameAs(IR4EUIPosition aPosition) {
        return this.fOffset == ((R4EUITextPosition)aPosition).getOffset() && this.fLength == ((R4EUITextPosition)aPosition).getLength();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(28);
        if (this.fStartLine == this.fEndLine) {
            buffer.append("Line " + this.fStartLine);
        } else {
            buffer.append("Lines " + this.fStartLine + "-" + this.fEndLine);
        }
        if (this.fName != null) {
            buffer.append(" (" + this.fName + ")");
        }
        return buffer.toString();
    }
}

