/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EParticipant;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.IParticipantUnassignDialog;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIContent;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParticipantUnassignDialog
extends FormDialog
implements IParticipantUnassignDialog {
    private static final String UNASSIGN_PARTICIPANT_DIALOG_TITLE = "Select Participants to Unassign";
    private final List<R4EParticipant> fParticipantsUnassignValues = new ArrayList<R4EParticipant>();
    private IR4EUIModelElement fElement = null;
    private Table fParticipantsTable = null;

    public ParticipantUnassignDialog(Shell aParentShell, IR4EUIModelElement aElement) {
        super(aParentShell);
        this.fElement = aElement;
        this.setBlockOnOpen(true);
    }

    protected void buttonPressed(int aButtonId) {
        if (aButtonId == 0) {
            TableItem[] tableItemArray = this.fParticipantsTable.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (item.getChecked()) {
                    try {
                        R4EParticipant participant = R4EUIModelController.getActiveReview().getParticipant(item.getText(), false);
                        if (participant != null) {
                            this.fParticipantsUnassignValues.add(participant);
                        }
                    }
                    catch (ResourceHandlingException resourceHandlingException) {}
                }
                ++n2;
            }
        }
        super.buttonPressed(aButtonId);
    }

    protected void configureShell(Shell aShell) {
        super.configureShell(aShell);
        aShell.setText(UNASSIGN_PARTICIPANT_DIALOG_TITLE);
        aShell.setMinimumSize(200, 300);
    }

    @Override
    public void create() {
        this.fParticipantsUnassignValues.clear();
        super.create();
    }

    @Override
    public int open() {
        return super.open();
    }

    @Override
    public boolean close() {
        return super.close();
    }

    protected void createFormContent(IManagedForm aForm) {
        FormToolkit toolkit = aForm.getToolkit();
        ScrolledForm sform = aForm.getForm();
        sform.setExpandVertical(true);
        Composite composite = sform.getBody();
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        this.fParticipantsTable = toolkit.createTable(composite, 544);
        GridData tableData = new GridData(4, 4, true, true);
        this.fParticipantsTable.setLayoutData((Object)tableData);
        this.fParticipantsTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem[] items = ParticipantUnassignDialog.this.fParticipantsTable.getItems();
                ParticipantUnassignDialog.this.getButton(0).setEnabled(false);
                TableItem[] tableItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (item.getChecked()) {
                        ParticipantUnassignDialog.this.getButton(0).setEnabled(true);
                    }
                    ++n2;
                }
            }
        });
        EList assignedParticipants = null;
        if (this.fElement instanceof R4EUIReviewItem) {
            assignedParticipants = ((R4EUIReviewItem)this.fElement).getItem().getAssignedTo();
        } else if (this.fElement instanceof R4EUIFileContext) {
            assignedParticipants = ((R4EUIFileContext)this.fElement).getFileContext().getAssignedTo();
        } else if (this.fElement instanceof R4EUIContent) {
            assignedParticipants = ((R4EUIContent)this.fElement).getContent().getAssignedTo();
        } else {
            return;
        }
        for (String participant : assignedParticipants) {
            TableItem item = new TableItem(this.fParticipantsTable, 0);
            item.setText(participant);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control bar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return bar;
    }

    protected boolean isResizable() {
        return true;
    }

    @Override
    public List<R4EParticipant> getParticipants() {
        return this.fParticipantsUnassignValues;
    }
}

