/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.logging.base;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.rdf4j.common.logging.LogLevel;
import org.eclipse.rdf4j.common.logging.LogRecord;

public class SimpleLogRecord
implements LogRecord {
    private LogLevel level;
    private String message;
    private List<String> stackTrace;
    private String threadName;
    private Date time;

    @Override
    public LogLevel getLevel() {
        return this.level;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public List<String> getStackTrace() {
        return this.stackTrace;
    }

    @Override
    public String getThreadName() {
        return this.threadName;
    }

    @Override
    public Date getTime() {
        return this.time;
    }

    public void setLevel(LogLevel level) {
        this.level = level;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setStackTrace(List<String> stackTrace) {
        this.stackTrace = stackTrace;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append((Object)this.level);
        result.append(" ");
        result.append(LogRecord.ISO8601_TIMESTAMP_FORMAT.format(this.time));
        result.append(" (");
        result.append(this.threadName);
        result.append("): ");
        result.append(this.message);
        Iterator<String> tracerator = this.stackTrace.iterator();
        if (tracerator.hasNext()) {
            result.append("\n\t");
            result.append(tracerator.next());
            if (tracerator.hasNext()) {
                result.append("\n\t");
                result.append(tracerator.next());
                result.append("\n\t... " + (this.stackTrace.size() - 2) + " more lines");
            }
        }
        return result.toString();
    }
}

