/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.eclipse.rdf4j.common.io.IOUtil;

public class ResourceUtil {
    public static URL getURL(String resourceName) {
        Class<?> caller;
        URL result = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        if (result == null && (result = (caller = ResourceUtil.getCaller()).getResource(resourceName)) == null && (result = caller.getClassLoader().getResource(resourceName)) == null) {
            result = ClassLoader.getSystemResource(resourceName);
        }
        return result;
    }

    public static InputStream getInputStream(String resourceName) {
        Class<?> caller;
        InputStream result = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
        if (result == null && (result = (caller = ResourceUtil.getCaller()).getResourceAsStream(resourceName)) == null && (result = caller.getClassLoader().getResourceAsStream(resourceName)) == null) {
            result = ClassLoader.getSystemResourceAsStream(resourceName);
        }
        return result;
    }

    public static String getString(String resourceName) throws IOException {
        try (InputStream in = ResourceUtil.getInputStream(resourceName);){
            if (in == null) {
                String string = null;
                return string;
            }
            String string = IOUtil.readString(in);
            return string;
        }
    }

    public static Properties getProperties(String resourceName) throws IOException {
        URL resourceURL = ResourceUtil.getURL(resourceName);
        if (resourceURL != null) {
            try (InputStream in = resourceURL.openStream();){
                Properties result = new Properties();
                result.load(in);
                Properties properties = result;
                return properties;
            }
        }
        return null;
    }

    private static Class<?> getCaller() {
        Class result = ResourceUtil.class;
        Class<?>[] callStack = CallerResolver.INSTANCE.getClassContext();
        if (callStack.length > 0) {
            for (int index = 0; index < callStack.length && (result == ResourceUtil.class || result == CallerResolver.class); ++index) {
                result = callStack[index];
            }
        }
        return result;
    }

    private static final class CallerResolver
    extends SecurityManager {
        private static final CallerResolver INSTANCE;

        private CallerResolver() {
        }

        @Override
        protected Class<?>[] getClassContext() {
            return super.getClassContext();
        }

        static {
            try {
                INSTANCE = new CallerResolver();
            }
            catch (SecurityException se) {
                throw new RuntimeException("Could not create CallerResolver: " + String.valueOf(se));
            }
        }
    }
}

