/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.aggregate;

import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.parser.sparql.aggregate.AggregateCollector;

@Experimental
public abstract class StatisticCollector
implements AggregateCollector {
    protected static final Literal ZERO = SimpleValueFactory.getInstance().createLiteral("0", (CoreDatatype)CoreDatatype.XSD.INTEGER);
    protected final SummaryStatistics statistics;
    protected final boolean population;
    protected ValueExprEvaluationException typeError;

    public StatisticCollector(boolean population) {
        this.population = population;
        this.statistics = new SummaryStatistics();
    }

    public Value getFinalValue() throws ValueExprEvaluationException {
        if (this.typeError != null) {
            throw this.typeError;
        }
        return this.computeValue();
    }

    public void setTypeError(ValueExprEvaluationException typeError) {
        this.typeError = typeError;
    }

    public boolean hasError() {
        return this.typeError != null;
    }

    public void addValue(Literal val) {
        CoreDatatype.XSD type = (CoreDatatype.XSD)val.getCoreDatatype().asXSDDatatype().orElseThrow(() -> new IllegalArgumentException(String.valueOf(val) + " is not an XSD type literal"));
        if (type == CoreDatatype.XSD.DOUBLE) {
            this.statistics.addValue(val.doubleValue());
        } else if (type == CoreDatatype.XSD.FLOAT) {
            this.statistics.addValue((double)val.floatValue());
        } else {
            this.statistics.addValue(Double.parseDouble(val.getLabel()));
        }
    }

    protected abstract Literal computeValue();
}

