/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.eval;

import java.util.ArrayList;
import org.eclipse.actf.util.logging.DebugPrintUtil;
import org.eclipse.actf.visualization.eval.IChecker;
import org.eclipse.actf.visualization.eval.ICheckerInfoProvider;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;

public class CheckerExtension {
    private static final String EXTENSION_NAME = "checkers";
    private static final String CHECKER = "checker";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_INFO_PROVIDER = "infoprovider";
    private static CheckerExtension[] extensions;
    private static IChecker[] checkers;
    private static ICheckerInfoProvider[] infoProviders;
    private IChecker checker = null;
    private ICheckerInfoProvider infoProvider = null;
    private IConfigurationElement configElement = null;

    static {
        checkers = null;
        infoProviders = null;
    }

    public static IChecker[] getCheckers() {
        if (checkers != null) {
            return checkers;
        }
        CheckerExtension[] checkerExtensionArray = CheckerExtension.getExtensions();
        ArrayList<IChecker> arrayList = new ArrayList<IChecker>();
        if (checkerExtensionArray != null) {
            int n = 0;
            while (n < checkerExtensionArray.length) {
                IChecker iChecker = checkerExtensionArray[n].getChecker();
                if (iChecker != null) {
                    arrayList.add(iChecker);
                }
                ++n;
            }
        }
        checkers = new IChecker[arrayList.size()];
        arrayList.toArray(checkers);
        return checkers;
    }

    public static ICheckerInfoProvider[] getCheckerInfoProviders() {
        if (infoProviders != null) {
            return infoProviders;
        }
        CheckerExtension[] checkerExtensionArray = CheckerExtension.getExtensions();
        ArrayList<ICheckerInfoProvider> arrayList = new ArrayList<ICheckerInfoProvider>();
        if (checkerExtensionArray != null) {
            int n = 0;
            while (n < checkerExtensionArray.length) {
                ICheckerInfoProvider iCheckerInfoProvider = checkerExtensionArray[n].getCheckerInfoProvider();
                if (iCheckerInfoProvider != null) {
                    arrayList.add(iCheckerInfoProvider);
                }
                ++n;
            }
        }
        infoProviders = new ICheckerInfoProvider[arrayList.size()];
        arrayList.toArray(infoProviders);
        return infoProviders;
    }

    private static CheckerExtension[] getExtensions() {
        if (extensions != null) {
            return extensions;
        }
        IExtension[] iExtensionArray = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.actf.visualization.eval", EXTENSION_NAME).getExtensions();
        DebugPrintUtil.devOrDebugPrintln((Object)("Checker extensions:" + iExtensionArray.length));
        ArrayList<CheckerExtension> arrayList = new ArrayList<CheckerExtension>();
        int n = 0;
        while (n < iExtensionArray.length) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                CheckerExtension checkerExtension = CheckerExtension.parseExtension(iConfigurationElementArray[n2]);
                if (checkerExtension != null) {
                    arrayList.add(checkerExtension);
                }
                ++n2;
            }
            ++n;
        }
        extensions = arrayList.toArray(new CheckerExtension[arrayList.size()]);
        return extensions;
    }

    private static CheckerExtension parseExtension(IConfigurationElement iConfigurationElement) {
        if (!iConfigurationElement.getName().equals(CHECKER)) {
            return null;
        }
        try {
            return new CheckerExtension(iConfigurationElement);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private CheckerExtension(IConfigurationElement iConfigurationElement) {
        this.configElement = iConfigurationElement;
        try {
            this.infoProvider = (ICheckerInfoProvider)iConfigurationElement.createExecutableExtension(ATTR_INFO_PROVIDER);
        }
        catch (Exception exception) {}
    }

    private IChecker getChecker() {
        if (this.checker == null) {
            try {
                this.checker = (IChecker)this.configElement.createExecutableExtension(ATTR_CLASS);
            }
            catch (Exception exception) {}
        }
        return this.checker;
    }

    private ICheckerInfoProvider getCheckerInfoProvider() {
        return this.infoProvider;
    }
}

