/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.testing.internal.miniunit;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.ruby.ast.RubyClassDeclaration;
import org.eclipse.dltk.ruby.testing.internal.AbstractRubyTestingEngine;
import org.eclipse.dltk.ruby.testing.internal.AbstractTestingEngineValidateVisitor;
import org.eclipse.dltk.ruby.testing.internal.Messages;
import org.eclipse.dltk.ruby.testing.internal.ResolverUtils;
import org.eclipse.dltk.ruby.testing.internal.RubyTestingLaunchConfigurationDelegate;
import org.eclipse.dltk.ruby.testing.internal.miniunit.MiniTestRunnerUI;
import org.eclipse.dltk.testing.ITestRunnerUI;
import org.eclipse.osgi.util.NLS;

public class MiniTestingEngine
extends AbstractRubyTestingEngine {
    static final String MINITEST_RUNNER = "dltk-minitest-runner.rb";

    public IStatus validateSourceModule(ISourceModule module) {
        ModuleDeclaration declaration = ResolverUtils.parse(module);
        if (declaration == null) {
            return MiniTestingEngine.createStatus(2, Messages.validate_sourceErrors);
        }
        TestUnitValidateVisitor visitor = new TestUnitValidateVisitor(module);
        try {
            declaration.traverse((ASTVisitor)visitor);
        }
        catch (Exception e) {
            return MiniTestingEngine.createStatus(2, NLS.bind((String)Messages.validate_runtimeError, (Object)e.getMessage()));
        }
        return visitor.getStatus();
    }

    public void configureLaunch(InterpreterConfig config, ILaunchConfiguration configuration, ILaunch launch) throws CoreException {
        String strPort = String.valueOf(this.allocatePort());
        launch.setAttribute("org.eclipse.dltk.testing.PORT", strPort);
        config.addEnvVar("RUBY_TESTING_PORT", strPort);
        if (!RubyTestingLaunchConfigurationDelegate.isContainerMode(configuration)) {
            if (config.getEnvironment().isLocal()) {
                String runnerName = MINITEST_RUNNER;
                if (!this.isDevelopmentMode(config, MINITEST_RUNNER)) {
                    File runnerFile = this.getRunnerFile(this.getBundle(), "/testing/", MINITEST_RUNNER);
                    config.addInterpreterArg("-r");
                    config.addInterpreterArg(runnerFile.getPath());
                }
            }
        } else {
            String containerHandle = configuration.getAttribute("org.eclipse.dltk.testing.CONTAINER", "");
            Assert.isLegal((containerHandle.length() != 0 ? 1 : 0) != 0);
            IModelElement element = DLTKCore.create((String)containerHandle);
            Assert.isNotNull((Object)element);
            IResource resource = element.getUnderlyingResource();
            Assert.isNotNull((Object)resource);
            IPath path = resource.getProjectRelativePath();
            if (path.isEmpty()) {
                config.addEnvVar("RUBY_TESTING_PATH", ".");
            } else {
                config.addEnvVar("RUBY_TESTING_PATH", path.toOSString());
            }
        }
    }

    public String getMainScriptPath(ILaunchConfiguration configuration, IEnvironment scriptEnvironment) throws CoreException {
        if (RubyTestingLaunchConfigurationDelegate.isContainerMode(configuration)) {
            return this.getRunnerFile(this.getBundle(), "/testing/", MINITEST_RUNNER).getPath();
        }
        return null;
    }

    public ITestRunnerUI getTestRunnerUI(IScriptProject project, ILaunchConfiguration configuration) {
        return new MiniTestRunnerUI(this, project);
    }

    static class TestUnitValidateVisitor
    extends AbstractTestingEngineValidateVisitor {
        private static final String MINITEST_AUTORUN = "minitest/autorun";
        private static final String MINITEST_TEST = "Minitest::Test";
        private static final String TEST = "test";
        private ISourceModule module;
        private int testUnitWeight = 0;
        static final int REQUIRE_WEIGHT = 10;
        static final int TESTCASE_WEIGHT = 10;
        static final int METHOD_WEIGHT = 1;

        public TestUnitValidateVisitor(ISourceModule module) {
            this.module = module;
        }

        @Override
        public boolean visitGeneral(ASTNode node) throws Exception {
            if (node instanceof CallExpression) {
                CallExpression call = (CallExpression)node;
                if (this.isRequire(call, MINITEST_AUTORUN)) {
                    this.testUnitWeight += 10;
                }
            } else if (node instanceof RubyClassDeclaration) {
                if (this.isSuperClassOf(this.module, (RubyClassDeclaration)node, MINITEST_TEST)) {
                    this.testUnitWeight += 10;
                }
            } else if (node instanceof MethodDeclaration && this.isNodeOnStack(RubyClassDeclaration.class) && this.isMethodPrefix((MethodDeclaration)node, TEST)) {
                ++this.testUnitWeight;
            }
            return super.visitGeneral(node);
        }

        public IStatus getStatus() {
            if (this.testUnitWeight >= Math.min(10, 10)) {
                return Status.OK_STATUS;
            }
            if (this.testUnitWeight >= 1) {
                return MiniTestingEngine.createStatus(1, Messages.validate_probablyMinitest);
            }
            return MiniTestingEngine.createStatus(2, Messages.validate_notMinitest);
        }
    }
}

