/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;

public class ProjectMetadataBackup {
    private static final String DOT = ".";
    private final Map<BackupKey, File> entries = new HashMap<BackupKey, File>();

    public void backup(URI projectLocation, String[] filenames) throws CoreException {
        IFileStore folder = EFS.getStore((URI)projectLocation);
        if (folder.fetchInfo().exists()) {
            int i = 0;
            while (i < filenames.length) {
                String filename = filenames[i];
                BackupKey key = new BackupKey(projectLocation, filename);
                if (!this.entries.containsKey(key)) {
                    IFileStore file = folder.getChild(filename);
                    if (file.fetchInfo().exists()) {
                        String tmp = filename;
                        if (tmp.startsWith(DOT)) {
                            tmp = tmp.substring(DOT.length());
                        }
                        tmp = "eclipse-" + tmp + "-";
                        File backup = this.createBackup(file, tmp);
                        this.entries.put(key, backup);
                    } else {
                        this.entries.put(key, null);
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < filenames.length) {
                BackupKey key = new BackupKey(projectLocation, filenames[i]);
                if (!this.entries.containsKey(key)) {
                    this.entries.put(key, null);
                }
                ++i;
            }
        }
    }

    public void restore(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", this.entries.size() * 2);
        try {
            for (Map.Entry<BackupKey, File> entry : this.entries.entrySet()) {
                try {
                    File backup = entry.getValue();
                    if (backup == null) {
                        monitor.worked(2);
                        continue;
                    }
                    IFileStore projectFile = EFS.getStore((URI)entry.getKey().location).getChild(entry.getKey().filename);
                    projectFile.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    this.copyFile(backup, projectFile, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    backup.delete();
                }
                catch (IOException e) {
                    Status status = new Status(4, "org.eclipse.dltk.ui", 4, NewWizardMessages.ScriptProjectWizardSecondPage_problem_restore_project, (Throwable)e);
                    throw new CoreException((IStatus)status);
                }
            }
        }
        finally {
            this.entries.clear();
        }
    }

    private File createBackup(IFileStore source, String name) throws CoreException {
        try {
            File bak = File.createTempFile(name, ".bak");
            this.copyFile(source, bak);
            return bak;
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.dltk.ui", 4, Messages.format(NewWizardMessages.ScriptProjectWizardSecondPage_problem_backup, name), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private void copyFile(IFileStore source, File target) throws IOException, CoreException {
        InputStream is = source.openInputStream(0, null);
        FileOutputStream os = new FileOutputStream(target);
        this.copyFile(is, os);
    }

    private void copyFile(File source, IFileStore target, IProgressMonitor monitor) throws IOException, CoreException {
        FileInputStream is = new FileInputStream(source);
        OutputStream os = target.openOutputStream(0, monitor);
        this.copyFile(is, os);
    }

    private void copyFile(InputStream is, OutputStream os) throws IOException {
        try {
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = is.read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
        }
        finally {
            try {
                is.close();
            }
            finally {
                os.close();
            }
        }
    }

    private static class BackupKey {
        final URI location;
        final String filename;

        public BackupKey(URI location, String filename) {
            this.location = location;
            this.filename = filename;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.filename.hashCode();
            result = 31 * result + this.location.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (obj instanceof BackupKey) {
                BackupKey other = (BackupKey)obj;
                return this.filename.equals(other.filename) && this.location.equals(other.location);
            }
            return false;
        }
    }
}

