/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.core.builtin.debugger;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.http.ConnectionClosedException;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpServerConnection;
import org.apache.http.impl.DefaultBHttpServerConnection;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerMapper;
import org.apache.http.protocol.HttpService;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.apache.http.protocol.UriHttpRequestHandlerMapper;

public class HttpReverseProxyServer {
    private static final String HTTP_CONN_KEEPALIVE = "http.proxy.conn-keepalive";
    private static final String HTTP_IN_CONN = "HTTP_IN_CONN";
    private RequestListenerThread fThread;
    private IHttpRequestHandler fHandler;

    public HttpReverseProxyServer(IHttpRequestHandler handler) {
        this.fHandler = handler;
    }

    public void start(int port) throws Exception {
        this.fThread = new RequestListenerThread(port);
        this.fThread.setHttpRequestHandler(this.fHandler);
        this.fThread.setDaemon(false);
        this.fThread.start();
    }

    public void stop() {
        try {
            if (this.fThread != null) {
                this.fThread.stopServer();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static interface ConnectionClosedHandler {
        public void notifyConnectionClosed(HttpServerConnection var1);
    }

    public static interface IHttpRequestHandler {
        public void handle(HttpRequest var1, HttpResponse var2, HttpContext var3) throws HttpException, IOException;

        public void close(HttpServerConnection var1) throws IOException;
    }

    static class ProxyHandler
    implements HttpRequestHandler,
    ConnectionClosedHandler {
        private IHttpRequestHandler fHttpRequestHandler;

        ProxyHandler() {
        }

        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            if (this.fHttpRequestHandler != null) {
                this.fHttpRequestHandler.handle(request, response, context);
            }
        }

        public void setHttpRequestHandler(IHttpRequestHandler requestHandler) {
            this.fHttpRequestHandler = requestHandler;
        }

        @Override
        public void notifyConnectionClosed(HttpServerConnection connection) {
            try {
                if (this.fHttpRequestHandler != null) {
                    this.fHttpRequestHandler.close(connection);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static class ProxyThread
    extends Thread {
        private final HttpService httpservice;
        private final HttpServerConnection inconn;
        private final ProxyHandler handler;

        public ProxyThread(HttpService httpservice, HttpServerConnection inconn, ProxyHandler handler) {
            this.httpservice = httpservice;
            this.inconn = inconn;
            this.handler = handler;
        }

        @Override
        public void run() {
            BasicHttpContext context = new BasicHttpContext(null);
            try {
                try {
                    while (!Thread.interrupted()) {
                        if (!this.inconn.isOpen()) {
                            this.handler.notifyConnectionClosed(this.inconn);
                            break;
                        }
                        context.setAttribute(HttpReverseProxyServer.HTTP_IN_CONN, (Object)this.inconn);
                        this.httpservice.handleRequest(this.inconn, (HttpContext)context);
                        context.setAttribute(HttpReverseProxyServer.HTTP_CONN_KEEPALIVE, (Object)true);
                    }
                }
                catch (ConnectionClosedException connectionClosedException) {
                    this.handler.notifyConnectionClosed(this.inconn);
                    try {
                        this.inconn.shutdown();
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (IOException iOException) {
                    this.handler.notifyConnectionClosed(this.inconn);
                    try {
                        this.inconn.shutdown();
                    }
                    catch (IOException iOException2) {
                    }
                }
                catch (HttpException httpException) {
                    this.handler.notifyConnectionClosed(this.inconn);
                    try {
                        this.inconn.shutdown();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                this.handler.notifyConnectionClosed(this.inconn);
                try {
                    this.inconn.shutdown();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static class RequestListenerThread
    extends Thread {
        private ServerSocket serversocket;
        private HttpService httpService;
        private ProxyHandler handler;
        private boolean isRunning = false;

        public RequestListenerThread(int port) throws IOException {
            this.setName("PHP Debugger Proxy Server");
            this.serversocket = new ServerSocket(port);
            ImmutableHttpProcessor inhttpproc = new ImmutableHttpProcessor(new HttpRequestInterceptor[]{new RequestContent(), new RequestTargetHost(), new RequestConnControl(), new RequestUserAgent("PHP Debugger Proxy Server/1.1"), new RequestExpectContinue(true)});
            this.handler = new ProxyHandler();
            UriHttpRequestHandlerMapper reqistry = new UriHttpRequestHandlerMapper();
            reqistry.register("*", (HttpRequestHandler)this.handler);
            this.httpService = new HttpService((HttpProcessor)inhttpproc, (HttpRequestHandlerMapper)reqistry);
        }

        public void setHttpRequestHandler(IHttpRequestHandler requestHandler) {
            this.handler.setHttpRequestHandler(requestHandler);
        }

        @Override
        public void run() {
            this.isRunning = true;
            while (this.isRunning) {
                try {
                    int bufsize = 524288;
                    Socket insocket = this.serversocket.accept();
                    DefaultBHttpServerConnection inconn = new DefaultBHttpServerConnection(524288);
                    inconn.bind(insocket);
                    ProxyThread t = new ProxyThread(this.httpService, (HttpServerConnection)inconn, this.handler);
                    t.setDaemon(true);
                    t.start();
                }
                catch (InterruptedIOException ex) {
                    break;
                }
                catch (IOException e) {
                    break;
                }
            }
        }

        public void stopServer() throws IOException {
            if (this.serversocket != null) {
                this.isRunning = false;
                this.serversocket.close();
                this.serversocket = null;
            }
        }
    }
}

