/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpLogger;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpUtils;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.EngineTypes;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DBGpResponse {
    public static final String STATUS_STARTING = "starting";
    public static final String STATUS_STOPPING = "stopping";
    public static final String STATUS_STOPPED = "stopped";
    public static final String STATUS_RUNNING = "running";
    public static final String STATUS_BREAK = "break";
    public static final String REASON_OK = "ok";
    public static final String REASON_ERROR = "error";
    public static final String REASON_ABORTED = "aborted";
    public static final String REASON_EXCEPTION = "exception";
    private DocumentBuilder db;
    private Document doc;
    private Node parent;
    public static final int PARSE_FAILURE = 0;
    public static final int INIT = 1;
    public static final int RESPONSE = 2;
    public static final int STREAM = 3;
    public static final int PROXY_INIT = 4;
    public static final int PROXY_ERROR = 5;
    public static final int UNKNOWN_TYPE = 99;
    int type;
    private String idekey;
    private String session;
    private String threadId;
    private String engineVersion = "";
    private EngineTypes engineType = EngineTypes.other;
    private String fileUri;
    private String id;
    private String command;
    private String status;
    private String reason;
    public static final int ERROR_OK = 0;
    public static final int ERROR_CANT_PERFORM_EVAL = 206;
    public static final int ERROR_CANT_GET_PROPERTY = 300;
    public static final int ERROR_UNKNOWN_ERROR_CODE = 10000;
    public static final int ERROR_UNKNOWN_TYPE = 10001;
    public static final int ERROR_PARSE_FAILURE = 10002;
    public static final int ERROR_INVALID_RESPONSE = 10003;
    int errorCode;
    String errorMessage;
    private String streamType;
    private String streamData;
    private byte[] rawXML;

    public DBGpResponse() {
        DocumentBuilderFactory dbFact = DocumentBuilderFactory.newInstance();
        try {
            this.db = dbFact.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            DBGpLogger.logException(null, this, e);
        }
    }

    public void parseResponse(byte[] xmlResponse) {
        this.rawXML = xmlResponse;
        if (this.db != null && xmlResponse != null) {
            ByteArrayInputStream bais = new ByteArrayInputStream(xmlResponse);
            this.parseResponse(bais);
        } else {
            this.type = 0;
            this.errorCode = 10002;
        }
    }

    private void parseResponse(InputStream is) {
        this.id = null;
        this.command = null;
        this.type = 99;
        this.errorCode = 10001;
        try {
            this.doc = this.db.parse(is);
            this.parent = this.doc.getFirstChild();
            String nodeName = this.parent.getNodeName();
            if (nodeName.equals("response")) {
                this.parseResponseType();
            } else if (nodeName.equals("init")) {
                this.parseInitType();
            } else if (nodeName.equals("stream")) {
                this.parseStreamType();
            } else if (nodeName.equals("proxyinit")) {
                this.parseProxyInitType();
            } else if (nodeName.equals("proxyerror")) {
                this.parseProxyErrorType();
            }
        }
        catch (SAXException e) {
            DBGpLogger.logException(null, this, e);
            this.type = 0;
            this.errorCode = 10002;
        }
        catch (IOException e) {
            DBGpLogger.logException(null, this, e);
            this.type = 0;
            this.errorCode = 10002;
        }
    }

    private void parseStreamType() {
        this.type = 3;
        this.streamType = this.getTopAttribute("type");
        Node Child = this.parent.getFirstChild();
        if (Child != null) {
            this.streamData = Child.getNodeValue();
        }
        this.errorCode = this.streamType.length() != 0 ? 0 : 10003;
    }

    private void parseProxyInitType() {
        this.type = 4;
        this.idekey = this.getTopAttribute("idekey");
        this.getErrorInformation(false);
    }

    private void parseProxyErrorType() {
        this.type = 5;
        this.getErrorInformation(false);
    }

    private void parseInitType() {
        this.type = 1;
        this.idekey = this.getTopAttribute("idekey");
        this.threadId = this.getTopAttribute("thread");
        this.session = this.getTopAttribute("session");
        if (this.session.trim().length() == 0) {
            this.session = null;
        }
        this.fileUri = this.getTopAttribute("fileuri");
        NodeList nodes = this.parent.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("engine")) {
                String engineTypeStr;
                this.engineVersion = DBGpResponse.getAttribute(node, "version");
                NodeList moreNodes = node.getChildNodes();
                if (moreNodes != null && moreNodes.getLength() > 0 && (engineTypeStr = moreNodes.item(0).getNodeValue()) != null) {
                    try {
                        this.engineType = EngineTypes.valueOf(engineTypeStr);
                    }
                    catch (IllegalArgumentException e) {
                        this.engineType = EngineTypes.other;
                    }
                }
                i = nodes.getLength();
            }
            ++i;
        }
        this.errorCode = this.idekey.length() != 0 && this.fileUri.length() != 0 ? 0 : 10003;
    }

    private void parseResponseType() {
        this.type = 2;
        this.id = this.getTopAttribute("transaction_id");
        this.command = this.getTopAttribute("command");
        this.status = this.getTopAttribute("status");
        this.reason = this.getTopAttribute("reason");
        this.getErrorInformation(true);
    }

    private void getErrorInformation(boolean checkID) {
        Node errNode = this.parent.getFirstChild();
        if (errNode != null && errNode.getNodeName().equals(REASON_ERROR)) {
            Node dataNode;
            String errVal = DBGpResponse.getAttribute(errNode, "code");
            try {
                this.errorCode = Integer.parseInt(errVal);
            }
            catch (NumberFormatException nfe) {
                this.errorCode = 10000;
            }
            Node msgNode = errNode.getFirstChild();
            if (msgNode != null && (dataNode = msgNode.getFirstChild()) != null) {
                this.errorMessage = dataNode.getNodeValue();
            }
        } else {
            this.errorCode = 0;
            if (checkID && (this.id == null || this.id.length() == 0)) {
                this.errorCode = 10003;
            }
        }
    }

    public Node getParentNode() {
        return this.doc.getFirstChild();
    }

    public String getTopAttribute(String attrName) {
        return DBGpResponse.getAttribute(this.parent, attrName);
    }

    public static String getAttribute(@NonNull Node node, @NonNull String attrName) {
        return DBGpResponse.getAttribute(node, attrName, null);
    }

    public static String getAttribute(@NonNull Node node, @NonNull String attrName, @Nullable String encodingCharset) {
        String attrValue = "";
        if (node != null && node.hasAttributes()) {
            NamedNodeMap attrs = node.getAttributes();
            Node attribute = attrs.getNamedItem(attrName);
            if (attribute != null) {
                attrValue = attribute.getNodeValue();
            } else if (encodingCharset != null && node.hasChildNodes()) {
                NodeList childProperties = node.getChildNodes();
                int nbChildrens = childProperties.getLength();
                int i = nbChildrens - 1;
                while (i >= 0) {
                    Node childProperty = childProperties.item(i);
                    if (childProperty.getNodeName().equals(attrName)) {
                        attrValue = DBGpUtils.getEncodedStringValue(childProperty, encodingCharset);
                        break;
                    }
                    --i;
                }
            }
        }
        return attrValue;
    }

    public String getCommand() {
        return this.command;
    }

    public String getId() {
        return this.id;
    }

    public String getReason() {
        return this.reason;
    }

    public String getStatus() {
        return this.status;
    }

    public int getType() {
        return this.type;
    }

    public String getFileUri() {
        return this.fileUri;
    }

    public String getIdekey() {
        return this.idekey;
    }

    public String getSession() {
        return this.session;
    }

    public String getThreadId() {
        return this.threadId;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public String getStreamData() {
        return this.streamData;
    }

    public String getStreamType() {
        return this.streamType;
    }

    public byte[] getRawXML() {
        return this.rawXML;
    }

    public EngineTypes getEngineType() {
        return this.engineType;
    }
}

