/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pmf.pim.tests.initialize;

import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.validation.service.IValidationListener;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.pmf.model.checkrules.manager.CheckRuleManager;
import org.eclipse.pmf.pim.Application;
import org.eclipse.pmf.pim.PMFPackage;
import org.eclipse.pmf.pim.tests.initialize.UniversalValidationListener;
import org.eclipse.pmf.pim.util.PMFValidator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ValidationTest {
    private Application application;
    private final EValidator pmfValidator = EValidator.Registry.INSTANCE.getEValidator((EPackage)PMFPackage.eINSTANCE);
    private PMFValidator validator = (PMFValidator)this.pmfValidator;

    @Before
    public void setUp() {
        ModelValidationService.getInstance().addValidationListener((IValidationListener)new UniversalValidationListener());
    }

    @Test
    public void test_CircularReference_CheckRuleManager() {
        this.waitForJobs();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI uri = URI.createURI((String)"platform:/plugin/org.eclipse.pmf.pim.tests/src/org/eclipse/pmf/pim/tests/initialize/PMFModelTest.pmf");
        Resource resource = resourceSet.getResource(uri, true);
        CheckRuleManager manager = new CheckRuleManager(resource);
        IStatus status = manager.invokeModelChecking();
        Assert.assertEquals((Object)"A Cycle referenced dataforms:  has been found to have circular references.", (Object)status.getChildren()[0].getMessage());
    }

    @Test
    public void test_Enable_Disable_Constraint() {
        this.waitForJobs();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI uri = URI.createURI((String)"platform:/plugin/org.eclipse.pmf.pim.tests/src/org/eclipse/pmf/pim/tests/initialize/PMFModelTest.pmf");
        Resource resource = resourceSet.getResource(uri, true);
        CheckRuleManager manager = new CheckRuleManager(resource);
        IStatus status = manager.invokeModelChecking();
        Assert.assertEquals((long)382L, (long)status.getChildren().length);
        manager.disableConstraint("org.eclipse.pmf.model.checkrules.org.eclipse.pmf.validation.ui.NoCircular");
        IStatus status2 = manager.invokeModelChecking();
        Assert.assertEquals((long)382L, (long)status2.getChildren().length);
        manager.enableConstraint("org.eclipse.pmf.model.checkrules.org.eclipse.pmf.validation.ui.NoCircular");
        IStatus status3 = manager.invokeModelChecking();
        Assert.assertEquals((long)382L, (long)status3.getChildren().length);
    }

    @Test
    public void test_Enable_Disable_Live_Mode() {
        this.waitForJobs();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI uri = URI.createURI((String)"platform:/plugin/org.eclipse.pmf.pim.tests/src/org/eclipse/pmf/pim/tests/initialize/PMFModelTest.pmf");
        Resource resource = resourceSet.getResource(uri, true);
        this.application = (Application)resource.getContents().get(0);
        CheckRuleManager manager = new CheckRuleManager(resource);
        manager.enableAutoChecking();
        assert (PlatformUI.isWorkbenchRunning()) : "The workbench must be up in order for this test to make any sense.";
        this.application.setName("e");
        this.application.setName(null);
        Assert.assertTrue((UniversalValidationListener.LAST_EVENT != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)UniversalValidationListener.LAST_EVENT, (Object)"[org.eclipse.pmf.validation.ui.libraryContext]");
    }

    @Test
    public void testCircularReference() {
        this.waitForJobs();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI uri = URI.createURI((String)"platform:/plugin/org.eclipse.pmf.pim.tests/src/org/eclipse/pmf/pim/tests/initialize/PMFModelTest.pmf");
        Resource resource = resourceSet.getResource(uri, true);
        this.application = (Application)resource.getContents().get(0);
        BasicDiagnostic diagnostic = new BasicDiagnostic();
        Boolean result1 = this.validator.validateApplication(this.application, (DiagnosticChain)diagnostic, new HashMap());
        int errors1 = 0;
        for (Diagnostic d : diagnostic.getChildren()) {
            if (d.getCode() != 20) continue;
            ++errors1;
        }
        Assert.assertTrue((errors1 >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void testNamingConflict() {
        this.waitForJobs();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI uri = URI.createURI((String)"platform:/plugin/org.eclipse.pmf.pim.tests/src/org/eclipse/pmf/pim/tests/initialize/PMFModelTest.pmf");
        Resource resource = resourceSet.getResource(uri, true);
        CheckRuleManager manager = new CheckRuleManager(resource);
        IStatus status = manager.invokeModelChecking();
        Assert.assertEquals((long)382L, (long)status.getChildren().length);
        manager.disableConstraint("org.eclipse.pmf.model.checkrules.org.eclipse.pmf.validation.ui.NoNameConflictConstraint");
        IStatus status2 = manager.invokeModelChecking();
        Assert.assertEquals((long)378L, (long)status2.getChildren().length);
        manager.enableConstraint("org.eclipse.pmf.model.checkrules.org.eclipse.pmf.validation.ui.NoNameConflictConstraint");
        IStatus status3 = manager.invokeModelChecking();
        Assert.assertEquals((long)382L, (long)status3.getChildren().length);
    }

    protected void delay(long waitTimeMillis) {
        Display display = Display.getCurrent();
        if (display != null) {
            long endTimeMillis = System.currentTimeMillis() + waitTimeMillis;
            while (System.currentTimeMillis() < endTimeMillis) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            display.update();
        } else {
            try {
                Thread.sleep(waitTimeMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void waitForJobs() {
        while (Job.getJobManager().currentJob() != null) {
            this.delay(1000L);
        }
    }
}

