/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.ICVSRunnable;
import org.eclipse.team.internal.ccvs.core.client.Checkout;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Request;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.EclipseSynchronizer;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.CheckoutOperation;
import org.eclipse.ui.IWorkbenchPart;

public class CheckoutIntoOperation
extends CheckoutOperation {
    private boolean recursive;
    private ICVSFolder localFolder;
    private String localFolderName;

    public CheckoutIntoOperation(IWorkbenchPart part, ICVSRemoteFolder[] remoteFolders, IContainer localFolder, boolean recursive) {
        super(part, remoteFolders);
        this.recursive = recursive;
        this.localFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)localFolder);
    }

    public CheckoutIntoOperation(IWorkbenchPart part, ICVSRemoteFolder remoteFolder, IContainer localFolder, boolean recursive) {
        this(part, new ICVSRemoteFolder[]{remoteFolder}, localFolder.getParent(), recursive);
        this.localFolderName = localFolder.getName();
    }

    @Override
    protected String getTaskName() {
        ICVSRemoteFolder[] remoteFolders = this.getRemoteFolders();
        String localFolderName = "";
        localFolderName = this.getLocalFolder().getIResource().getFullPath().toString();
        return NLS.bind((String)CVSUIMessages.CheckoutIntoOperation_taskname, (Object[])new String[]{Integer.valueOf(remoteFolders.length).toString(), localFolderName});
    }

    public ICVSFolder getLocalFolder() {
        return this.localFolder;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    @Override
    protected IStatus checkout(final ICVSRemoteFolder folder, IProgressMonitor monitor) throws CVSException {
        final IStatus[] result = new IStatus[1];
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    result[0] = CheckoutIntoOperation.this.checkout(folder, CheckoutIntoOperation.this.getLocalFolder(), CheckoutIntoOperation.this.isRecursive(), monitor);
                }
            }, this.getSchedulingRule(), 0, monitor);
        }
        catch (CoreException e) {
            result[0] = CVSException.wrapException((CoreException)e).getStatus();
        }
        return result[0];
    }

    @Override
    protected void checkout(final ICVSRemoteFolder[] folders, IProgressMonitor monitor) throws CVSException {
        EclipseSynchronizer.getInstance().run(this.getSchedulingRule(), new ICVSRunnable(){

            public void run(IProgressMonitor monitor) throws CVSException {
                monitor.beginTask(null, 100);
                try {
                    CheckoutIntoOperation.super.checkout(folders, Policy.subMonitorFor(monitor, 90));
                    CheckoutIntoOperation.refreshRoot(CheckoutIntoOperation.this.getLocalRoot(CheckoutIntoOperation.this.getLocalFolder()), Policy.subMonitorFor(monitor, 10));
                }
                finally {
                    monitor.done();
                }
            }
        }, Policy.monitorFor(monitor));
    }

    private ICVSFolder[] prepareLocalFolders(Session session, ICVSRemoteFolder remoteFolder, ICVSFolder parentFolder, String localFolderName, IProgressMonitor monitor) throws CVSException {
        HashSet<ICVSFolder> targetFolderSet = new HashSet<ICVSFolder>();
        monitor.beginTask(null, 30);
        if (localFolderName == null) {
            IStatus status = Request.EXPAND_MODULES.execute(session, new String[]{remoteFolder.getRepositoryRelativePath()}, Policy.subMonitorFor(monitor, 10));
            if (status.getCode() == -10) {
                this.addError(status);
                return null;
            }
            String[] expansions = session.getModuleExpansions();
            int j = 0;
            while (j < expansions.length) {
                String childPath = new Path(null, expansions[j]).segment(0);
                ICVSResource resource = parentFolder.getChild(childPath);
                if (resource != null && !resource.isFolder()) {
                    this.addError((IStatus)new CVSStatus(4, NLS.bind((String)CVSUIMessages.CheckoutIntoOperation_targetIsFile, (Object[])new String[]{remoteFolder.getName(), resource.getIResource().getFullPath().toString()})));
                    return null;
                }
                targetFolderSet.add(parentFolder.getFolder(childPath));
                ++j;
            }
        } else {
            targetFolderSet.add(parentFolder.getFolder(localFolderName));
        }
        ICVSFolder[] targetFolders = targetFolderSet.toArray(new ICVSFolder[targetFolderSet.size()]);
        IStatus status = this.validateTargetFolders(remoteFolder, targetFolders, Policy.subMonitorFor(monitor, 10));
        if (!status.isOK()) {
            this.addError(status);
            return null;
        }
        status = this.scrubFolders(remoteFolder, targetFolders, Policy.subMonitorFor(monitor, 10));
        if (status.isOK()) {
            return targetFolders;
        }
        this.addError(status);
        return null;
    }

    private IStatus validateTargetFolders(ICVSRemoteFolder remoteFolder, ICVSFolder[] targetFolders, IProgressMonitor monitor) throws CVSException {
        int i = 0;
        while (i < targetFolders.length) {
            ICVSFolder targetFolder = targetFolders[i];
            FolderSyncInfo localInfo = targetFolder.getFolderSyncInfo();
            FolderSyncInfo remoteInfo = remoteFolder.getFolderSyncInfo();
            if (!remoteInfo.isSameMapping(localInfo)) {
                if (localInfo != null && this.isRemoteChildOfParent(targetFolder)) {
                    String message = targetFolder.exists() ? NLS.bind((String)CVSUIMessages.CheckoutIntoOperation_targetIsFolder, (Object[])new String[]{remoteFolder.getName(), targetFolder.getIResource().getFullPath().toString()}) : NLS.bind((String)CVSUIMessages.CheckoutIntoOperation_targetIsPrunedFolder, (Object[])new String[]{remoteFolder.getName(), targetFolder.getFolderSyncInfo().getRepository()});
                    return new CVSStatus(4, message);
                }
                IStatus status = this.validateUniqueMapping(remoteFolder, targetFolder, Policy.subMonitorFor(monitor, 10));
                if (!status.isOK()) {
                    return status;
                }
            }
            ++i;
        }
        return OK;
    }

    private boolean isRemoteChildOfParent(ICVSFolder targetFolder) throws CVSException {
        FolderSyncInfo localInfo = targetFolder.getFolderSyncInfo();
        if (localInfo == null) {
            return false;
        }
        FolderSyncInfo parentInfo = targetFolder.getParent().getFolderSyncInfo();
        if (parentInfo == null) {
            return false;
        }
        Path childPath = new Path(null, localInfo.getRepository());
        Path parentPath = new Path(null, parentInfo.getRepository());
        return parentPath.isPrefixOf((IPath)childPath);
    }

    private IContainer getLocalRoot(ICVSFolder targetFolder) throws CVSException {
        return targetFolder.getIResource().getProject();
    }

    private IStatus validateUniqueMapping(final ICVSRemoteFolder remoteFolder, final ICVSFolder targetFolder, IProgressMonitor iProgressMonitor) throws CVSException {
        IContainer root = this.getLocalRoot(targetFolder);
        final FolderSyncInfo remoteInfo = remoteFolder.getFolderSyncInfo();
        if (remoteInfo.equals((Object)"CVSROOT/Emptydir")) {
            return OK;
        }
        ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)root);
        try {
            cvsFolder.accept(new ICVSResourceVisitor(){

                public void visitFile(ICVSFile file) throws CVSException {
                }

                public void visitFolder(ICVSFolder folder) throws CVSException {
                    if (!folder.isCVSFolder()) {
                        return;
                    }
                    IResource resource = folder.getIResource();
                    if (resource == null) {
                        return;
                    }
                    FolderSyncInfo info = folder.getFolderSyncInfo();
                    if (info.isSameMapping(remoteInfo)) {
                        throw new CVSException(NLS.bind((String)CVSUIMessages.CheckoutIntoOperation_mappingAlreadyExists, (Object[])new Object[]{remoteFolder.getName(), targetFolder.getIResource().getFullPath().toString(), resource.getFullPath().toString()}));
                    }
                    folder.acceptChildren((ICVSResourceVisitor)this);
                }
            });
        }
        catch (CVSException e) {
            return e.getStatus();
        }
        return OK;
    }

    private IStatus scrubFolders(ICVSRemoteFolder remoteFolder, ICVSFolder[] targetFolders, IProgressMonitor monitor) throws CVSException {
        monitor.beginTask(null, 100 * targetFolders.length);
        if (targetFolders.length > 1) {
            this.setInvolvesMultipleResources(true);
        }
        int i = 0;
        while (i < targetFolders.length) {
            ICVSFolder targetFolder = targetFolders[i];
            if (this.needsPromptForOverwrite(targetFolder, Policy.subMonitorFor(monitor, 50)) && !this.promptToOverwrite(targetFolder)) {
                return new CVSStatus(1, NLS.bind((String)CVSUIMessages.CheckoutIntoOperation_cancelled, (Object[])new String[]{remoteFolder.getName()}));
            }
            ++i;
        }
        i = 0;
        while (i < targetFolders.length) {
            IStatus status = this.scrubFolder(targetFolders[i], Policy.subMonitorFor(monitor, 50));
            if (!status.isOK()) {
                return status;
            }
            ++i;
        }
        monitor.done();
        return OK;
    }

    private boolean needsPromptForOverwrite(ICVSFolder targetFolder, IProgressMonitor monitor) throws CVSException {
        return targetFolder.isModified(monitor);
    }

    private boolean promptToOverwrite(ICVSFolder folder) {
        return this.promptToOverwrite(CVSUIMessages.CheckoutOperation_confirmOverwrite, NLS.bind((String)CVSUIMessages.CheckoutIntoOperation_overwriteMessage, (Object[])new String[]{folder.getName()}), folder.getIResource());
    }

    private IStatus scrubFolder(ICVSFolder folder, IProgressMonitor monitor) throws CVSException {
        if (folder.exists() || folder.isCVSFolder()) {
            folder.unmanage(Policy.subMonitorFor(monitor, 50));
            if (folder.exists()) {
                folder.delete();
            }
        }
        return OK;
    }

    IStatus checkout(ICVSRemoteFolder remoteFolder, ICVSFolder parentFolder, boolean recurse, IProgressMonitor monitor) throws CVSException {
        monitor.beginTask(null, 100);
        ICVSRepositoryLocation repository = remoteFolder.getRepository();
        try (Session session = new Session(repository, parentFolder);){
            CVSTag tag;
            ICVSFolder[] targetFolders;
            Path path;
            session.open(Policy.subMonitorFor(monitor, 5), false);
            String localName = this.localFolderName;
            if (localName == null && (path = new Path(null, remoteFolder.getRepositoryRelativePath())).segmentCount() > 1) {
                localName = path.lastSegment();
            }
            if ((targetFolders = this.prepareLocalFolders(session, remoteFolder, parentFolder, localName, Policy.subMonitorFor(monitor, 5))) == null) {
                IStatus iStatus = this.getLastError();
                return iStatus;
            }
            ArrayList<Command.LocalOption> localOptions = new ArrayList<Command.LocalOption>();
            if (!recurse) {
                localOptions.add(Command.DO_NOT_RECURSE);
            }
            if (localName != null) {
                localOptions.add(Checkout.makeDirectoryNameOption((String)localName));
            }
            if (CVSProviderPlugin.getPlugin().getPruneEmptyDirectories()) {
                localOptions.add(Command.PRUNE_EMPTY_DIRECTORIES);
            }
            if ((tag = remoteFolder.getTag()) == null) {
                tag = CVSTag.DEFAULT;
            }
            localOptions.add(Update.makeTagOption((CVSTag)tag));
            IStatus status = Command.CHECKOUT.execute(session, Command.NO_GLOBAL_OPTIONS, localOptions.toArray(new Command.LocalOption[localOptions.size()]), new String[]{remoteFolder.getRepositoryRelativePath()}, null, Policy.subMonitorFor(monitor, 80));
            if (!status.isOK()) {
                IStatus iStatus = status;
                return iStatus;
            }
            this.manageFolders(targetFolders, repository.getLocation(false));
            IStatus iStatus = OK;
            return iStatus;
        }
    }

    private void manageFolders(ICVSFolder[] targetFolders, String root) throws CVSException {
        int i = 0;
        while (i < targetFolders.length) {
            CheckoutIntoOperation.manageFolder(targetFolders[i], root);
            ++i;
        }
    }

    private static void manageFolder(ICVSFolder folder, String root) throws CVSException {
        ICVSFolder parent = folder.getParent();
        if (!parent.isCVSFolder()) {
            parent.setFolderSyncInfo(new FolderSyncInfo("CVSROOT/Emptydir", root, CVSTag.DEFAULT, true));
            IResource resource = parent.getIResource();
            if (resource.getType() != 4) {
                CheckoutIntoOperation.manageFolder(parent, root);
            }
        }
        folder.setFolderSyncInfo(folder.getFolderSyncInfo());
    }

    private static void refreshRoot(IContainer root, IProgressMonitor monitor) throws CVSException {
        try {
            ICVSFolder folder;
            IProject project = root.getProject();
            CVSTeamProvider provider = (CVSTeamProvider)RepositoryProvider.getProvider((IProject)project, (String)CVSProviderPlugin.getTypeId());
            if (provider == null && (folder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)project)).isCVSFolder()) {
                RepositoryProvider.map((IProject)project, (String)CVSProviderPlugin.getTypeId());
                provider = (CVSTeamProvider)RepositoryProvider.getProvider((IProject)project, (String)CVSProviderPlugin.getTypeId());
                provider.setWatchEditEnabled(CVSProviderPlugin.getPlugin().isWatchEditEnabled());
            }
        }
        catch (TeamException e) {
            throw CVSException.wrapException((CoreException)((Object)e));
        }
    }

    protected ISchedulingRule getSchedulingRule() {
        IProject tempProject = this.getLocalFolder().getIResource().getProject();
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        return ruleFactory.modifyRule((IResource)tempProject);
    }
}

