/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.threadstatus;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;

public class ThreadEntryModel
extends TimeGraphEntryModel {
    private final int fThreadId;
    private final int fParentThreadId;

    public ThreadEntryModel(long id, long parentId, @NonNull String name, long start, long end, int pid, int ppid) {
        super(id, parentId, name, start, end);
        this.fThreadId = pid;
        this.fParentThreadId = ppid;
    }

    public int getThreadId() {
        return this.fThreadId;
    }

    public int getParentThreadId() {
        return this.fParentThreadId;
    }

    public @NonNull String toString() {
        return "<name=" + this.getName() + " id=" + this.getId() + " parentId=" + this.getParentId() + " start=" + this.getStartTime() + " end=" + this.getEndTime() + " TID=" + this.fThreadId + " PTID=" + this.fParentThreadId + ">";
    }

    public static final class Builder {
        private final long fId;
        private @NonNull String fName;
        private final long fStartTime;
        private long fEndTime;
        private final int fPid;
        private int fPpid;

        public Builder(long id, @NonNull String name, long start, long end, int pid, int ppid) {
            this.fId = id;
            this.fName = name;
            this.fStartTime = start;
            this.fEndTime = end;
            this.fPid = pid;
            this.fPpid = ppid;
        }

        public long getId() {
            return this.fId;
        }

        public long getStartTime() {
            return this.fStartTime;
        }

        public long getEndTime() {
            return this.fEndTime;
        }

        public int getPpid() {
            return this.fPpid;
        }

        public void setName(@NonNull String name) {
            this.fName = name;
        }

        public void setEndTime(long endTime) {
            this.fEndTime = Long.max(this.fEndTime, endTime);
        }

        public void setPpid(int ppid) {
            this.fPpid = ppid;
        }

        public ThreadEntryModel build(long parentId) {
            return new ThreadEntryModel(this.fId, parentId, this.fName, this.fStartTime, this.fEndTime, this.fPid, this.fPpid);
        }
    }
}

