/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.event.types;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.math.SaturatedArithmetic;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.scope.ILexicalScope;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.ICompositeDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.ScopedDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;

public final class StructDefinition
extends ScopedDefinition
implements ICompositeDefinition {
    private final @NonNull List<@NonNull String> fFieldNames;
    private final Definition[] fDefinitions;
    private Map<String, Definition> fDefinitionsMap = null;

    public StructDefinition(@NonNull StructDeclaration declaration, IDefinitionScope definitionScope, @NonNull String structFieldName, Definition[] definitions) {
        super(declaration, definitionScope, structFieldName);
        this.fFieldNames = ImmutableList.copyOf(declaration.getFieldsList());
        this.fDefinitions = definitions;
        if (this.fFieldNames.isEmpty()) {
            this.fDefinitionsMap = Collections.EMPTY_MAP;
        }
    }

    public StructDefinition(@NonNull StructDeclaration declaration, IDefinitionScope definitionScope, @NonNull ILexicalScope scope, @NonNull String structFieldName, @NonNull Iterable<@NonNull String> fieldNames, Definition[] definitions) {
        super(declaration, definitionScope, structFieldName, scope);
        this.fFieldNames = ImmutableList.copyOf(fieldNames);
        this.fDefinitions = definitions;
        if (this.fFieldNames.isEmpty()) {
            this.fDefinitionsMap = Collections.EMPTY_MAP;
        }
    }

    @Override
    public Definition getDefinition(String fieldName) {
        if (this.fDefinitionsMap == null) {
            ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
            int i = 0;
            while (i < this.fFieldNames.size()) {
                if (this.fDefinitions[i] != null) {
                    mapBuilder.put((Object)this.fFieldNames.get(i), (Object)this.fDefinitions[i]);
                }
                ++i;
            }
            this.fDefinitionsMap = mapBuilder.build();
        }
        return this.fDefinitionsMap.get(fieldName);
    }

    @Override
    public @NonNull List<@NonNull String> getFieldNames() {
        return this.fFieldNames;
    }

    @Override
    public StructDeclaration getDeclaration() {
        return (StructDeclaration)super.getDeclaration();
    }

    @Override
    public long size() {
        long size = 0L;
        Definition[] definitionArray = this.fDefinitions;
        int n = this.fDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            Definition def = definitionArray[n2];
            size = SaturatedArithmetic.add((long)size, (long)def.size());
            ++n2;
        }
        return size;
    }

    @Override
    public Definition lookupDefinition(String lookupPath) {
        return this.lookupDefinition(lookupPath, null);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        LinkedList<String> fields = new LinkedList<String>();
        for (String field : this.fFieldNames) {
            String appendee = String.valueOf(field) + " = " + this.lookupDefinition(field).toString();
            fields.add(appendee);
        }
        Joiner joiner = Joiner.on((String)", ").skipNulls();
        builder.append(joiner.join(fields));
        builder.append(" }");
        return builder.toString();
    }

    public Definition lookupDefinition(String lookupPath, ScopedDefinition defintionToExclude) {
        int val = this.fFieldNames.indexOf(lookupPath);
        if (val != -1) {
            return this.fDefinitions[val];
        }
        String lookupUnderscored = "_" + lookupPath;
        val = this.fFieldNames.indexOf(lookupUnderscored);
        if (val != -1) {
            return this.fDefinitions[val];
        }
        Definition[] definitionArray = this.fDefinitions;
        int n = this.fDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            IDefinition def;
            Definition child = definitionArray[n2];
            if (child instanceof ScopedDefinition && !child.equals(defintionToExclude) && (def = ((ScopedDefinition)child).lookupDefinition(lookupPath)) instanceof Definition) {
                return (Definition)def;
            }
            ++n2;
        }
        if (this.getDefinitionScope() instanceof StructDeclaration.InternalDef) {
            return (Definition)((StructDeclaration.InternalDef)this.getDefinitionScope()).lookupDefinitionBreakLoop(lookupPath);
        }
        return (Definition)this.getDefinitionScope().lookupDefinition(lookupPath);
    }
}

