/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.core.opxml.sessions;

import java.util.ArrayList;
import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelEvent;
import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelSession;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.XMLProcessor;
import org.xml.sax.Attributes;

public class SessionsProcessor
extends XMLProcessor {
    public static final String SESSION_TAG = "session";
    private static final String SESSION_NAME_ATTR = "name";
    public static final String SAMPLE_COUNT_TAG = "count";
    public static final String EVENT_TAG = "event";
    private static final String EVENT_NAME_ATTR = "name";
    private OpModelSession currentSession;
    private OpModelEvent currentEvent;
    private ArrayList<OpModelEvent> eventList;

    @Override
    public void startElement(String name, Attributes attrs, Object callData) {
        if (name.equals(SESSION_TAG)) {
            String sessionName = this.validString(attrs.getValue("name"));
            this.currentSession = new OpModelSession(sessionName);
            this.eventList = new ArrayList();
        } else if (name.equals(EVENT_TAG)) {
            String eventName = attrs.getValue("name");
            this.currentEvent = new OpModelEvent(this.currentSession, eventName);
        } else {
            super.startElement(name, attrs, callData);
        }
    }

    @Override
    public void endElement(String name, Object callData) {
        if (name.equals(SESSION_TAG)) {
            OpModelEvent[] s = new OpModelEvent[this.eventList.size()];
            this.eventList.toArray(s);
            this.currentSession.setEvents(s);
            SessionInfo info = (SessionInfo)callData;
            info.list.add(this.currentSession);
            this.currentSession = null;
            this.eventList = null;
        } else if (name.equals(EVENT_TAG)) {
            this.eventList.add(this.currentEvent);
            this.currentEvent = null;
        } else {
            super.endElement(name, callData);
        }
    }

    public static class SessionInfo {
        public ArrayList<OpModelSession> list;

        public SessionInfo(ArrayList<OpModelSession> session) {
            this.list = session;
        }
    }
}

