/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collections;

import java.util.Iterator;
import org.eclipse.mat.inspections.collectionextract.CollectionExtractionUtils;
import org.eclipse.mat.inspections.collectionextract.ExtractedMap;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.internal.collectionextract.HashMapCollectionExtractor;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.quantize.Quantize;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.extension.Subjects;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.RetainedSizeDerivedData;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

@CommandName(value="map_collision_ratio")
@Icon(value="/META-INF/icons/map_collision.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/analyzingjavacollectionusage.html")
@Subjects(value={"java.util.AbstractMap", "java.util.jar.Attributes", "java.util.Dictionary", "java.lang.ThreadLocal$ThreadLocalMap", "java.util.concurrent.ConcurrentHashMap$Segment", "java.util.concurrent.ConcurrentHashMap$CollectionView", "java.util.Collections$SynchronizedMap", "java.util.Collections$UnmodifiableMap", "java.util.Collections$CheckedMap", "java.util.ResourceBundle", "java.awt.RenderingHints", "sun.awt.WeakIdentityHashMap", "javax.script.SimpleBindings", "javax.management.openmbean.TabularDataSupport", "com.ibm.jvm.util.HashMapRT", "com.sap.engine.lib.util.AbstractDataStructure", "java.util.HashSet"})
public class MapCollisionRatioQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IHeapObjectArgument objects;
    @Argument(isMandatory=false)
    public int segments = 5;
    @Argument(isMandatory=false)
    public String collection;
    @Argument(isMandatory=false)
    public String size_attribute;
    @Argument(isMandatory=false)
    public String array_attribute;

    public IResult execute(IProgressListener listener) throws Exception {
        listener.subTask(Messages.MapCollisionRatioQuery_CalculatingCollisionRatios);
        Quantize.Builder builder = Quantize.linearFrequencyDistribution((String)Messages.MapCollisionRatioQuery_Column_CollisionRatio, (double)0.0, (double)1.0, (double)(1.0 / (double)this.segments));
        builder.column(Messages.MapCollisionRatioQuery_Column_NumObjects, Quantize.COUNT);
        builder.column(Messages.Column_ShallowHeap, Quantize.SUM_LONG);
        builder.addDerivedData(RetainedSizeDerivedData.APPROXIMATE);
        Quantize quantize = builder.build();
        HashMapCollectionExtractor specificExtractor = new HashMapCollectionExtractor(this.size_attribute, this.array_attribute, null, null);
        Iterator iterator = this.objects.iterator();
        block2: while (iterator.hasNext()) {
            int[] objectIds;
            int[] nArray = objectIds = (int[])iterator.next();
            int n = objectIds.length;
            int n2 = 0;
            while (n2 < n) {
                int objectId = nArray[n2];
                if (listener.isCanceled()) continue block2;
                IObject obj = this.snapshot.getObject(objectId);
                try {
                    ExtractedMap coll = CollectionExtractionUtils.extractMap(obj, this.collection, specificExtractor);
                    if (coll != null) {
                        Double collisionRatio = coll.getCollisionRatio();
                        if (collisionRatio == null) {
                            collisionRatio = 0.0;
                        }
                        quantize.addValue(obj.getObjectId(), new Object[]{collisionRatio, null, obj.getUsedHeapSize()});
                    }
                }
                catch (RuntimeException e) {
                    listener.sendUserMessage(IProgressListener.Severity.INFO, MessageUtil.format((String)Messages.MapCollisionRatioQuery_IgnoringCollection, (Object[])new Object[]{obj.getTechnicalName()}), (Throwable)e);
                }
                ++n2;
            }
        }
        return quantize.getResult();
    }
}

