/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library.logical;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.library.AbstractSimpleBinaryOperation;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class BooleanImpliesOperation2
extends AbstractSimpleBinaryOperation {
    public static final @NonNull BooleanImpliesOperation2 INSTANCE = new BooleanImpliesOperation2();

    @Override
    public @Nullable Object dispatch(@NonNull Executor executor, @NonNull OperationCallExp callExp, @Nullable Object sourceValue) {
        List<OCLExpression> arguments = callExp.getOwnedArguments();
        OCLExpression argument0 = arguments.get(0);
        assert (argument0 != null);
        if (argument0.isNull()) {
            throw new InvalidValueException("null argument", new Object[0]);
        }
        if (sourceValue == Boolean.FALSE) {
            return TRUE_VALUE;
        }
        Object firstArgument = executor.evaluate(argument0);
        Boolean sourceBoolean = ValueUtil.asBoolean(sourceValue);
        Boolean argBoolean = ValueUtil.asBoolean(firstArgument);
        return this.evaluate(sourceBoolean, argBoolean);
    }

    @Override
    public @NonNull Boolean evaluate(@Nullable Object left, @Nullable Object right) {
        if (left == Boolean.FALSE || right == Boolean.TRUE) {
            return TRUE_VALUE;
        }
        return FALSE_VALUE;
    }
}

