/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.debug.communication;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Map;
import javax.management.AttributeChangeNotification;
import javax.management.InstanceNotFoundException;
import javax.management.JMX;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;
import org.eclipse.viatra.transformation.debug.communication.DebuggerTargetEndpointMBean;
import org.eclipse.viatra.transformation.debug.communication.IDebuggerHostAgent;
import org.eclipse.viatra.transformation.debug.communication.IDebuggerHostAgentListener;
import org.eclipse.viatra.transformation.debug.communication.IDebuggerHostEndpoint;
import org.eclipse.viatra.transformation.debug.communication.ViatraDebuggerException;
import org.eclipse.viatra.transformation.debug.model.breakpoint.ITransformationBreakpointHandler;
import org.eclipse.viatra.transformation.debug.model.transformationstate.TransformationModelElement;
import org.eclipse.viatra.transformation.debug.model.transformationstate.TransformationState;
import org.eclipse.viatra.transformation.debug.transformationtrace.model.ActivationTrace;

public class DebuggerHostEndpoint
implements IDebuggerHostAgent,
IDebuggerHostEndpoint,
NotificationListener {
    public static final String COMM_ERROR_MSG = "Communication with the VIATRA Debugger Agent has been interrupted. Perhaps the target application has been closed abruptly or was not running at all.";
    public static final String COMM_ERROR_TITLE = "Debugger Connection Interrupted";
    public static final String BRKP_ERROR_MSG = "Make sure that the required UI components are loaded before trying to add conditional breakpoints, otherwise such breakpoints will have no effect at all.";
    public static final String BRKP_ERROR_TITLE = "An error occured while adding breakpoint";
    private String name;
    private List<IDebuggerHostAgentListener> listeners = Lists.newArrayList();
    private DebuggerTargetEndpointMBean mbeanProxy;
    private ObjectName mbeanName;
    private MBeanServerConnection mbsc;
    private JMXConnector jmxc;

    public DebuggerHostEndpoint(String ID) {
        this.name = ID;
    }

    public void connectTo(int port) throws IOException, MalformedObjectNameException, InstanceNotFoundException {
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:" + port + "/jmxrmi");
        this.jmxc = JMXConnectorFactory.connect(url, null);
        this.mbsc = this.jmxc.getMBeanServerConnection();
        this.mbsc.queryNames(null, null);
        this.mbeanName = new ObjectName(this.name);
        this.mbeanProxy = JMX.newMBeanProxy(this.mbsc, this.mbeanName, DebuggerTargetEndpointMBean.class, true);
        this.mbsc.addNotificationListener(this.mbeanName, this, null, null);
        this.jmxc.addConnectionNotificationListener(this, null, null);
    }

    public void sendStepMessage() {
        try {
            this.mbeanProxy.stepForward();
        }
        catch (IOException | InstanceNotFoundException e) {
            this.handleCommunicationError(e);
        }
    }

    public void sendContinueMessage() {
        try {
            this.mbeanProxy.continueExecution();
        }
        catch (IOException | InstanceNotFoundException e) {
            this.handleCommunicationError(e);
        }
    }

    public void sendNextActivationMessage(ActivationTrace activation) {
        try {
            this.mbeanProxy.setNextActivation(activation);
        }
        catch (IOException | InstanceNotFoundException e) {
            this.handleCommunicationError(e);
        }
    }

    public void sendAddBreakpointMessage(ITransformationBreakpointHandler breakpoint) {
        try {
            this.mbeanProxy.addBreakpoint(breakpoint);
        }
        catch (IOException | InstanceNotFoundException e) {
            this.handleCommunicationError(e);
        }
        catch (ViatraDebuggerException e) {
            this.handleConditinalBreakpointError(e);
        }
    }

    public void sendRemoveBreakpointMessage(ITransformationBreakpointHandler breakpoint) {
        try {
            this.mbeanProxy.removeBreakpoint(breakpoint);
        }
        catch (IOException | InstanceNotFoundException e) {
            this.handleCommunicationError(e);
        }
        catch (ViatraDebuggerException e) {
            this.handleConditinalBreakpointError(e);
        }
    }

    public void sendDisableBreakpointMessage(ITransformationBreakpointHandler breakpoint) {
        try {
            this.mbeanProxy.disableBreakpoint(breakpoint);
        }
        catch (IOException | InstanceNotFoundException e) {
            this.handleCommunicationError(e);
        }
        catch (ViatraDebuggerException e) {
            ViatraQueryLoggingUtil.getDefaultLogger().debug((Object)e.getMessage());
        }
    }

    public void sendEnableBreakpointMessage(ITransformationBreakpointHandler breakpoint) {
        try {
            this.mbeanProxy.enableBreakpoint(breakpoint);
        }
        catch (IOException | InstanceNotFoundException e) {
            this.handleCommunicationError(e);
        }
        catch (ViatraDebuggerException e) {
            ViatraQueryLoggingUtil.getDefaultLogger().debug((Object)e.getMessage());
        }
    }

    public void sendDisconnectMessage() {
        try {
            this.mbeanProxy.disconnect();
        }
        catch (IOException | InstanceNotFoundException e) {
            this.handleCommunicationError(e);
        }
    }

    public synchronized void registerDebuggerHostAgentListener(IDebuggerHostAgentListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized void unRegisterDebuggerHostAgentListener(IDebuggerHostAgentListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public String getID() {
        return this.name;
    }

    public void transformationStateChanged(TransformationState state) {
        for (IDebuggerHostAgentListener listener : this.listeners) {
            listener.transformationStateChanged(state);
        }
    }

    public void terminated() throws ViatraDebuggerException {
        try {
            this.mbsc.removeNotificationListener(this.mbeanName, this, null, null);
            this.jmxc.close();
            this.terminateListeners();
        }
        catch (IOException | InstanceNotFoundException | ListenerNotFoundException e) {
            ViatraQueryLoggingUtil.getDefaultLogger().debug((Object)e.getMessage());
            throw new ViatraDebuggerException(e.getMessage());
        }
    }

    private void terminateListeners() {
        for (IDebuggerHostAgentListener listener : this.listeners) {
            listener.terminated((IDebuggerHostAgent)this);
        }
        this.listeners.clear();
    }

    @Override
    public void handleNotification(Notification notification, Object arg1) {
        if (notification instanceof AttributeChangeNotification) {
            AttributeChangeNotification acn = (AttributeChangeNotification)notification;
            if (acn.getAttributeType().equals("TransformationState")) {
                try {
                    ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream((byte[])acn.getNewValue()));
                    TransformationState state = (TransformationState)objectInputStream.readObject();
                    this.transformationStateChanged(state);
                }
                catch (IOException | ClassNotFoundException e) {
                    ViatraQueryLoggingUtil.getDefaultLogger().error((Object)e.getMessage());
                }
            }
        } else if (notification instanceof JMXConnectionNotification) {
            String message = notification.getType();
            if (message.equals("jmx.remote.connection.closed")) {
                this.terminateListeners();
            }
        } else {
            String message = notification.getType();
            if (message.equals("Terminated")) {
                try {
                    this.terminated();
                }
                catch (ViatraDebuggerException e) {
                    ViatraQueryLoggingUtil.getDefaultLogger().error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public List<TransformationModelElement> getRootElements() {
        try {
            return this.mbeanProxy.getRootElements();
        }
        catch (IOException | InstanceNotFoundException e) {
            return Lists.newArrayList();
        }
    }

    public Map<String, List<TransformationModelElement>> getChildren(TransformationModelElement parent) {
        try {
            return this.mbeanProxy.getChildren(parent);
        }
        catch (IOException | InstanceNotFoundException e) {
            return Maps.newHashMap();
        }
    }

    public Map<String, List<TransformationModelElement>> getCrossReferences(TransformationModelElement parent) {
        try {
            return this.mbeanProxy.getCrossReferences(parent);
        }
        catch (IOException | InstanceNotFoundException e) {
            return Maps.newHashMap();
        }
    }

    private void handleCommunicationError(Exception e) {
        this.terminateListeners();
        ViatraQueryLoggingUtil.getDefaultLogger().error((Object)("Communication error: " + e.getMessage()));
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            Shell activeShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            ErrorDialog.openError((Shell)activeShell, (String)COMM_ERROR_TITLE, (String)COMM_ERROR_MSG, (IStatus)new Status(4, "org.eclipse.viatra.transformation.debug", e.getMessage()));
        });
    }

    private void handleConditinalBreakpointError(ViatraDebuggerException e) {
        this.terminateListeners();
        ViatraQueryLoggingUtil.getDefaultLogger().error((Object)("Invalid Conditional Breakpoint: " + e.getMessage()));
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            Shell activeShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            ErrorDialog.openError((Shell)activeShell, (String)BRKP_ERROR_TITLE, (String)BRKP_ERROR_MSG, (IStatus)new Status(4, "org.eclipse.viatra.transformation.debug", e.getMessage()));
        });
    }
}

