"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var lodash_camelcase_1 = __importDefault(require("lodash.camelcase"));
// The below is based on the CSS Modules implementation found here:
// https://github.com/webpack-contrib/css-loader/blob/master/lib/compile-exports.js
var dashCase = function (className) {
    return className.replace(/-+(\w)/g, function (match, firstLetter) {
        return firstLetter.toUpperCase();
    });
};
exports.transformClasses = function (camelCaseOption) { return function (className) {
    var entries = [];
    switch (camelCaseOption) {
        case 'camelCase': {
            entries.push(className);
            var targetClassName = lodash_camelcase_1.default(className);
            if (targetClassName !== className) {
                entries.push(targetClassName);
            }
            break;
        }
        case 'camelCaseOnly':
            entries.push(lodash_camelcase_1.default(className));
            break;
        case 'dashes': {
            entries.push(className);
            var targetClassName = dashCase(className);
            if (targetClassName !== className) {
                entries.push(targetClassName);
            }
            break;
        }
        case 'dashesOnly':
            entries.push(dashCase(className));
            break;
        case 'asIs':
        default:
            entries.push(className);
            break;
    }
    return entries;
}; };
