/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.editor;

import java.io.File;
import java.util.Arrays;
import org.eclipse.bpmn2.modeler.core.builder.BPMN2Builder;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.AbstractObjectEditingDialog;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.ObjectEditingDialog;
import org.eclipse.bpmn2.modeler.core.model.ModelHandler;
import org.eclipse.bpmn2.modeler.core.model.ModelHandlerLocator;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.utils.ErrorUtils;
import org.eclipse.bpmn2.modeler.core.utils.FileUtils;
import org.eclipse.bpmn2.modeler.core.utils.MarkerUtils;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.validation.BPMN2ProjectValidator;
import org.eclipse.bpmn2.modeler.core.validation.BPMN2ValidationStatusLoader;
import org.eclipse.bpmn2.modeler.ui.Activator;
import org.eclipse.bpmn2.modeler.ui.Bpmn2DiagramEditorInput;
import org.eclipse.bpmn2.modeler.ui.editor.BPMN2EditorDiagramBehavior;
import org.eclipse.bpmn2.modeler.ui.editor.BPMN2MarkerChangeListener;
import org.eclipse.bpmn2.modeler.ui.editor.BPMN2MultiPageEditor;
import org.eclipse.bpmn2.modeler.ui.editor.DefaultBPMN2Editor;
import org.eclipse.bpmn2.modeler.ui.util.PropertyUtil;
import org.eclipse.bpmn2.util.Bpmn2ResourceImpl;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

public class BPMN2Editor
extends DefaultBPMN2Editor
implements IGotoMarker {
    public static final String EDITOR_ID = "org.eclipse.bpmn2.modeler.ui.bpmn2editor";
    private static BPMN2Editor activeEditor;
    protected BPMN2MultiPageEditor multipageEditor;
    private IPartListener2 selectionListener;
    private IWorkbenchListener workbenchListener;
    private IResourceChangeListener markerChangeListener;
    private boolean workbenchShutdown = false;

    public BPMN2Editor(BPMN2MultiPageEditor mpe) {
        this.multipageEditor = mpe;
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input instanceof IFileEditorInput) {
            BPMN2Builder.INSTANCE.loadExtensions(((IFileEditorInput)input).getFile().getProject());
        }
        this.setActiveEditor(this);
        if (this.getDiagramBehavior() == null) {
            super.init(site, input);
            this.addWorkbenchListener();
            this.addSelectionListener();
            this.addMarkerChangeListener();
        } else if (input instanceof Bpmn2DiagramEditorInput) {
            this.bpmnDiagram = ((Bpmn2DiagramEditorInput)input).getBpmnDiagram();
            if (this.bpmnDiagram != null) {
                this.setBpmnDiagram(this.bpmnDiagram);
            }
        }
    }

    @Override
    protected DefaultBPMN2Editor.EditorInputHelper getInputHelper() {
        return new ExtendedEditorInputHelper();
    }

    protected void loadMarkers() {
        if (this.getModelFile() != null) {
            BPMN2ValidationStatusLoader vsl = new BPMN2ValidationStatusLoader((DiagramEditor)this);
            try {
                vsl.load(Arrays.asList(this.getModelFile().findMarkers(null, true, 0)));
            }
            catch (CoreException e) {
                Activator.logStatus(e.getStatus());
            }
        }
    }

    @Override
    protected DiagramBehavior createDiagramBehavior() {
        BPMN2EditorDiagramBehavior diagramBehavior = new BPMN2EditorDiagramBehavior(this);
        return diagramBehavior;
    }

    public BPMN2MultiPageEditor getMultipageEditor() {
        return this.multipageEditor;
    }

    public static BPMN2Editor getActiveEditor() {
        return activeEditor;
    }

    protected void setActiveEditor(BPMN2Editor editor) {
        activeEditor = editor;
        if (activeEditor != null) {
            Bpmn2Preferences.setActiveProject((IProject)activeEditor.getProject());
        }
    }

    @Override
    public Object getAdapter(Class required) {
        if (required == StructuredTextEditor.class && this.multipageEditor.getActiveEditor() == this.multipageEditor.getSourceViewer()) {
            return this.multipageEditor.getSourceViewer();
        }
        return super.getAdapter(required);
    }

    public void gotoMarker(IMarker marker) {
        ResourceSet rs = this.getEditingDomain().getResourceSet();
        EObject target = MarkerUtils.getTargetObject((ResourceSet)rs, (IMarker)marker);
        if (target == null) {
            return;
        }
        IFeatureProvider fp = this.getDiagramTypeProvider().getFeatureProvider();
        ContainerShape pe = MarkerUtils.getContainerShape((IFeatureProvider)fp, (IMarker)marker);
        if (pe != null) {
            this.selectPictogramElements(new PictogramElement[]{pe});
        }
        if (pe == null || PropertyUtil.getPropertySheetView() == null) {
            ObjectEditingDialog dialog = new ObjectEditingDialog((DiagramEditor)this, target);
            ObjectEditingDialog.openWithTransaction((AbstractObjectEditingDialog)dialog);
        }
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        Resource resource = this.getResourceSet().getResource(this.modelUri, false);
        BPMN2ProjectValidator.validateOnSave((Resource)resource, (IProgressMonitor)monitor);
    }

    public void doSaveAs() {
        IFile oldFile = this.getModelFile();
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.setOriginalFile(oldFile);
        saveAsDialog.create();
        if (saveAsDialog.open() == 1) {
            return;
        }
        IPath newFilePath = saveAsDialog.getResult();
        if (newFilePath == null) {
            return;
        }
        IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(newFilePath);
        IWorkbenchPage page = this.getSite().getPage();
        try {
            if (newFile.exists()) {
                IEditorPart editorPart = ResourceUtil.findEditor((IWorkbenchPage)page, (IFile)newFile);
                if (editorPart != null) {
                    page.closeEditor(editorPart, false);
                }
                newFile.delete(true, null);
            }
            oldFile.copy(newFilePath, true, null);
        }
        catch (CoreException e) {
            this.showErrorDialogWithLogging((Exception)((Object)e));
            return;
        }
        URI newURI = URI.createPlatformResourceURI((String)newFile.getFullPath().toString(), (boolean)true);
        this.handleResourceMoved((Resource)this.bpmnResource, newURI);
        this.doSave(null);
    }

    public void closeEditor() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                boolean closed = BPMN2Editor.this.getSite().getPage().closeEditor((IEditorPart)BPMN2Editor.this, false);
                if (!closed) {
                    IFile oldFile = ResourcesPlugin.getWorkspace().getRoot().getFile(BPMN2Editor.this.getModelPath());
                    IEditorPart editorPart = ResourceUtil.findEditor((IWorkbenchPage)BPMN2Editor.this.getSite().getPage(), (IFile)oldFile);
                    closed = BPMN2Editor.this.getSite().getPage().closeEditor(editorPart, false);
                }
            }
        });
    }

    private void showErrorDialogWithLogging(Exception e) {
        Status status = new Status(4, "org.eclipse.bpmn2.modeler.ui", e.getMessage(), (Throwable)e);
        ErrorUtils.showErrorWithLogging((IStatus)status);
    }

    private void addWorkbenchListener() {
        if (this.workbenchListener == null) {
            this.workbenchListener = new IWorkbenchListener(){

                public boolean preShutdown(IWorkbench workbench, boolean forced) {
                    BPMN2Editor.this.workbenchShutdown = true;
                    return true;
                }

                public void postShutdown(IWorkbench workbench) {
                }
            };
            PlatformUI.getWorkbench().addWorkbenchListener(this.workbenchListener);
        }
    }

    private void removeWorkbenchListener() {
        if (this.workbenchListener != null) {
            PlatformUI.getWorkbench().removeWorkbenchListener(this.workbenchListener);
            this.workbenchListener = null;
        }
    }

    private void addSelectionListener() {
        if (this.selectionListener == null) {
            IWorkbenchPage page = this.getSite().getPage();
            this.selectionListener = new IPartListener2(){

                public void partActivated(IWorkbenchPartReference partRef) {
                    IWorkbenchPart part = partRef.getPart(false);
                    if (part instanceof BPMN2MultiPageEditor) {
                        BPMN2MultiPageEditor mpe = (BPMN2MultiPageEditor)part;
                        BPMN2Editor.this.setActiveEditor(mpe.getDesignEditor());
                    }
                }

                public void partBroughtToTop(IWorkbenchPartReference partRef) {
                    IWorkbenchPart part = partRef.getPart(false);
                    if (part instanceof BPMN2MultiPageEditor) {
                        BPMN2MultiPageEditor mpe = (BPMN2MultiPageEditor)part;
                        BPMN2Editor.this.setActiveEditor(mpe.getDesignEditor());
                    }
                }

                public void partClosed(IWorkbenchPartReference partRef) {
                }

                public void partDeactivated(IWorkbenchPartReference partRef) {
                }

                public void partOpened(IWorkbenchPartReference partRef) {
                }

                public void partHidden(IWorkbenchPartReference partRef) {
                }

                public void partVisible(IWorkbenchPartReference partRef) {
                }

                public void partInputChanged(IWorkbenchPartReference partRef) {
                }
            };
            page.addPartListener(this.selectionListener);
        }
    }

    private void removeSelectionListener() {
        if (this.selectionListener != null) {
            this.getSite().getPage().removePartListener(this.selectionListener);
            this.selectionListener = null;
        }
    }

    private void addMarkerChangeListener() {
        if (this.getModelFile() != null && this.markerChangeListener == null) {
            this.markerChangeListener = new BPMN2MarkerChangeListener(this);
            this.getModelFile().getWorkspace().addResourceChangeListener(this.markerChangeListener, 16);
        }
    }

    private void removeMarkerChangeListener() {
        if (this.markerChangeListener != null) {
            this.getModelFile().getWorkspace().removeResourceChangeListener(this.markerChangeListener);
            this.markerChangeListener = null;
        }
    }

    public boolean handleResourceChanged(Resource resource) {
        if (resource == this.bpmnResource) {
            URI newURI = resource.getURI();
            URI modelUri = this.getModelUri();
            Bpmn2Preferences preferences = this.getPreferences();
            if (!modelUri.equals(newURI)) {
                ModelHandlerLocator.remove((URI)modelUri);
                modelUri = newURI;
                if (preferences != null) {
                    preferences.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
                    preferences.dispose();
                    preferences = null;
                }
                this.targetRuntime = null;
                this.modelHandler = ModelHandlerLocator.createModelHandler((URI)modelUri, (Bpmn2ResourceImpl)((Bpmn2ResourceImpl)resource));
                ModelHandlerLocator.put((URI)this.diagramUri, (ModelHandler)this.modelHandler);
                Bpmn2DiagramEditorInput input = (Bpmn2DiagramEditorInput)this.getEditorInput();
                input.updateUri(newURI);
                this.multipageEditor.setInput((IEditorInput)input);
            }
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (BPMN2Editor.this.getEditorInput() != null) {
                    BPMN2Editor.this.updateDirtyState();
                    BPMN2Editor.this.refreshTitle();
                }
            }
        });
        return true;
    }

    public boolean handleResourceDeleted(Resource resource) {
        this.closeEditor();
        return true;
    }

    public boolean handleResourceMoved(Resource resource, URI newURI) {
        URI oldURI = resource.getURI();
        TreeIterator iter = resource.getAllContents();
        while (iter.hasNext()) {
            EObject o = (EObject)iter.next();
            for (EReference r : o.eClass().getEAllReferences()) {
                o.eGet((EStructuralFeature)r);
            }
        }
        resource.setURI(newURI);
        if (resource == this.bpmnResource) {
            ModelHandlerLocator.remove((URI)this.modelUri);
            this.modelUri = newURI;
            if (this.preferences != null) {
                this.preferences.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
                this.preferences.dispose();
                this.preferences = null;
            }
            this.targetRuntime = null;
            this.modelHandler = ModelHandlerLocator.createModelHandler((URI)this.modelUri, (Bpmn2ResourceImpl)((Bpmn2ResourceImpl)resource));
            ModelHandlerLocator.put((URI)this.diagramUri, (ModelHandler)this.modelHandler);
            Bpmn2DiagramEditorInput input = (Bpmn2DiagramEditorInput)this.getEditorInput();
            input.updateUri(newURI);
            this.multipageEditor.setInput((IEditorInput)input);
            this.handleResourceChanged(resource);
        } else if (this.diagramUri.equals(oldURI)) {
            ModelHandlerLocator.remove((URI)this.diagramUri);
            this.diagramUri = newURI;
            ModelHandlerLocator.put((URI)this.diagramUri, (ModelHandler)this.modelHandler);
        }
        return true;
    }

    @Override
    public void dispose() {
        File diagramFile;
        IWorkbenchPage[] pages;
        int instances = 0;
        IWorkbenchPage[] iWorkbenchPageArray = pages = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference[] refs;
            IWorkbenchPage p = iWorkbenchPageArray[n2];
            IEditorReference[] iEditorReferenceArray = refs = p.findEditors(null, EDITOR_ID, 2);
            int n3 = refs.length;
            int n4 = 0;
            while (n4 < n3) {
                IEditorReference r = iEditorReferenceArray[n4];
                if (r.getEditor(false) instanceof BPMN2MultiPageEditor && ((BPMN2MultiPageEditor)r.getEditor((boolean)false)).designEditor != this) {
                    ++instances;
                }
                ++n4;
            }
            ++n2;
        }
        BPMN2Editor otherEditor = BPMN2Editor.findOpenEditor((IEditorPart)this, this.getEditorInput());
        if (otherEditor == null && this.diagramUri != null && (diagramFile = new File(this.diagramUri.toFileString())).exists()) {
            try {
                diagramFile.delete();
            }
            catch (Exception exception) {}
        }
        if (this.modelHandler != null) {
            ModelUtil.clearIDs((Resource)this.modelHandler.getResource(), (instances == 0 ? 1 : 0) != 0);
        }
        this.removeSelectionListener();
        if (instances == 0) {
            this.setActiveEditor(null);
        }
        super.dispose();
        if (this.modelUri != null && !this.workbenchShutdown && FileUtils.isTempFile((URI)this.modelUri)) {
            FileUtils.deleteTempFile((URI)this.modelUri);
        }
        this.removeWorkbenchListener();
        this.removeMarkerChangeListener();
    }

    public static BPMN2Editor findOpenEditor(IEditorPart newEditor, IEditorInput newInput) {
        if (newEditor != null && newInput != null) {
            IWorkbenchPage[] pages;
            IWorkbenchPage[] iWorkbenchPageArray = pages = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPages();
            int n = pages.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference[] otherEditors;
                IWorkbenchPage page = iWorkbenchPageArray[n2];
                IEditorReference[] iEditorReferenceArray = otherEditors = page.findEditors(newInput, null, 1);
                int n3 = otherEditors.length;
                int n4 = 0;
                while (n4 < n3) {
                    BPMN2Editor otherEditor;
                    IEditorReference ref = iEditorReferenceArray[n4];
                    IEditorPart part = ref.getEditor(true);
                    if (part instanceof BPMN2MultiPageEditor ? (otherEditor = ((BPMN2MultiPageEditor)part).getDesignEditor()) != newEditor : part instanceof BPMN2Editor && (otherEditor = (BPMN2Editor)part) != newEditor) {
                        return otherEditor;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    public class ExtendedEditorInputHelper
    extends DefaultBPMN2Editor.EditorInputHelper {
        private BPMN2Editor otherEditor;

        @Override
        public void preSetInput(IEditorInput input, DefaultBPMN2Editor editor) {
            input = this.recreateInput(input, editor);
            this.otherEditor = BPMN2Editor.findOpenEditor((IEditorPart)editor, input);
            ResourceSet resourceSet = this.initializeResourceSet(input, editor);
            editor.bpmnResource = this.otherEditor == null ? this.createBPMN2Resource(editor, resourceSet) : this.otherEditor.bpmnResource;
        }

        @Override
        public void postSetInput(IEditorInput input, DefaultBPMN2Editor editor) {
            super.postSetInput(input, editor);
            ((BPMN2Editor)editor).loadMarkers();
        }

        @Override
        protected void importDiagram(IEditorInput input, DefaultBPMN2Editor editor) {
            if (this.otherEditor == null) {
                super.importDiagram(input, editor);
            }
        }
    }
}

