/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.internal;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.eclipse.jubula.autagent.common.commands.AbstractStartJavaAut;
import org.eclipse.jubula.autagent.common.utils.IAUTStartHelper;

public class APIAgentAutStartHelper
implements IAUTStartHelper {
    public static final String EXTENSION_DIR = "ext";
    private static final String JAR = ".jar";
    private static final String MANIFEST_HOST_KEY = "Fragment-Host";
    private static final FilenameFilter JARFILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return dir.exists() && name.endsWith(APIAgentAutStartHelper.JAR);
        }
    };

    public File getInstallationDirectory() {
        CodeSource codeSource = APIAgentAutStartHelper.class.getProtectionDomain().getCodeSource();
        File file = new File(codeSource.getLocation().getPath());
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        return file;
    }

    public String getMonitoringAgent(Map<String, String> parameters) {
        return null;
    }

    public String[] getClasspathEntriesForBundleId(String bundleId) {
        File f = this.getInstallationDirectory();
        String path = f.getAbsolutePath();
        ArrayList<String> jarList = new ArrayList<String>(1);
        jarList.add(String.valueOf(path) + FileSystems.getDefault().getSeparator() + bundleId + JAR);
        this.getFragmentsforBundleId(bundleId, f);
        return jarList.toArray(new String[jarList.size()]);
    }

    private List<File> getFragmentsforBundleId(String bundleId, File installDir) {
        ArrayList<File> files = new ArrayList<File>();
        File[] jars = installDir.listFiles(JARFILTER);
        if (jars == null) {
            return files;
        }
        File[] fileArray = jars;
        int n = jars.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            try {
                Throwable throwable = null;
                Object var10_11 = null;
                try (JarFile jar = new JarFile(file);){
                    Attributes attributes = jar.getManifest().getMainAttributes();
                    String value = attributes.getValue(MANIFEST_HOST_KEY);
                    if (value != null && value.equals(bundleId)) {
                        files.add(file);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
            ++n2;
        }
        return files;
    }

    public Map<String, String> getFragmentPathforBundleID(String rcBundleID) {
        HashMap<String, String> fragmentMap = new HashMap<String, String>();
        File installDir = AbstractStartJavaAut.getInstallDir();
        File extDir = new File(installDir, EXTENSION_DIR);
        List<File> fragmentsfromExt = this.getFragmentsforBundleId(rcBundleID, extDir);
        for (File file : fragmentsfromExt) {
            fragmentMap.put(file.getAbsolutePath(), file.getName());
        }
        List<File> fragmentsfromMain = this.getFragmentsforBundleId(rcBundleID, installDir);
        for (File file : fragmentsfromMain) {
            fragmentMap.put(file.getAbsolutePath(), file.getName());
        }
        return fragmentMap;
    }
}

