/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.memory.transport;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import org.eclipse.cdt.debug.core.memory.transport.FileImport;
import org.eclipse.cdt.debug.core.memory.transport.ImportRequest;
import org.eclipse.cdt.debug.internal.core.memory.transport.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.osgi.framework.FrameworkUtil;

public final class PlainTextImport
extends FileImport<BufferedReader> {
    public PlainTextImport(File input, ImportRequest request, Consumer<BigInteger> scroll) {
        super(input, request, scroll);
    }

    @Override
    protected BufferedReader input(File file) throws FileNotFoundException {
        return new BufferedReader(new InputStreamReader(new FileInputStream(file)));
    }

    @Override
    protected void transfer(BufferedReader reader, BigInteger factor, IProgressMonitor monitor) throws IOException, DebugException {
        BigInteger recordAddress = this.start;
        String line = reader.readLine();
        int lineNo = 1;
        while (line != null && !monitor.isCanceled()) {
            StringTokenizer st = new StringTokenizer(line, " ");
            int bytesRead = 0;
            while (st.hasMoreElements()) {
                String valueString = (String)st.nextElement();
                int position = 0;
                byte[] data = new byte[valueString.length() / 2];
                int i = 0;
                while (i < data.length) {
                    try {
                        data[i] = new BigInteger(valueString.substring(position++, position++ + 1), 16).byteValue();
                    }
                    catch (NumberFormatException ex) {
                        throw new DebugException((IStatus)new Status(4, FrameworkUtil.getBundle(this.getClass()).getSymbolicName(), 5012, String.format(Messages.PlainTextImport_e_invalid_format, lineNo), (Throwable)ex));
                    }
                    ++i;
                }
                BigInteger writeAddress = recordAddress.subtract(this.base).add(BigInteger.valueOf(bytesRead));
                this.write.to(writeAddress, data);
                bytesRead += data.length;
            }
            recordAddress = recordAddress.add(BigInteger.valueOf(bytesRead));
            this.scroll.accept(recordAddress);
            BigInteger jobCount = BigInteger.valueOf(bytesRead).divide(factor);
            monitor.worked(jobCount.intValue());
            line = reader.readLine();
            ++lineNo;
        }
    }
}

