/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.editor;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.ui.actions.AbstractToggleLinkingAction;
import org.eclipse.dltk.internal.ui.actions.CompositeActionGroup;
import org.eclipse.dltk.internal.ui.actions.refactoring.RefactorActionGroup;
import org.eclipse.dltk.internal.ui.dnd.DLTKViewerDragSupport;
import org.eclipse.dltk.internal.ui.dnd.DLTKViewerDropSupport;
import org.eclipse.dltk.internal.ui.editor.DLTKEditorMessages;
import org.eclipse.dltk.internal.ui.editor.IScriptEditor;
import org.eclipse.dltk.internal.ui.editor.TogglePresentationAction;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.MembersOrderPreferenceCache;
import org.eclipse.dltk.ui.ModelElementSorter;
import org.eclipse.dltk.ui.ProblemsLabelDecorator;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.dltk.ui.actions.CustomFiltersActionGroup;
import org.eclipse.dltk.ui.actions.MemberFilterActionGroup;
import org.eclipse.dltk.ui.actions.OpenViewActionGroup;
import org.eclipse.dltk.ui.actions.SearchActionGroup;
import org.eclipse.dltk.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.dltk.ui.viewsupport.SourcePositionSorter;
import org.eclipse.dltk.ui.viewsupport.StatusBarUpdater;
import org.eclipse.dltk.ui.viewsupport.StyledDecoratingModelLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class ScriptOutlinePage
extends Page
implements IContentOutlinePage,
IAdaptable,
IPostSelectionProvider {
    private DLTKViewerDropSupport fDropSupport;
    static final Object[] NO_CHILDREN = new Object[0];
    private IModelElement fInput;
    private Menu fMenu;
    protected ScriptOutlineViewer fOutlineViewer;
    private IScriptEditor fEditor;
    protected IPreferenceStore fStore;
    private MemberFilterActionGroup fMemberFilterActionGroup;
    private ListenerList<ISelectionChangedListener> fSelectionChangedListeners = new ListenerList(1);
    private ListenerList<ISelectionChangedListener> fPostSelectionChangedListeners = new ListenerList(1);
    private Hashtable<String, IAction> fActions = new Hashtable();
    private TogglePresentationAction fTogglePresentation;
    private ToggleLinkingAction fToggleLinkingAction;
    private CompositeActionGroup fActionGroups;
    private IPropertyChangeListener fPropertyChangeListener;
    private CustomFiltersActionGroup fCustomFiltersActionGroup;

    public ScriptOutlinePage(IScriptEditor editor, IPreferenceStore store) {
        Assert.isNotNull((Object)editor);
        this.fEditor = editor;
        this.fStore = store;
        if (editor instanceof ITextEditor) {
            this.fTogglePresentation = new TogglePresentationAction();
            this.fTogglePresentation.setEditor((ITextEditor)editor);
        }
        this.fPropertyChangeListener = event -> this.doPropertyChange(event);
        this.fStore.addPropertyChangeListener(this.fPropertyChangeListener);
    }

    protected void addAction(IMenuManager menu, String group, String actionID) {
        IAction action = this.getAction(actionID);
        if (action != null) {
            if (action instanceof IUpdate) {
                ((IUpdate)action).update();
            }
            if (action.isEnabled()) {
                IMenuManager subMenu = menu.findMenuUsingPath(group);
                if (subMenu != null) {
                    subMenu.add(action);
                } else {
                    menu.appendToGroup(group, action);
                }
            }
        }
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.addPostSelectionChangedListener(listener);
        } else {
            this.fPostSelectionChangedListeners.add((Object)listener);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.addSelectionChangedListener(listener);
        } else {
            this.fSelectionChangedListeners.add((Object)listener);
        }
    }

    protected void contextMenuAboutToShow(IMenuManager menu) {
        if (menu.isEmpty()) {
            menu.add((IContributionItem)new GroupMarker("group.goto"));
            menu.add((IContributionItem)new Separator("group.open"));
            menu.add((IContributionItem)new GroupMarker("group.show"));
            menu.add((IContributionItem)new Separator("group.edit"));
            menu.add((IContributionItem)new Separator("group.reorganize"));
            menu.add((IContributionItem)new Separator("group.search"));
            menu.add((IContributionItem)new Separator("additions"));
            menu.add((IContributionItem)new Separator("group.properties"));
        }
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        this.fActionGroups.setContext(new ActionContext((ISelection)selection));
        this.fActionGroups.fillContextMenu(menu);
    }

    protected ILabelDecorator getLabelDecorator() {
        return null;
    }

    public void createControl(Composite parent) {
        Tree tree = new Tree(parent, 2);
        AppearanceAwareLabelProvider lprovider = new AppearanceAwareLabelProvider(0x201000000402BL | ScriptElementLabels.ALL_CATEGORY | 0x20L, 1, this.fStore);
        ILabelDecorator ldecorator = this.getLabelDecorator();
        if (ldecorator != null) {
            lprovider.addLabelDecorator(ldecorator);
        }
        this.fOutlineViewer = new ScriptOutlineViewer(tree);
        this.initDragAndDrop();
        this.fOutlineViewer.setContentProvider((IContentProvider)new ChildrenProvider());
        this.fOutlineViewer.setLabelProvider((IBaseLabelProvider)new StyledDecoratingModelLabelProvider(lprovider));
        for (ISelectionChangedListener listener : this.fSelectionChangedListeners) {
            this.fSelectionChangedListeners.remove((Object)listener);
            this.fOutlineViewer.addSelectionChangedListener(listener);
        }
        for (ISelectionChangedListener listener : this.fPostSelectionChangedListeners) {
            this.fPostSelectionChangedListeners.remove((Object)listener);
            this.fOutlineViewer.addPostSelectionChangedListener(listener);
        }
        MenuManager manager = new MenuManager(String.valueOf(DLTKUIPlugin.getPluginId()) + ".outline", String.valueOf(DLTKUIPlugin.getPluginId()) + ".outline");
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(m -> this.contextMenuAboutToShow(m));
        this.fMenu = manager.createContextMenu((Control)tree);
        tree.setMenu(this.fMenu);
        IPageSite site = this.getSite();
        site.registerContextMenu(String.valueOf(DLTKUIPlugin.getPluginId()) + ".outline", manager, (ISelectionProvider)this.fOutlineViewer);
        this.updateSelectionProvider(site);
        IDLTKLanguageToolkit toolkit = this.fEditor.getLanguageToolkit();
        this.fActionGroups = new CompositeActionGroup(new ActionGroup[]{new OpenViewActionGroup(this), new RefactorActionGroup(this, toolkit), new SearchActionGroup(this, toolkit)});
        IActionBars actionBars = site.getActionBars();
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.UNDO, this.fEditor.getAction(ITextEditorActionConstants.UNDO));
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.REDO, this.fEditor.getAction(ITextEditorActionConstants.REDO));
        IAction action = this.fEditor.getAction(ITextEditorActionConstants.NEXT);
        actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoNextAnnotation", action);
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.NEXT, action);
        action = this.fEditor.getAction(ITextEditorActionConstants.PREVIOUS);
        actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoPreviousAnnotation", action);
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.PREVIOUS, action);
        if (this.fTogglePresentation != null) {
            actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.toggleShowSelectedElementOnly", (IAction)this.fTogglePresentation);
        }
        this.fActionGroups.fillActionBars(actionBars);
        IStatusLineManager statusLineManager = actionBars.getStatusLineManager();
        if (statusLineManager != null) {
            StatusBarUpdater updater = new StatusBarUpdater(statusLineManager);
            this.fOutlineViewer.addPostSelectionChangedListener(updater);
        }
        this.fCustomFiltersActionGroup = new CustomFiltersActionGroup("org.eclipse.dltk.ui.ScriptOutlinePage", (StructuredViewer)this.fOutlineViewer);
        this.registerToolbarActions(actionBars);
        this.fOutlineViewer.setInput(this.fInput);
    }

    public void dispose() {
        if (this.fEditor == null) {
            return;
        }
        if (this.fMemberFilterActionGroup != null) {
            this.fMemberFilterActionGroup.dispose();
            this.fMemberFilterActionGroup = null;
        }
        if (this.fCustomFiltersActionGroup != null) {
            this.fCustomFiltersActionGroup.dispose();
            this.fCustomFiltersActionGroup = null;
        }
        this.fEditor.outlinePageClosed();
        this.fEditor = null;
        this.fSelectionChangedListeners.clear();
        this.fSelectionChangedListeners = null;
        this.fPostSelectionChangedListeners.clear();
        this.fPostSelectionChangedListeners = null;
        if (this.fPropertyChangeListener != null) {
            this.fStore.removePropertyChangeListener(this.fPropertyChangeListener);
            this.fPropertyChangeListener = null;
        }
        if (this.fMenu != null && !this.fMenu.isDisposed()) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
        if (this.fActionGroups != null) {
            this.fActionGroups.dispose();
        }
        if (this.fTogglePresentation != null) {
            this.fTogglePresentation.setEditor(null);
        }
        this.fOutlineViewer = null;
        super.dispose();
    }

    private void doPropertyChange(PropertyChangeEvent event) {
        if (this.fOutlineViewer != null && MembersOrderPreferenceCache.isMemberOrderProperty(event.getProperty())) {
            this.fOutlineViewer.refresh(false);
        }
    }

    public IAction getAction(String actionID) {
        Assert.isNotNull((Object)actionID);
        return this.fActions.get(actionID);
    }

    public <T> T getAdapter(Class<T> key) {
        if (key == IShowInSource.class) {
            return (T)this.getShowInSource();
        }
        if (key == IShowInTargetList.class) {
            return (T)((IShowInTargetList)() -> new String[]{"org.eclipse.dltk.ui.ScriptExplorer"});
        }
        if (key == IShowInTarget.class) {
            return (T)this.getShowInTarget();
        }
        return null;
    }

    public Control getControl() {
        if (this.fOutlineViewer != null) {
            return this.fOutlineViewer.getControl();
        }
        return null;
    }

    protected final ScriptOutlineViewer getOutlineViewer() {
        return this.fOutlineViewer;
    }

    public ISelection getSelection() {
        if (this.fOutlineViewer == null) {
            return StructuredSelection.EMPTY;
        }
        return this.fOutlineViewer.getSelection();
    }

    protected IShowInSource getShowInSource() {
        return () -> new ShowInContext(null, this.getSite().getSelectionProvider().getSelection());
    }

    protected IShowInTarget getShowInTarget() {
        return context -> {
            ISelection sel = context.getSelection();
            if (sel instanceof ITextSelection) {
                ITextSelection tsel = (ITextSelection)sel;
                int offset = tsel.getOffset();
                IModelElement element = this.fEditor.getElementAt(offset);
                if (element != null) {
                    this.setSelection((ISelection)new StructuredSelection((Object)element));
                    return true;
                }
            } else if (sel instanceof IStructuredSelection) {
                this.setSelection(sel);
                return true;
            }
            return false;
        };
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
    }

    private void initDragAndDrop() {
        this.fDropSupport = new DLTKViewerDropSupport((StructuredViewer)this.fOutlineViewer);
        this.fDropSupport.start();
        new DLTKViewerDragSupport((StructuredViewer)this.fOutlineViewer).start();
    }

    protected boolean collapseInitially(@NonNull IModelElement element) {
        IModelElement parent;
        int elementType = element.getElementType();
        if (elementType == 11) {
            return true;
        }
        if (elementType == 7) {
            IModelElement parent2 = element.getParent();
            return parent2 != null && parent2.getElementType() != 5;
        }
        if ((elementType == 9 || elementType == 8) && (parent = element.getParent()) != null && parent.getElementType() == 7) {
            try {
                if (!this.containsTypes((IMember)element)) {
                    return true;
                }
            }
            catch (ModelException e) {
                DLTKUIPlugin.log(e);
            }
        }
        return false;
    }

    private boolean containsTypes(IMember element) throws ModelException {
        IModelElement[] iModelElementArray = element.getChildren();
        int n = iModelElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IModelElement child = iModelElementArray[n2];
            if (child.getElementType() == 7 || child instanceof IMember && this.containsTypes((IMember)child)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void registerSpecialToolbarActions(IActionBars actionBars) {
    }

    private void registerToolbarActions(IActionBars actionBars) {
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.add((IAction)new LexicalSortingAction());
        this.fMemberFilterActionGroup = new MemberFilterActionGroup((StructuredViewer)this.fOutlineViewer, this.fStore);
        this.fMemberFilterActionGroup.contributeToToolBar(toolBarManager);
        this.fCustomFiltersActionGroup.fillActionBars(actionBars);
        this.registerSpecialToolbarActions(actionBars);
        IMenuManager viewMenuManager = actionBars.getMenuManager();
        viewMenuManager.add((IContributionItem)new Separator("EndFilterGroup"));
        this.fToggleLinkingAction = new ToggleLinkingAction(this);
        viewMenuManager.add((IAction)this.fToggleLinkingAction);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.removePostSelectionChangedListener(listener);
        } else {
            this.fPostSelectionChangedListeners.remove((Object)listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.removeSelectionChangedListener(listener);
        } else {
            this.fSelectionChangedListeners.remove((Object)listener);
        }
    }

    public void select(ISourceReference reference) {
        IStructuredSelection ss;
        List elements;
        ISelection s;
        if (this.fOutlineViewer != null && (s = this.fOutlineViewer.getSelection()) instanceof IStructuredSelection && !(elements = (ss = (IStructuredSelection)s).toList()).contains(reference)) {
            s = reference == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)reference);
            this.fOutlineViewer.setSelection(s, true);
        }
    }

    public void setAction(String actionID, IAction action) {
        Assert.isNotNull((Object)actionID);
        if (action == null) {
            this.fActions.remove(actionID);
        } else {
            this.fActions.put(actionID, action);
        }
    }

    public void setFocus() {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.getControl().setFocus();
        }
    }

    public void setInput(IModelElement inputElement) {
        this.fInput = inputElement;
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.setInput(this.fInput);
            this.updateSelectionProvider(this.getSite());
        }
    }

    public void setSelection(ISelection selection) {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.setSelection(selection);
        }
    }

    private void updateSelectionProvider(IPageSite site) {
        ISourceModule cu;
        Object provider = this.fOutlineViewer;
        if (this.fInput != null && (cu = (ISourceModule)this.fInput.getAncestor(5)) != null && !ScriptModelUtil.isPrimary((ISourceModule)cu)) {
            provider = new EmptySelectionProvider();
        }
        site.setSelectionProvider((ISelectionProvider)provider);
    }

    protected class ChildrenProvider
    implements ITreeContentProvider {
        private ElementChangedListener fListener;

        protected ChildrenProvider() {
        }

        public void dispose() {
            if (this.fListener != null) {
                DLTKCore.removeElementChangedListener((IElementChangedListener)this.fListener);
                this.fListener = null;
            }
        }

        protected IModelElement[] filter(IModelElement[] children) {
            boolean initializers = false;
            int i = 0;
            while (i < children.length) {
                if (this.matches(children[i])) {
                    initializers = true;
                    break;
                }
                ++i;
            }
            if (!initializers) {
                return children;
            }
            ArrayList<IModelElement> v = new ArrayList<IModelElement>();
            int i2 = 0;
            while (i2 < children.length) {
                if (!this.matches(children[i2])) {
                    v.add(children[i2]);
                }
                ++i2;
            }
            return v.toArray(new IModelElement[v.size()]);
        }

        public Object[] getChildren(Object parent) {
            block3: {
                if (parent instanceof IParent) {
                    IParent c = (IParent)parent;
                    try {
                        return this.filter(c.getChildren());
                    }
                    catch (ModelException x) {
                        if (!DLTKCore.DEBUG && x.isDoesNotExist()) break block3;
                        DLTKUIPlugin.log(x);
                    }
                }
            }
            return NO_CHILDREN;
        }

        public Object[] getElements(Object parent) {
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            if (child instanceof IModelElement) {
                IModelElement e = (IModelElement)child;
                return e.getParent();
            }
            return null;
        }

        public boolean hasChildren(Object parent) {
            block3: {
                if (parent instanceof IParent) {
                    IParent c = (IParent)parent;
                    try {
                        IModelElement[] children = this.filter(c.getChildren());
                        return children != null && children.length > 0;
                    }
                    catch (ModelException x) {
                        if (!DLTKUIPlugin.isDebug() && x.isDoesNotExist()) break block3;
                        DLTKUIPlugin.log(x);
                    }
                }
            }
            return false;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            boolean isCU = newInput instanceof ISourceModule;
            if (isCU && this.fListener == null) {
                this.fListener = new ElementChangedListener();
                DLTKCore.addElementChangedListener((IElementChangedListener)this.fListener);
            } else if (!isCU && this.fListener != null) {
                DLTKCore.removeElementChangedListener((IElementChangedListener)this.fListener);
                this.fListener = null;
            }
        }

        protected boolean matches(IModelElement element) {
            if (element.getElementType() == 9) {
                String name = element.getElementName();
                return name != null && name.indexOf(60) >= 0;
            }
            return false;
        }
    }

    protected class ElementChangedListener
    implements IElementChangedListener {
        protected ElementChangedListener() {
        }

        public void elementChanged(ElementChangedEvent e) {
            if (ScriptOutlinePage.this.getControl() == null) {
                return;
            }
            Display d = ScriptOutlinePage.this.getControl().getDisplay();
            if (d != null) {
                d.asyncExec(() -> {
                    ISourceModule cu = (ISourceModule)ScriptOutlinePage.this.fInput;
                    ISourceModule base = cu;
                    IModelElementDelta delta = this.findElement((IModelElement)base, e.getDelta());
                    if (delta != null && ScriptOutlinePage.this.fOutlineViewer != null) {
                        ScriptOutlinePage.this.fOutlineViewer.reconcile(delta);
                    }
                });
            }
        }

        protected IModelElementDelta findElement(IModelElement unit, IModelElementDelta delta) {
            if (delta == null || unit == null) {
                return null;
            }
            IModelElement element = delta.getElement();
            if (unit.equals(element)) {
                if (this.isPossibleStructuralChange(delta)) {
                    return delta;
                }
                return null;
            }
            if (element.getElementType() > 5) {
                return null;
            }
            IModelElementDelta[] children = delta.getAffectedChildren();
            if (children == null || children.length == 0) {
                return null;
            }
            int i = 0;
            while (i < children.length) {
                IModelElementDelta d = this.findElement(unit, children[i]);
                if (d != null) {
                    return d;
                }
                ++i;
            }
            return null;
        }

        private boolean isPossibleStructuralChange(IModelElementDelta cuDelta) {
            if (cuDelta.getKind() != 4) {
                return true;
            }
            int flags = cuDelta.getFlags();
            if ((flags & 8) != 0) {
                return true;
            }
            return (flags & 0x4001) == 1;
        }
    }

    private static final class EmptySelectionProvider
    implements ISelectionProvider {
        private EmptySelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            return StructuredSelection.EMPTY;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void setSelection(ISelection selection) {
        }
    }

    class LexicalSortingAction
    extends Action {
        private static final String LEXICAL_SORTING_ACTION_IS_CHECKED = "LexicalSortingAction.isChecked";
        private ModelElementSorter fComparator = new ModelElementSorter();
        private SourcePositionSorter fSourcePositonComparator = new SourcePositionSorter();

        public LexicalSortingAction() {
            this.setText(DLTKEditorMessages.ScriptOutlinePage_Sort_label);
            DLTKPluginImages.setLocalImageDescriptors((IAction)this, "alphab_sort_co.png");
            this.setToolTipText(DLTKEditorMessages.ScriptOutlinePage_Sort_tooltip);
            this.setDescription(DLTKEditorMessages.ScriptOutlinePage_Sort_description);
            boolean checked = ScriptOutlinePage.this.fStore.getBoolean(LEXICAL_SORTING_ACTION_IS_CHECKED);
            this.valueChanged(checked, false);
        }

        public void run() {
            this.valueChanged(this.isChecked(), true);
        }

        private void valueChanged(boolean on, boolean store) {
            this.setChecked(on);
            BusyIndicator.showWhile((Display)ScriptOutlinePage.this.fOutlineViewer.getControl().getDisplay(), () -> {
                if (on) {
                    ScriptOutlinePage.this.fOutlineViewer.setComparator((ViewerComparator)this.fComparator);
                    ScriptOutlinePage.this.fDropSupport.setFeedbackEnabled(false);
                } else {
                    ScriptOutlinePage.this.fOutlineViewer.setComparator((ViewerComparator)this.fSourcePositonComparator);
                    ScriptOutlinePage.this.fDropSupport.setFeedbackEnabled(true);
                }
            });
            if (store) {
                ScriptOutlinePage.this.fStore.setValue(LEXICAL_SORTING_ACTION_IS_CHECKED, on);
            }
        }
    }

    protected class ScriptOutlineViewer
    extends TreeViewer {
        public ScriptOutlineViewer(Tree tree) {
            super(tree);
            this.setAutoExpandLevel(-1);
            this.setUseHashlookup(true);
        }

        private IResource getUnderlyingResource() {
            Object input = this.getInput();
            if (input instanceof ISourceModule) {
                ISourceModule cu = (ISourceModule)input;
                cu = cu.getPrimary();
                return cu.getResource();
            }
            return null;
        }

        protected void handleLabelProviderChanged(LabelProviderChangedEvent event) {
            IResource resource;
            ProblemsLabelDecorator.ProblemsLabelChangedEvent e;
            Object input = this.getInput();
            if (event instanceof ProblemsLabelDecorator.ProblemsLabelChangedEvent && (e = (ProblemsLabelDecorator.ProblemsLabelChangedEvent)event).isMarkerChange() && input instanceof ISourceModule) {
                return;
            }
            Object[] changed = event.getElements();
            if (changed != null && (resource = this.getUnderlyingResource()) != null) {
                int i = 0;
                while (i < changed.length) {
                    if (changed[i] != null && changed[i].equals(resource)) {
                        event = new LabelProviderChangedEvent((IBaseLabelProvider)event.getSource());
                        break;
                    }
                    ++i;
                }
            }
            super.handleLabelProviderChanged(event);
        }

        protected void internalExpandToLevel(Widget node, int level) {
            IModelElement je;
            Item i;
            if (node instanceof Item && (i = (Item)node).getData() instanceof IModelElement && ScriptOutlinePage.this.collapseInitially(je = (IModelElement)i.getData())) {
                this.setExpanded(i, false);
                return;
            }
            super.internalExpandToLevel(node, level);
        }

        public boolean isExpandable(Object element) {
            if (this.hasFilters()) {
                return this.getFilteredChildren(element).length > 0;
            }
            return super.isExpandable(element);
        }

        public void reconcile(IModelElementDelta delta) {
            this.refresh(true);
        }
    }

    public class ToggleLinkingAction
    extends AbstractToggleLinkingAction {
        ScriptOutlinePage fJavaOutlinePage;

        public ToggleLinkingAction(ScriptOutlinePage outlinePage) {
            boolean isLinkingEnabled = ScriptOutlinePage.this.fStore.getBoolean("syncOutlineOnCursorMove");
            this.setChecked(isLinkingEnabled);
            this.fJavaOutlinePage = outlinePage;
        }

        @Override
        public void run() {
            ScriptOutlinePage.this.fStore.setValue("syncOutlineOnCursorMove", this.isChecked());
            if (this.isChecked() && ScriptOutlinePage.this.fEditor != null) {
                ScriptOutlinePage.this.fEditor.synchronizeOutlinePage(ScriptOutlinePage.this.fEditor.computeHighlightRangeSourceReference(), false);
            }
        }
    }
}

