/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.query.quantize;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.ContextDerivedData;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IContextObjectSet;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IResultTable;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.query.quantize.KeyCalculator;
import org.eclipse.mat.report.internal.Messages;

public final class Quantize {
    public static final Function.Factory COUNT = new FnFactoryImpl(Count.class, Integer.class, false);
    public static final Function.Factory SUM = new FnFactoryImpl(Sum.class, Double.class, false);
    public static final Function.Factory SUM_LONG = new FnFactoryImpl(SumLong.class, Long.class, false);
    public static final Function.Factory MIN = new FnFactoryImpl(Min.class, Double.class, true);
    public static final Function.Factory MIN_LONG = new FnFactoryImpl(MinLong.class, Long.class, true);
    public static final Function.Factory MAX = new FnFactoryImpl(Max.class, Double.class, true);
    public static final Function.Factory MAX_LONG = new FnFactoryImpl(MaxLong.class, Long.class, true);
    public static final Function.Factory AVERAGE = new FnFactoryImpl(Average.class, Double.class, true);
    public static final Function.Factory AVERAGE_LONG = new FnFactoryImpl(AverageLong.class, Double.class, true);
    private ResultMetaData resultMetaData;
    private KeyCalculator keyCalculator;
    private int keyLength;
    private Map<Object, BucketImpl> key2bucket;
    private List<Column> columns;
    private List<Function.Factory> functions;

    public static Builder valueDistribution(String ... label) {
        KeyCalculator key = label.length > 1 ? new KeyCalculator.MultipleKeys(label.length) : new KeyCalculator();
        Builder builder = new Builder(new Quantize(key));
        String[] stringArray = label;
        int n = label.length;
        int n2 = 0;
        while (n2 < n) {
            String l = stringArray[n2];
            builder.addKeyColumn(new Column(l));
            ++n2;
        }
        return builder;
    }

    public static Builder valueDistribution(Column ... column) {
        KeyCalculator key = column.length > 1 ? new KeyCalculator.MultipleKeys(column.length) : new KeyCalculator();
        Builder builder = new Builder(new Quantize(key));
        Column[] columnArray = column;
        int n = column.length;
        int n2 = 0;
        while (n2 < n) {
            Column c = columnArray[n2];
            builder.addKeyColumn(c);
            ++n2;
        }
        return builder;
    }

    public static Builder linearFrequencyDistribution(String label, double lowerBound, double upperBound, double step) {
        String lessEq = Messages.Quantize_LessEq_Prefix;
        DecimalFormat format = new DecimalFormat("#,##0.00");
        format.setPositivePrefix(String.valueOf(lessEq) + format.getPositivePrefix());
        format.setNegativePrefix(String.valueOf(lessEq) + format.getNegativePrefix());
        NumberFormat nf = NumberFormat.getNumberInstance();
        if (nf instanceof DecimalFormat) {
            DecimalFormat df = (DecimalFormat)nf;
            int digits = Math.max(0, (int)Math.log10(20.0 / step));
            df.setMinimumFractionDigits(digits);
            df.setMaximumFractionDigits(digits);
            df.setPositivePrefix(String.valueOf(lessEq) + df.getPositivePrefix());
            df.setNegativePrefix(String.valueOf(lessEq) + df.getNegativePrefix());
            format = df;
        }
        return new Builder(new Quantize(new KeyCalculator.LinearDistributionDouble(lowerBound, upperBound, step))).addKeyColumn(new Column(label, Double.class).formatting((Format)format).noTotals());
    }

    public static Builder linearFrequencyDistribution(String label, long lowerBound, long upperBound, long step) {
        String lessEq = Messages.Quantize_LessEq_Prefix;
        DecimalFormat format = new DecimalFormat("#,##0");
        format.setPositivePrefix(String.valueOf(lessEq) + format.getPositivePrefix());
        format.setNegativePrefix(String.valueOf(lessEq) + format.getNegativePrefix());
        NumberFormat nf = NumberFormat.getIntegerInstance();
        if (nf instanceof DecimalFormat) {
            DecimalFormat df = (DecimalFormat)nf;
            df.setPositivePrefix(String.valueOf(lessEq) + df.getPositivePrefix());
            df.setNegativePrefix(String.valueOf(lessEq) + df.getNegativePrefix());
            format = df;
        }
        return new Builder(new Quantize(new KeyCalculator.LinearDistributionLong(lowerBound, upperBound, step))).addKeyColumn(new Column(label, Long.class).formatting((Format)format).noTotals());
    }

    private Quantize(KeyCalculator keyCalculator) {
        this.keyCalculator = keyCalculator;
        this.columns = new ArrayList<Column>();
        this.functions = new ArrayList<Function.Factory>();
    }

    protected void init() {
        this.key2bucket = new HashMap<Object, BucketImpl>();
    }

    public void addValue(int objectId, Object ... columnValues) throws SnapshotException {
        BucketImpl bucket = this.internalAddValue(columnValues);
        if (objectId >= 0) {
            bucket.objectIds.add(objectId);
        }
    }

    public void addValue(int[] objectIds, Object ... columnValues) throws SnapshotException {
        BucketImpl bucket = this.internalAddValue(columnValues);
        if (objectIds != null) {
            bucket.objectIds.addAll(objectIds);
        }
    }

    private BucketImpl internalAddValue(Object[] columnValues) throws SnapshotException {
        if (columnValues.length != this.columns.size()) {
            throw new UnsupportedOperationException(Messages.Quantize_Error_MismatchArgumentsColumns);
        }
        try {
            Object key = this.keyCalculator.getKey(columnValues);
            BucketImpl bucket = this.key2bucket.get(key);
            if (bucket == null) {
                Function[] fx = new Function[this.columns.size() - this.keyLength];
                int ii = 0;
                while (ii < fx.length) {
                    fx[ii] = this.functions.get(ii).build();
                    ++ii;
                }
                bucket = new BucketImpl(key, fx);
                this.key2bucket.put(key, bucket);
            }
            int ii = 0;
            while (ii < bucket.functions.length) {
                bucket.functions[ii].add(columnValues[ii + this.keyLength]);
                ++ii;
            }
            return bucket;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw SnapshotException.rethrow(e);
        }
    }

    public IResult getResult() {
        ArrayList<BucketImpl> list = new ArrayList<BucketImpl>(this.key2bucket.values());
        try {
            Collections.sort(list, new Comparator<BucketImpl>(){

                @Override
                public int compare(BucketImpl o1, BucketImpl o2) {
                    Comparable key1 = (Comparable)o1.getKey();
                    Comparable key2 = (Comparable)o2.getKey();
                    if (key1 == null && key2 == null) {
                        return 0;
                    }
                    if (key1 == null) {
                        return -1;
                    }
                    if (key2 == null) {
                        return 1;
                    }
                    return key1.compareTo(key2);
                }
            });
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return new QuantizedResult(this.resultMetaData, list, this.columns, this.keyLength);
    }

    static class Average
    implements Function {
        int count;
        double sum;

        Average() {
        }

        @Override
        public void add(Object object) {
            if (object == null) {
                return;
            }
            this.sum += ((Number)object).doubleValue();
            ++this.count;
        }

        @Override
        public Object getValue() {
            return this.count > 0 ? this.sum / (double)this.count : 0.0;
        }
    }

    static class AverageLong
    implements Function {
        int count;
        long sum;

        AverageLong() {
        }

        @Override
        public void add(Object object) {
            if (object == null) {
                return;
            }
            this.sum += ((Number)object).longValue();
            ++this.count;
        }

        @Override
        public Object getValue() {
            return this.count > 0 ? this.sum / (long)this.count : 0L;
        }
    }

    private static class BucketImpl {
        Object key;
        ArrayInt objectIds;
        Function[] functions;

        BucketImpl(Object key, Function[] functions) {
            this.key = key;
            this.objectIds = new ArrayInt();
            this.functions = functions;
        }

        public Object getKey() {
            return this.key;
        }
    }

    public static final class Builder {
        Quantize quantize;
        ResultMetaData.Builder metaDataBuilder;

        private Builder(Quantize quantize) {
            this.quantize = quantize;
            this.metaDataBuilder = new ResultMetaData.Builder();
        }

        Builder addKeyColumn(Column col) {
            this.quantize.columns.add(col);
            Quantize quantize = this.quantize;
            quantize.keyLength = quantize.keyLength + 1;
            return this;
        }

        public Builder column(String label, Function.Factory function) {
            return this.column(label, function, null);
        }

        public Builder column(String label, Function.Factory function, Column.SortDirection sortDirection) {
            Column col = function.column(label).sorting(sortDirection);
            this.quantize.columns.add(col);
            this.quantize.functions.add(function);
            return this;
        }

        public Builder addDerivedData(ContextDerivedData.DerivedOperation operation) {
            this.metaDataBuilder.addDerivedData(operation);
            return this;
        }

        public Quantize build() {
            Quantize answer = this.quantize;
            this.quantize = null;
            answer.resultMetaData = this.metaDataBuilder.build();
            answer.init();
            return answer;
        }
    }

    static class Count
    implements Function {
        int count;

        Count() {
        }

        @Override
        public void add(Object object) {
            ++this.count;
        }

        @Override
        public Object getValue() {
            return this.count;
        }
    }

    private static class FnFactoryImpl
    implements Function.Factory {
        Class<? extends Function> functionClass;
        Class<?> type;
        boolean noTotals;

        public FnFactoryImpl(Class<? extends Function> functionClass, Class<?> type, boolean noTotals) {
            this.functionClass = functionClass;
            this.type = type;
            this.noTotals = noTotals;
        }

        @Override
        public Column column(String label) {
            Column column = new Column(label, this.type);
            return this.noTotals ? column.noTotals() : column;
        }

        @Override
        public Function build() throws Exception {
            return this.functionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
    }

    public static interface Function {
        public void add(Object var1);

        public Object getValue();

        public static interface Factory {
            public Function build() throws Exception;

            public Column column(String var1);
        }
    }

    static class Max
    implements Function {
        boolean hasValue = false;
        double max;

        Max() {
        }

        @Override
        public void add(Object object) {
            if (object == null) {
                return;
            }
            if (this.hasValue) {
                this.max = Math.max(this.max, ((Number)object).doubleValue());
            } else {
                this.max = ((Number)object).doubleValue();
                this.hasValue = true;
            }
        }

        @Override
        public Object getValue() {
            return this.max;
        }
    }

    static class MaxLong
    implements Function {
        boolean hasValue = false;
        long max;

        MaxLong() {
        }

        @Override
        public void add(Object object) {
            if (object == null) {
                return;
            }
            if (this.hasValue) {
                this.max = Math.max(this.max, ((Number)object).longValue());
            } else {
                this.max = ((Number)object).longValue();
                this.hasValue = true;
            }
        }

        @Override
        public Object getValue() {
            return this.max;
        }
    }

    static class Min
    implements Function {
        boolean hasValue = false;
        double min;

        Min() {
        }

        @Override
        public void add(Object object) {
            if (object == null) {
                return;
            }
            if (this.hasValue) {
                this.min = Math.min(this.min, ((Number)object).doubleValue());
            } else {
                this.min = ((Number)object).doubleValue();
                this.hasValue = true;
            }
        }

        @Override
        public Object getValue() {
            return this.min;
        }
    }

    static class MinLong
    implements Function {
        boolean hasValue = false;
        long min;

        MinLong() {
        }

        @Override
        public void add(Object object) {
            if (object == null) {
                return;
            }
            if (this.hasValue) {
                this.min = Math.min(this.min, ((Number)object).longValue());
            } else {
                this.min = ((Number)object).longValue();
                this.hasValue = true;
            }
        }

        @Override
        public Object getValue() {
            return this.min;
        }
    }

    static final class QuantizedResult
    implements IResultTable {
        private ResultMetaData resultMetaData;
        private List<BucketImpl> values;
        private List<Column> columns;
        private int keyLength;

        private QuantizedResult(ResultMetaData resultMetaData, List<BucketImpl> values, List<Column> columns, int keyLength) {
            this.resultMetaData = resultMetaData;
            this.values = values;
            this.columns = columns;
            this.keyLength = keyLength;
        }

        @Override
        public ResultMetaData getResultMetaData() {
            return this.resultMetaData;
        }

        @Override
        public Column[] getColumns() {
            return this.columns.toArray(new Column[0]);
        }

        @Override
        public Object getColumnValue(Object row, int columnIndex) {
            BucketImpl bucket = (BucketImpl)row;
            if (columnIndex >= this.keyLength) {
                return bucket.functions[columnIndex - this.keyLength].getValue();
            }
            if (this.keyLength == 1) {
                return bucket.getKey();
            }
            return ((KeyCalculator.CompositeKey)bucket.getKey()).keys[columnIndex];
        }

        @Override
        public BucketImpl getRow(int rowId) {
            return this.values.get(rowId);
        }

        @Override
        public int getRowCount() {
            return this.values.size();
        }

        @Override
        public IContextObject getContext(Object row) {
            final BucketImpl bucket = (BucketImpl)row;
            if (bucket.objectIds.size() == 1) {
                return new IContextObject(){

                    @Override
                    public int getObjectId() {
                        return bucket.objectIds.get(0);
                    }
                };
            }
            if (bucket.objectIds.size() > 1) {
                return new IContextObjectSet(){

                    @Override
                    public int[] getObjectIds() {
                        return bucket.objectIds.toArray();
                    }

                    @Override
                    public String getOQL() {
                        return null;
                    }

                    @Override
                    public int getObjectId() {
                        return -1;
                    }
                };
            }
            return null;
        }
    }

    static class Sum
    implements Function {
        double sum;

        Sum() {
        }

        @Override
        public void add(Object object) {
            if (object != null) {
                this.sum += ((Number)object).doubleValue();
            }
        }

        @Override
        public Object getValue() {
            return this.sum;
        }
    }

    static class SumLong
    implements Function {
        long sum;

        SumLong() {
        }

        @Override
        public void add(Object object) {
            if (object != null) {
                this.sum += ((Number)object).longValue();
            }
        }

        @Override
        public Object getValue() {
            return this.sum;
        }
    }
}

