/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.report.internal;

import java.io.File;
import java.net.URL;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.report.IOutputter;
import org.eclipse.mat.report.QuerySpec;
import org.eclipse.mat.report.Spec;
import org.eclipse.mat.report.internal.AbstractPart;
import org.eclipse.mat.report.internal.DataFile;
import org.eclipse.mat.report.internal.LinkedPart;
import org.eclipse.mat.report.internal.QueryPart;
import org.eclipse.mat.report.internal.ResultRenderer;

class RenderingInfo
implements IOutputter.Context {
    private ResultRenderer resultRenderer;
    private QueryPart part;
    private boolean[] visibleColumns;
    private int limit;
    private boolean showTotals = true;

    public RenderingInfo(QueryPart part, ResultRenderer resultRenderer) {
        this.part = part;
        this.resultRenderer = resultRenderer;
        this.limit = 25;
    }

    public RenderingInfo(QueryPart part, ResultRenderer resultRenderer, int columnCount) {
        this(part, resultRenderer);
        this.visibleColumns = new boolean[columnCount];
        int ii = 0;
        while (ii < this.visibleColumns.length) {
            this.visibleColumns[ii] = true;
            ++ii;
        }
    }

    @Override
    public String getId() {
        return this.part.getId();
    }

    @Override
    public File getOutputDirectory() {
        return this.resultRenderer.getOutputDirectory(this.part);
    }

    @Override
    public IQueryContext getQueryContext() {
        return this.resultRenderer.getQueryContext();
    }

    @Override
    public String addIcon(URL icon) {
        return this.resultRenderer.addIcon(icon, this.part);
    }

    @Override
    public String getPathToRoot() {
        return this.resultRenderer.getPathToRoot(this.part);
    }

    @Override
    public String addContextResult(String name, IResult result) {
        AbstractPart child = null;
        child = result instanceof Spec ? this.part.factory.create(this.part, (Spec)result) : this.part.factory.create(this.part, new QuerySpec(name, result));
        child.params().put("$embedded", "true");
        DataFile dataFile = child.getDataFile();
        String filename = dataFile.getUrl();
        if (filename == null) {
            filename = dataFile.getSuggestedFile();
        }
        if (filename == null) {
            filename = "pages/" + child.getId() + ".html";
            dataFile.setSuggestedFile(filename);
        }
        if (!(child instanceof LinkedPart)) {
            this.part.children.add(child);
        }
        return String.valueOf(this.resultRenderer.getPathToRoot(this.part)) + filename;
    }

    @Override
    public boolean hasLimit() {
        return this.limit >= 0;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public boolean isColumnVisible(int columnIndex) {
        return this.visibleColumns[columnIndex];
    }

    @Override
    public boolean isTotalsRowVisible() {
        return this.showTotals;
    }

    @Override
    public String param(String key) {
        return this.part.params().get(key);
    }

    @Override
    public String param(String key, String defaultValue) {
        return this.part.params().get(key, defaultValue);
    }

    public void setShowTotals(boolean showTotals) {
        this.showTotals = showTotals;
    }

    public void setColumnVisible(int columnIndex, boolean isVisible) {
        this.visibleColumns[columnIndex] = isVisible;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }
}

