/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ElementExtension;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Stereotype;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.library.AbstractProperty;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class ExtensionProperty
extends AbstractProperty {
    protected final @NonNull Property property;

    public ExtensionProperty(@NonNull Property property) {
        this.property = property;
    }

    @Override
    public @Nullable Object evaluate(@NonNull Executor executor, @NonNull TypeId returnTypeId, @Nullable Object sourceValue) {
        Type staticType = this.property.getType();
        if (staticType == null) {
            return null;
        }
        Element element = null;
        if (sourceValue instanceof Element) {
            element = (Element)sourceValue;
        } else {
            try {
                element = ((EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)executor.getEnvironmentFactory()).getASOf(Element.class, (EObject)sourceValue);
            }
            catch (ParserException e) {
                return new InvalidValueException(e, "Failed to parse " + this.property);
            }
        }
        if (element != null) {
            ArrayList<ElementExtension> selectedExtensions = null;
            for (ElementExtension elementExtension : element.getOwnedExtensions()) {
                Stereotype dynamicStereotype = elementExtension.getStereotype();
                if (!dynamicStereotype.conformsTo(executor.getStandardLibrary(), staticType)) continue;
                if (selectedExtensions == null) {
                    selectedExtensions = new ArrayList<ElementExtension>();
                }
                selectedExtensions.add(elementExtension);
            }
            if (selectedExtensions == null) {
                return null;
            }
            TypeId typeId = this.property.getTypeId();
            if (typeId instanceof CollectionTypeId) {
                return ValueUtil.createSetValue((CollectionTypeId)typeId, (Collection<? extends Object>)selectedExtensions);
            }
            if (selectedExtensions.size() == 1) {
                return selectedExtensions.get(0);
            }
            return new InvalidValueException("Multiple applied stereotypes for " + this.property, new Object[0]);
        }
        return staticType;
    }
}

