/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.MinimalState;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.PDEPreferencesManager;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.core.target.TargetDefinition;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.core.util.ManifestUtils;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public class TargetPlatformHelper {
    public static final String REFERENCE_PREFIX = "reference:";
    public static final String PLATFORM_PREFIX = "platform:";
    public static final String FILE_URL_PREFIX = "file:";
    public static final String JAR_EXTENSION = ".jar";
    private static final Pattern PATTERN_BUNDLE_PATH_POSTFIX = Pattern.compile("(_\\d+(?<!x86_64|ia64_32)(\\.\\d+(\\.\\d+(\\.[a-zA-Z0-9_-]+)?)?)?(\\.\\w+)?$)|(\\.(?:jar|war|zip)$)", 2);
    private static Map<String, String> fgCachedLocations;
    private static HashMap<ITargetHandle, List<TargetDefinition>> fgCachedTargetDefinitionMap;

    static {
        fgCachedTargetDefinitionMap = new HashMap();
    }

    public static Properties getConfigIniProperties() {
        File iniFile = new File(TargetPlatform.getLocation(), "configuration/config.ini");
        if (!iniFile.exists()) {
            return null;
        }
        Properties pini = new Properties();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream fis = new FileInputStream(iniFile);){
                pini.load(fis);
                return pini;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            PDECore.logException(e);
            return null;
        }
    }

    public static String getBundleList() {
        Properties properties = TargetPlatformHelper.getConfigIniProperties();
        String osgiBundles = properties == null ? null : properties.getProperty("osgi.bundles");
        osgiBundles = osgiBundles == null ? TargetPlatformHelper.getDefaultBundleList() : TargetPlatformHelper.stripPathInformation(osgiBundles);
        return osgiBundles;
    }

    public static String getDefaultBundleList() {
        StringBuilder buffer = new StringBuilder();
        double targetVersion = TargetPlatformHelper.getTargetVersion();
        if (targetVersion >= 3.8) {
            buffer.append("org.apache.felix.scr@1:start,");
            buffer.append("org.eclipse.equinox.common@2:start,");
            buffer.append("org.eclipse.equinox.event@2:start,");
            buffer.append("org.eclipse.core.runtime@start");
        } else {
            buffer.append("org.eclipse.equinox.common@2:start,");
            buffer.append("org.eclipse.core.runtime@2:start,");
        }
        return buffer.toString();
    }

    public static String stripPathInformation(String osgiBundles) {
        StringBuilder result = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(osgiBundles, ",");
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            int atIndex = (token = token.replaceAll("\\\\:|/:", ":")).indexOf(64);
            String bundle = atIndex > 0 ? token.substring(0, atIndex) : token;
            if ((bundle = bundle.trim()).startsWith(REFERENCE_PREFIX) && bundle.length() > REFERENCE_PREFIX.length()) {
                bundle = bundle.substring(REFERENCE_PREFIX.length());
            }
            if (bundle.startsWith(PLATFORM_PREFIX) && bundle.length() > PLATFORM_PREFIX.length()) {
                bundle = bundle.substring(PLATFORM_PREFIX.length());
            }
            if (bundle.startsWith(FILE_URL_PREFIX) && bundle.length() > FILE_URL_PREFIX.length()) {
                bundle = bundle.substring(FILE_URL_PREFIX.length());
            }
            Path path = new Path(bundle);
            String id = null;
            if (path.isAbsolute()) {
                id = TargetPlatformHelper.getSymbolicName(bundle);
            }
            if (id == null) {
                id = path.lastSegment();
            }
            if (id != null) {
                id = PATTERN_BUNDLE_PATH_POSTFIX.matcher(id).replaceFirst("");
            }
            if (result.length() > 0) {
                result.append(",");
            }
            result.append(id != null ? id : bundle);
            if (atIndex <= -1) continue;
            result.append(token.substring(atIndex).trim());
        }
        return result.toString();
    }

    private static synchronized String getSymbolicName(String path) {
        if (fgCachedLocations == null) {
            fgCachedLocations = new HashMap<String, String>();
        }
        if (fgCachedLocations.containsKey(path)) {
            return fgCachedLocations.get(path);
        }
        File file = new File(path);
        if (file.exists()) {
            try {
                Map<String, String> manifest = ManifestUtils.loadManifest(file);
                String name = manifest.get("Bundle-SymbolicName");
                if (name != null) {
                    fgCachedLocations.put(path, name);
                    return name;
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public static void checkPluginPropertiesConsistency(Map<?, ?> map, File configDir) {
        File runtimeDir = new File(configDir, "org.eclipse.core.runtime");
        if (runtimeDir.exists() && runtimeDir.isDirectory()) {
            long timestamp = runtimeDir.lastModified();
            Iterator<?> iter = map.values().iterator();
            while (iter.hasNext()) {
                if (!TargetPlatformHelper.hasChanged((IPluginModelBase)iter.next(), timestamp)) continue;
                CoreUtility.deleteContent(runtimeDir);
                break;
            }
        }
    }

    private static boolean hasChanged(IPluginModelBase model, long timestamp) {
        File[] files;
        if (model.getUnderlyingResource() != null && (files = new File(model.getInstallLocation()).listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String name;
                File file = fileArray[n2];
                if (!file.isDirectory() && (name = file.getName()).startsWith("OSGI-INF/l10n/bundle") && name.endsWith(".properties") && file.lastModified() > timestamp) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static ITargetDefinition getUnresolvedRepositoryBasedWorkspaceTarget() throws CoreException {
        ITargetLocation[] locations;
        ITargetPlatformService service = PDECore.getDefault().acquireService(ITargetPlatformService.class);
        if (service == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", PDECoreMessages.TargetPlatformHelper_CouldNotAcquireTargetService));
        }
        ITargetDefinition target = service.getWorkspaceTargetDefinition();
        if (target != null && !target.isResolved() && (locations = target.getTargetLocations()) != null) {
            ITargetLocation[] iTargetLocationArray = locations;
            int n = locations.length;
            int n2 = 0;
            while (n2 < n) {
                IUBundleContainer bc;
                URI[] uri;
                ITargetLocation location = iTargetLocationArray[n2];
                if (location instanceof IUBundleContainer && (uri = (bc = (IUBundleContainer)location).getRepositories()) != null && uri.length > 0) {
                    return target;
                }
                ++n2;
            }
        }
        return null;
    }

    public static Set<String> getApplicationNameSet() {
        IExtension[] extensions;
        TreeSet<String> result = new TreeSet<String>();
        IExtension[] iExtensionArray = extensions = PDECore.getDefault().getExtensionsRegistry().findExtensions("org.eclipse.core.runtime.applications", true);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            String id = extension.getUniqueIdentifier();
            IConfigurationElement[] elements = extension.getConfigurationElements();
            if (elements.length == 1) {
                boolean visible;
                String visiblity = elements[0].getAttribute("visible");
                boolean bl = visible = visiblity == null ? true : Boolean.parseBoolean(visiblity);
                if (id != null && visible) {
                    result.add(id);
                }
            }
            ++n2;
        }
        result.add("org.eclipse.ui.ide.workbench");
        return result;
    }

    public static String[] getApplicationNames() {
        Set<String> result = TargetPlatformHelper.getApplicationNameSet();
        return result.toArray(new String[result.size()]);
    }

    public static TreeSet<String> getProductNameSet() {
        IExtension[] extensions;
        TreeSet<String> result = new TreeSet<String>();
        IExtension[] iExtensionArray = extensions = PDECore.getDefault().getExtensionsRegistry().findExtensions("org.eclipse.core.runtime.products", true);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String id;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            if (elements.length == 1 && "product".equals(elements[0].getName()) && (id = extension.getUniqueIdentifier()) != null && id.trim().length() > 0) {
                result.add(id);
            }
            ++n2;
        }
        return result;
    }

    public static String[] getProductNames() {
        TreeSet<String> result = TargetPlatformHelper.getProductNameSet();
        return result.toArray(new String[result.size()]);
    }

    public static Dictionary<String, String> getTargetEnvironment() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        ((Dictionary)result).put("osgi.os", TargetPlatform.getOS());
        ((Dictionary)result).put("osgi.ws", TargetPlatform.getWS());
        ((Dictionary)result).put("osgi.nl", TargetPlatform.getNL());
        ((Dictionary)result).put("osgi.arch", TargetPlatform.getOSArch());
        ((Dictionary)result).put("osgi.resolveOptional", "true");
        ((Dictionary)result).put("osgi.resolverMode", "development");
        return result;
    }

    public static Dictionary<String, String> getTargetEnvironment(MinimalState state) {
        Dictionary<String, String> result = TargetPlatformHelper.getTargetEnvironment();
        result.put("osgi.system.bundle", state.getSystemBundle());
        return result;
    }

    public static Dictionary<String, String>[] getPlatformProperties(String[] profiles, MinimalState state) {
        if (profiles == null || profiles.length == 0) {
            return new Dictionary[]{TargetPlatformHelper.getTargetEnvironment(state)};
        }
        ArrayList<Dictionary<String, String>> result = new ArrayList<Dictionary<String, String>>(profiles.length);
        String[] stringArray = profiles;
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            Properties profileProps;
            String profile = stringArray[n2];
            IExecutionEnvironment environment = JavaRuntime.getExecutionEnvironmentsManager().getEnvironment(profile);
            if (environment != null && (profileProps = environment.getProfileProperties()) != null) {
                String ee;
                Dictionary<String, String> props = TargetPlatformHelper.getTargetEnvironment(state);
                String systemPackages = profileProps.getProperty("org.osgi.framework.system.packages");
                if (systemPackages != null) {
                    props.put("org.osgi.framework.system.packages", systemPackages);
                }
                if ((ee = profileProps.getProperty("org.osgi.framework.executionenvironment")) != null) {
                    props.put("org.osgi.framework.executionenvironment", ee);
                }
                result.add(props);
            }
            ++n2;
        }
        if (!result.isEmpty()) {
            return result.toArray(new Dictionary[result.size()]);
        }
        return new Dictionary[]{TargetPlatformHelper.getTargetEnvironment(state)};
    }

    public static String[] getKnownExecutionEnvironments() {
        String jreProfile = System.getProperty("pde.jreProfile");
        if (jreProfile != null && jreProfile.length() > 0) {
            if ("none".equals(jreProfile)) {
                return new String[0];
            }
            return new String[]{jreProfile};
        }
        IExecutionEnvironment[] environments = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
        String[] ids = new String[environments.length];
        int i = 0;
        while (i < environments.length) {
            ids[i] = environments[i].getId();
            ++i;
        }
        return ids;
    }

    public static String getTargetVersionString() {
        IPluginModelBase model = PluginRegistry.findModel("org.eclipse.osgi");
        if (model == null) {
            return "3.8";
        }
        String version = model.getPluginBase().getVersion();
        if (VersionUtil.validateVersion(version).getSeverity() == 0) {
            Version vid = new Version(version);
            int major = vid.getMajor();
            int minor = vid.getMinor();
            if (major == 3 && minor == 0) {
                return "3.0";
            }
            if (major == 3 && minor == 1) {
                return "3.1";
            }
            if (major == 3 && minor == 2) {
                return "3.2";
            }
            if (major == 3 && minor == 3) {
                return "3.3";
            }
            if (major == 3 && minor == 4) {
                return "3.4";
            }
            if (major == 3 && minor == 5) {
                return "3.5";
            }
            if (major == 3 && minor == 6) {
                return "3.6";
            }
            if (major == 3 && minor == 7) {
                return "3.7";
            }
            if (major == 3 && minor == 8) {
                return "3.8";
            }
        }
        return "3.8";
    }

    public static double getTargetVersion() {
        return Double.parseDouble(TargetPlatformHelper.getTargetVersionString());
    }

    public static String getSchemaVersionForTargetVersion(String targetVersion) {
        double target = targetVersion == null ? TargetPlatformHelper.getTargetVersion() : Double.parseDouble(targetVersion);
        String schemaVersion = "3.4";
        if (target < 3.2) {
            schemaVersion = "3.0";
        } else if (target < 3.4) {
            schemaVersion = "3.2";
        }
        return schemaVersion;
    }

    public static String getTargetVersionForSchemaVersion(String schemaVersion) {
        if (schemaVersion == null) {
            return TargetPlatformHelper.getTargetVersionString();
        }
        if (schemaVersion.equals("3.0")) {
            return "3.1";
        }
        if (schemaVersion.equals("3.2")) {
            return "3.3";
        }
        return TargetPlatformHelper.getTargetVersionString();
    }

    public static String getSchemaVersion() {
        return TargetPlatformHelper.getSchemaVersionForTargetVersion(null);
    }

    public static PDEState getPDEState() {
        return PDECore.getDefault().getModelManager().getState();
    }

    public static State getState() {
        return TargetPlatformHelper.getPDEState().getState();
    }

    public static ITargetDefinition getWorkspaceTargetResolved(IProgressMonitor monitor) throws CoreException {
        ITargetPlatformService service = PDECore.getDefault().acquireService(ITargetPlatformService.class);
        if (service == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", PDECoreMessages.TargetPlatformHelper_CouldNotAcquireTargetService));
        }
        ITargetDefinition target = service.getWorkspaceTargetDefinition();
        if (!target.isResolved()) {
            target.resolve(monitor);
            if (monitor != null && monitor.isCanceled()) {
                return null;
            }
            PDEPreferencesManager preferences = PDECore.getDefault().getPreferencesManager();
            String memento = target.getHandle().getMemento();
            if (memento != null && memento.equals(preferences.getString("workspace_target_handle"))) {
                preferences.setValue("workspace_target_handle", "");
                preferences.setValue("workspace_target_handle", memento);
            }
        }
        return target;
    }

    public static Map<Long, String> getPatchMap(PDEState state) {
        IPluginModelBase[] models;
        LinkedHashMap<Long, String> properties = new LinkedHashMap<Long, String>();
        IPluginModelBase[] iPluginModelBaseArray = models = PluginRegistry.getActiveModels();
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            BundleDescription desc = model.getBundleDescription();
            if (desc != null) {
                Long id = desc.getBundleId();
                if (ClasspathUtilCore.hasExtensibleAPI(model)) {
                    properties.put(id, "Eclipse-ExtensibleAPI: true");
                } else if (ClasspathUtilCore.isPatchFragment(model)) {
                    properties.put(id, "Eclipse-PatchFragment: true");
                }
            }
            ++n2;
        }
        return properties;
    }

    public static HashMap<Long, String[]> getBundleClasspaths(PDEState state) {
        BundleDescription[] bundles;
        LinkedHashMap<Long, String[]> properties = new LinkedHashMap<Long, String[]>();
        BundleDescription[] bundleDescriptionArray = bundles = state.getState().getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription bundle = bundleDescriptionArray[n2];
            properties.put(bundle.getBundleId(), TargetPlatformHelper.getValue(bundle, state));
            ++n2;
        }
        return properties;
    }

    private static String[] getValue(BundleDescription bundle, PDEState state) {
        IPluginModelBase model = PluginRegistry.findModel(bundle);
        String[] result = null;
        if (model != null) {
            IPluginLibrary[] libs = model.getPluginBase().getLibraries();
            result = new String[libs.length];
            int i = 0;
            while (i < libs.length) {
                result[i] = libs[i].getName();
                ++i;
            }
        } else {
            String[] libs = state.getLibraryNames(bundle.getBundleId());
            result = new String[libs.length];
            int i = 0;
            while (i < libs.length) {
                result[i] = libs[i];
                ++i;
            }
        }
        if (result.length == 0) {
            return new String[]{"."};
        }
        return result;
    }

    public static String[] getFeaturePaths() {
        IFeatureModel[] models = PDECore.getDefault().getFeatureModelManager().getModels();
        ArrayList<String> list = new ArrayList<String>();
        IFeatureModel[] iFeatureModelArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureModel model = iFeatureModelArray[n2];
            String location = model.getInstallLocation();
            if (location != null) {
                list.add(String.valueOf(location) + '/' + "feature.xml");
            }
            ++n2;
        }
        return list.toArray(new String[list.size()]);
    }

    public static boolean matchesCurrentEnvironment(IPluginModelBase model) {
        BundleContext context = PDECore.getDefault().getBundleContext();
        Dictionary<String, String> environment = TargetPlatformHelper.getTargetEnvironment();
        BundleDescription bundle = model.getBundleDescription();
        String filterSpec = bundle != null ? bundle.getPlatformFilter() : null;
        try {
            return filterSpec == null || context.createFilter(filterSpec).match(environment);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return false;
        }
    }

    public static boolean usesNewApplicationModel() {
        return PluginRegistry.findModel("org.eclipse.equinox.app") != null;
    }

    public static String getIniVMArgs() {
        File installDirectory = new File(Platform.getInstallLocation().getURL().getFile());
        File eclipseIniFile = new File(installDirectory, "eclipse.ini");
        StringBuilder result = new StringBuilder();
        if (eclipseIniFile.exists()) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (BufferedReader in = new BufferedReader(new FileReader(eclipseIniFile));){
                    String str;
                    boolean vmargs = false;
                    while ((str = in.readLine()) != null) {
                        if (vmargs) {
                            if (result.length() > 0) {
                                result.append(" ");
                            }
                            result.append(str);
                        }
                        if (vmargs || !str.equals("-vmargs")) continue;
                        vmargs = true;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                PDECore.log(e);
            }
        }
        return result.toString();
    }

    public static HashMap<ITargetHandle, List<TargetDefinition>> getTargetDefinitionMap() {
        return fgCachedTargetDefinitionMap;
    }

    public static void addTargetDefinitionMap(TargetDefinition targetDefinition) {
        if (fgCachedTargetDefinitionMap.containsKey(targetDefinition.getHandle())) {
            List<TargetDefinition> targets = fgCachedTargetDefinitionMap.get(targetDefinition.getHandle());
            if (!targets.contains(targetDefinition)) {
                targets.add(0, targetDefinition);
            }
        } else {
            ArrayList<TargetDefinition> target = new ArrayList<TargetDefinition>();
            target.add(targetDefinition);
            fgCachedTargetDefinitionMap.put(targetDefinition.getHandle(), target);
        }
    }
}

