/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.controls;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.ui.actions.ToggleBreakpointAction;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewerExtension6;
import org.eclipse.jface.text.IUndoManagerExtension;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.rcptt.core.Scenarios;
import org.eclipse.rcptt.core.scenario.Scenario;
import org.eclipse.rcptt.core.scenario.ScenarioPackage;
import org.eclipse.rcptt.internal.core.model.Q7InternalTestCase;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.controls.AbstractEmbeddedComposite;
import org.eclipse.rcptt.ui.debug.ToggleBreakpointEnablementAction;
import org.eclipse.rcptt.ui.editors.TextViewerActionsSupport;
import org.eclipse.rcptt.ui.editors.ecl.EclSourceViewer;
import org.eclipse.rcptt.ui.editors.ecl.EclSourceViewerConfiguration;
import org.eclipse.rcptt.ui.panels.Actions;
import org.eclipse.rcptt.ui.recording.RecordingSupport;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public class ScriptComposite
extends AbstractEmbeddedComposite {
    private static final String SCENARIO_ERROR = "Test case contains errors. Please see error log for details.";
    private final Scenario scenario;
    private final IFile file;
    private final IWorkbenchPartSite site;
    private final Shell shell;
    private final int style;
    private final AtomicBoolean scrollLock = new AtomicBoolean(false);
    private Composite control;
    private EclSourceViewer viewer;
    private boolean ignoreChanges;
    private int lastDocumentOperation;
    private final IObservableValue editable = new ComputedValue(){

        protected Object calculate() {
            return (Boolean)ScriptComposite.this.stopped.getValue();
        }
    };
    private final IObservableValue stopped = new ComputedValue(){

        protected Object calculate() {
            return ScriptComposite.this.getRecordingMode().equals((Object)RecordingSupport.RecordingMode.Stopped);
        }
    };

    public ScriptComposite(Q7InternalTestCase model, IFile file, Shell shell, int style) {
        this.scenario = model.getNamedElement();
        this.file = file;
        this.site = null;
        this.shell = shell;
        this.style = style;
    }

    @Override
    public String getName() {
        return Messages.ScriptComposite_Name;
    }

    @Override
    public Image getImage() {
        return Images.getImage("icons/panel/scenario.gif");
    }

    private RecordingSupport.RecordingMode getRecordingMode() {
        return (RecordingSupport.RecordingMode)((Object)this.recordingMode.getValue());
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        CompositeRuler ruler = new CompositeRuler();
        DefaultMarkerAnnotationAccess access = new DefaultMarkerAnnotationAccess();
        AnnotationRulerColumn annotations = new AnnotationRulerColumn(12, (IAnnotationAccess)access);
        ruler.addDecorator(0, (IVerticalRulerColumn)annotations);
        LineNumberRulerColumn column = new LineNumberRulerColumn(){

            public int getWidth() {
                return super.getWidth() + 10;
            }
        };
        Font font = JFaceResources.getTextFont();
        column.setFont(font);
        column.setForeground(parent.getDisplay().getSystemColor(16));
        ruler.addDecorator(1, (IVerticalRulerColumn)column);
        OverviewRuler overview = new OverviewRuler((IAnnotationAccess)access, 12, EditorsUI.getSharedTextColors());
        MarkerAnnotationPreferences preferences = EditorsPlugin.getDefault().getMarkerAnnotationPreferences();
        ResourceMarkerAnnotationModel model = this.file != null ? new ResourceMarkerAnnotationModel((IResource)this.file) : new AnnotationModel();
        for (AnnotationPreference preference : preferences.getAnnotationPreferences()) {
            if (!preference.contributesToHeader()) continue;
            overview.addHeaderAnnotationType(preference.getAnnotationType());
        }
        annotations.addAnnotationType((Object)"org.eclipse.rcptt.core.builder.q7Problem");
        this.viewer = new EclSourceViewer(parent, (IVerticalRuler)ruler, (IOverviewRuler)overview, true, 2818);
        Document document = new Document(Scenarios.getScriptContent((Scenario)this.scenario));
        this.viewer.setDocument((IDocument)document, (IAnnotationModel)model);
        this.viewer.configure((SourceViewerConfiguration)new EclSourceViewerConfiguration());
        SourceViewerDecorationSupport support = new SourceViewerDecorationSupport((ISourceViewer)this.viewer, (IOverviewRuler)overview, (IAnnotationAccess)access, EditorsUI.getSharedTextColors());
        Iterator it = preferences.getAnnotationPreferences().iterator();
        while (it.hasNext()) {
            support.setAnnotationPreference((AnnotationPreference)it.next());
        }
        support.install(EditorsUI.getPreferenceStore());
        Control rulerControl = ruler.getControl();
        rulerControl.addMouseListener(new MouseListener((IDocument)document, ruler){
            private final /* synthetic */ IDocument val$document;
            private final /* synthetic */ CompositeRuler val$ruler;
            {
                this.val$document = iDocument;
                this.val$ruler = compositeRuler;
            }

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                if (1 == e.button) {
                    ToggleBreakpointAction action = new ToggleBreakpointAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart(), this.val$document, (IVerticalRulerInfo)this.val$ruler);
                    action.update();
                    action.run();
                }
            }

            public void mouseDown(MouseEvent e) {
            }
        });
        String id = "#RulerContext";
        MenuManager manager = new MenuManager(id, id);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener((IDocument)document, ruler){
            private final /* synthetic */ IDocument val$document;
            private final /* synthetic */ CompositeRuler val$ruler;
            {
                this.val$document = iDocument;
                this.val$ruler = compositeRuler;
            }

            public void menuAboutToShow(IMenuManager menu) {
                if (ScriptComposite.this.viewer != null && ScriptComposite.this.viewer.getTextWidget() != null) {
                    ScriptComposite.this.viewer.getTextWidget().setFocus();
                }
                ToggleBreakpointAction action1 = new ToggleBreakpointAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart(), this.val$document, (IVerticalRulerInfo)this.val$ruler);
                action1.update();
                menu.add((IAction)action1);
                ToggleBreakpointEnablementAction action2 = new ToggleBreakpointEnablementAction((SourceViewer)ScriptComposite.this.viewer, (IVerticalRulerInfo)this.val$ruler);
                action2.update();
                if (action2.isEnabled()) {
                    menu.add((IAction)action2);
                }
            }
        });
        Menu fRulerContextMenu = manager.createContextMenu(rulerControl);
        rulerControl.setMenu(fRulerContextMenu);
        this.viewer.setEditable((Boolean)this.editable.getValue());
        this.editable.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                ScriptComposite.this.viewer.setEditable((Boolean)ScriptComposite.this.editable.getValue());
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.viewer.getControl());
        ScriptComposite.getOperationHistory().addOperationHistoryListener(new IOperationHistoryListener(){

            public void historyNotification(OperationHistoryEvent event) {
                ScriptComposite.this.lastDocumentOperation = event.getEventType();
            }
        });
        this.viewer.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                if (ScriptComposite.this.ignoreChanges) {
                    return;
                }
                if (!ScriptComposite.this.getRecordingMode().equals((Object)RecordingSupport.RecordingMode.Recording)) {
                    String value = ScriptComposite.this.viewer.getDocument().get();
                    if ((value == null || value.length() == 0) && ScriptComposite.this.lastDocumentOperation != 3) {
                        ScriptComposite.this.clear();
                    } else {
                        Scenarios.setEclContent((Scenario)ScriptComposite.this.scenario, (String)value);
                    }
                }
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
        IChangeListener scenarioContentListener = new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                String doc;
                String script;
                if (ScriptComposite.this.ignoreChanges) {
                    return;
                }
                try {
                    script = Scenarios.getScriptContent((Scenario)ScriptComposite.this.scenario);
                }
                catch (Exception e) {
                    script = ScriptComposite.SCENARIO_ERROR;
                    Q7UIPlugin.log(e);
                }
                if (ScriptComposite.this.viewer.getDocument() != null && !(doc = ScriptComposite.this.viewer.getDocument().get()).equals(script)) {
                    ScriptComposite.this.viewer.getDocument().set(script);
                    if (!(ScriptComposite.this.getRecordingMode().equals((Object)RecordingSupport.RecordingMode.Stopped) || ScriptComposite.this.getRecordingMode().equals((Object)RecordingSupport.RecordingMode.Replaying) || ScriptComposite.this.scrollLock.get())) {
                        try {
                            IDocument document = ScriptComposite.this.viewer.getDocument();
                            int length = document.getLength();
                            if (document.getLength() > 0) {
                                int lineOfOffset = document.getLineOfOffset(length);
                                int lineOffset = document.getLineOffset(lineOfOffset);
                                ScriptComposite.this.viewer.revealRange(lineOffset, 0);
                            }
                        }
                        catch (BadLocationException e) {
                            Q7UIPlugin.log(e);
                        }
                    }
                }
            }
        };
        IObservableValue scriptContent = EMFObservables.observeValue((EObject)this.scenario, (EStructuralFeature)ScenarioPackage.Literals.SCENARIO__CONTENT);
        scriptContent.addChangeListener(scenarioContentListener);
        IObservableValue teslaContent = EMFObservables.observeValue((EObject)this.scenario, (EStructuralFeature)ScenarioPackage.Literals.SCENARIO__TESLA_CONTENT);
        teslaContent.addChangeListener(scenarioContentListener);
        if (this.site != null) {
            new TextViewerActionsSupport((TextViewer)this.viewer, this.site, this.editable);
        } else if (this.shell != null) {
            new TextViewerActionsSupport((TextViewer)this.viewer, this.shell, this.editable);
        }
        this.control = this.viewer.getControl();
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    public EclSourceViewer getViewer() {
        return this.viewer;
    }

    @Override
    public void fillActions(IToolBarManager manager) {
        Action clearAction = new Action(){

            public void run() {
                ScriptComposite.this.clear();
            }
        };
        clearAction.setImageDescriptor(Images.getImageDescriptor("icons/panel/clear.gif"));
        clearAction.setToolTipText(Messages.ScriptComposite_ClearActionToolTip);
        this.dbc.bindValue(Actions.observeEnabled((IAction)clearAction), (IObservableValue)new ComputedValue(){

            protected Object calculate() {
                return ScriptComposite.this.getRecordingMode().equals((Object)RecordingSupport.RecordingMode.Stopped);
            }
        });
        manager.add((IAction)clearAction);
        if ((this.style & 0x1000054) != 0) {
            Action scrollLockAction = new Action("", 2){

                public void run() {
                    ScriptComposite.this.scrollLock.set(this.isChecked());
                }
            };
            scrollLockAction.setImageDescriptor(Images.getImageDescriptor("icons/panel/scroll_lock.gif"));
            scrollLockAction.setToolTipText(Messages.ScriptComposite_ScrollLockActionToolTip);
            ComputedValue scrollLockEnabled = new ComputedValue(){

                protected Object calculate() {
                    return !ScriptComposite.this.getRecordingMode().equals((Object)RecordingSupport.RecordingMode.Stopped) && !ScriptComposite.this.getRecordingMode().equals((Object)RecordingSupport.RecordingMode.Replaying);
                }
            };
            this.dbc.bindValue(Actions.observeEnabled((IAction)scrollLockAction), (IObservableValue)scrollLockEnabled);
            manager.add((IAction)scrollLockAction);
        }
    }

    public void clear() {
        IUndoContext undoContext;
        IUndoContext iUndoContext = undoContext = this.viewer instanceof ITextViewerExtension6 && this.viewer.getUndoManager() instanceof IUndoManagerExtension ? ((IUndoManagerExtension)this.viewer.getUndoManager()).getUndoContext() : null;
        if (undoContext != null) {
            ClearScenarioOperation clearScenario = new ClearScenarioOperation(Messages.ScriptComposite_ClearActionOp, undoContext);
            try {
                ScriptComposite.getOperationHistory().execute((IUndoableOperation)clearScenario, null, null);
            }
            catch (ExecutionException e) {
                Q7UIPlugin.log(e);
            }
        } else {
            this.scenario.setContent(null);
            this.scenario.setTeslaContent(null);
        }
    }

    private static IOperationHistory getOperationHistory() {
        return PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
    }

    private class ClearScenarioOperation
    extends AbstractOperation {
        private EObject fPreservedTeslaContent;
        private EObject fPreservedECLContent;
        private final IUndoContext fUndoContext;

        public ClearScenarioOperation(String label, IUndoContext undoContext) {
            super(label);
            this.fUndoContext = undoContext;
            this.addContext(this.fUndoContext);
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            ScriptComposite.this.ignoreChanges = true;
            this.fPreservedECLContent = ScriptComposite.this.scenario.getContent();
            this.fPreservedTeslaContent = ScriptComposite.this.scenario.getTeslaContent();
            ScriptComposite.this.scenario.setContent(null);
            ScriptComposite.this.scenario.setTeslaContent(null);
            ScriptComposite.this.viewer.getTextWidget().setText("");
            ScriptComposite.getOperationHistory().replaceOperation(ScriptComposite.getOperationHistory().getUndoOperation(this.fUndoContext), new IUndoableOperation[0]);
            ScriptComposite.this.ignoreChanges = false;
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.execute(monitor, info);
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            String script;
            ScriptComposite.this.ignoreChanges = true;
            ScriptComposite.this.scenario.setTeslaContent(this.fPreservedTeslaContent);
            this.fPreservedTeslaContent = null;
            ScriptComposite.this.scenario.setContent(this.fPreservedECLContent);
            this.fPreservedECLContent = null;
            try {
                script = Scenarios.getScriptContent((Scenario)ScriptComposite.this.scenario);
            }
            catch (Exception e) {
                script = ScriptComposite.SCENARIO_ERROR;
                Q7UIPlugin.log(e);
            }
            ScriptComposite.this.viewer.getTextWidget().setText(script);
            ScriptComposite.getOperationHistory().replaceOperation(ScriptComposite.getOperationHistory().getUndoOperation(this.fUndoContext), new IUndoableOperation[0]);
            ScriptComposite.this.ignoreChanges = false;
            return Status.OK_STATUS;
        }
    }
}

