/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.portfolio.eclipse.build.buildcore;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PropertyType implements Enumerator
{
    RUNTIME(0, "RUNTIME", "RUNTIME"),
    INLINED(1, "INLINED", "INLINED");

    public static final String copyright = "   Copyright (c) 2009-2010 Thales Corporate Services S.A.S.\r\n   This program and the accompanying materials\r\n   are made available under the terms of the Eclipse Public License v2.0\r\n   which accompanies this distribution, and is available at\r\n   https://www.eclipse.org/legal/epl-v2.0\r\n  \r\n  SPDX-License-Identifier: EPL-2.0\r\n  \r\n   Contributors:\r\n       Thales Corporate Services S.A.S - initial API and implementation";
    public static final int RUNTIME_VALUE = 0;
    public static final int INLINED_VALUE = 1;
    private static final PropertyType[] VALUES_ARRAY;
    public static final List<PropertyType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PropertyType[]{RUNTIME, INLINED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PropertyType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PropertyType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PropertyType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PropertyType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PropertyType get(int value) {
        switch (value) {
            case 0: {
                return RUNTIME;
            }
            case 1: {
                return INLINED;
            }
        }
        return null;
    }

    private PropertyType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

