/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.core;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.tcf.core.AbstractPeer;
import org.eclipse.tcf.core.ChannelTCP;
import org.eclipse.tcf.core.TransientPeer;
import org.eclipse.tcf.internal.core.ServiceManager;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;

public class ServerTCP
extends ServerSocket {
    private final String name;
    private List<ServerPeer> peers;
    private Thread thread;

    public ServerTCP(String name, int port) throws IOException {
        super(port);
        this.name = name;
        this.peers = new ArrayList<ServerPeer>();
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        while (e.hasMoreElements()) {
            NetworkInterface f = e.nextElement();
            Enumeration<InetAddress> n = f.getInetAddresses();
            while (n.hasMoreElements()) {
                this.getServerPeer(n.nextElement());
            }
        }
        this.thread = new Thread(){

            @Override
            public void run() {
                try {
                    while (true) {
                        final Socket socket = ServerTCP.this.accept();
                        Protocol.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    new ChannelTCP(ServerTCP.this.getServerPeer(socket.getLocalAddress()), ServerTCP.this.getTransientPeer(socket.getInetAddress()), socket);
                                }
                                catch (Throwable x) {
                                    Protocol.log("TCF Server: failed to create a channel", x);
                                }
                            }
                        });
                    }
                }
                catch (Throwable x) {
                    Protocol.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Protocol.log("TCF Server thread aborted", x);
                        }
                    });
                    return;
                }
            }
        };
        this.thread.setName(name);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private IPeer getServerPeer(InetAddress addr) {
        if (addr.isAnyLocalAddress()) {
            return this.getTransientPeer(addr);
        }
        if (addr.isMulticastAddress()) {
            return this.getTransientPeer(addr);
        }
        if (addr.isLinkLocalAddress()) {
            return this.getTransientPeer(addr);
        }
        String host = addr.getHostAddress();
        for (ServerPeer p : this.peers) {
            if (!host.equals(p.getAttributes().get("Host"))) continue;
            return p;
        }
        String port = Integer.toString(this.getLocalPort());
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("ID", "TCP:" + host + ":" + port);
        attrs.put("ServiceManagerID", ServiceManager.getID());
        attrs.put("AgentID", Protocol.getAgentID());
        attrs.put("Name", this.name);
        attrs.put("OSName", System.getProperty("os.name"));
        attrs.put("TransportName", "TCP");
        attrs.put("Host", host);
        attrs.put("Port", port);
        attrs.put("Proxy", "");
        ServerPeer p = new ServerPeer(attrs);
        this.peers.add(p);
        return p;
    }

    private IPeer getTransientPeer(InetAddress addr) {
        String host = addr.getHostAddress();
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("ID", "TCP:Transient:" + host + ":" + this.getLocalPort());
        attrs.put("TransportName", "TCP");
        attrs.put("Host", host);
        return new TransientPeer(attrs);
    }

    @Override
    public void close() throws IOException {
        if (this.peers != null) {
            for (ServerPeer s : this.peers) {
                s.dispose();
            }
            this.peers = null;
        }
        super.close();
        if (this.thread != null) {
            try {
                this.thread.join();
                this.thread = null;
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
        }
    }

    private static class ServerPeer
    extends AbstractPeer {
        ServerPeer(Map<String, String> attrs) {
            super(attrs);
        }
    }
}

