/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text.atl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.m2m.atl.adt.ui.AtlUIPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;

public final class AtlEditorUI {
    private static final String CUSTOM_TEMPLATES_KEY = "org.eclipse.m2m.atl.editor.customtemplates";
    private static AtlEditorUI fInstance;
    private TemplateStore fStore;
    private ContributionContextTypeRegistry fRegistry;
    private Map<String, String> templateImagePaths = new HashMap<String, String>();

    private AtlEditorUI() {
        this.templateImagePaths.put("Module", "$nl$/icons/module.gif");
        this.templateImagePaths.put("Library", "$nl$/icons/libs.gif");
        this.templateImagePaths.put("Query", "$nl$/icons/query.gif");
        this.templateImagePaths.put("Rule", "$nl$/icons/matchedRule.gif");
        this.templateImagePaths.put("Called Rule", "$nl$/icons/matchedRule.gif");
        this.templateImagePaths.put("Helper", "$nl$/icons/helper.gif");
        this.templateImagePaths.put("Attribute", "$nl$/icons/helper.gif");
        this.templateImagePaths.put("Using", "$nl$/icons/using.gif");
        this.templateImagePaths.put("Do", "$nl$/icons/imperative.gif");
    }

    public static AtlEditorUI getDefault() {
        if (fInstance == null) {
            fInstance = new AtlEditorUI();
        }
        return fInstance;
    }

    public TemplateStore getTemplateStore() {
        if (this.fStore == null) {
            this.fStore = new ContributionTemplateStore(this.getContextTypeRegistry(), AtlUIPlugin.getDefault().getPreferenceStore(), CUSTOM_TEMPLATES_KEY);
            try {
                this.fStore.load();
            }
            catch (IOException e) {
                AtlUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.m2m.atl.adt.editor", 0, "", (Throwable)e));
            }
        }
        return this.fStore;
    }

    public ContextTypeRegistry getContextTypeRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = new ContributionContextTypeRegistry();
            this.fRegistry.addContextType("atl_context");
            this.fRegistry.addContextType("module_context");
            this.fRegistry.addContextType("query_context");
            this.fRegistry.addContextType("library_context");
            this.fRegistry.addContextType("rule_context");
            this.fRegistry.addContextType("helper_context");
        }
        return this.fRegistry;
    }

    public Image getTemplateImage(String name) {
        String path = this.templateImagePaths.get(name);
        if (path == null) {
            path = "$nl$/icons/templateprop_co.gif";
        }
        return AtlUIPlugin.getDefault().getImage(path);
    }

    public void registerImage(String name, String path) {
        this.templateImagePaths.put(name, path);
    }
}

