/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui;

import org.eclipse.core.expressions.IPropertyTester;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.internal.Category;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;
import org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepository;
import org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepositoryConstants;
import org.eclipse.datatools.connectivity.ui.ICategoryActionFilter;

public class CategoryActionFilter
extends PropertyTester
implements ICategoryActionFilter,
IPropertyTester {
    private static boolean mDebug = ConnectivityPlugin.getDefault().isDebugging();

    public boolean testAttribute(Object target, String name, String value) {
        if (target == null || !(target instanceof ICategory)) {
            return false;
        }
        ICategory category = (ICategory)target;
        CategoryActionFilter.debug("category testAttribute: name =" + name + ", value = " + value);
        if (name.equals("org.eclipse.datatools.connectivity.category.property.categoryID") || name.equals("categoryID")) {
            return category.getId().equals(value);
        }
        if (name.equals("org.eclipse.datatools.connectivity.category.property.repositoryIsReadOnly") || name.equals("repositoryIsReadOnly")) {
            IManagedConnection imc;
            IConnectionProfile profile;
            if (category instanceof Category && (profile = ((Category)category).getRepositoryProfile()) != null && (imc = profile.getManagedConnection(IConnectionProfileRepositoryConstants.REPOSITORY_CONNECTION_FACTORY_ID)) != null && imc.isConnected()) {
                IConnectionProfileRepository repo = (IConnectionProfileRepository)imc.getConnection().getRawConnection();
                CategoryActionFilter.debug("org.eclipse.datatools.connectivity.category.property.repositoryIsReadOnly, value = " + repo.isReadOnly());
                return repo.isReadOnly();
            }
            CategoryActionFilter.debug("org.eclipse.datatools.connectivity.category.property.repositoryIsReadOnly, value = false");
            return false;
        }
        return false;
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        return this.testAttribute(receiver, property, expectedValue == null ? null : expectedValue.toString());
    }

    public static void debug(String msg) {
        if (mDebug) {
            System.out.println("Debug: " + msg);
        }
    }
}

