/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.deque;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.deque.Deque;
import org.eclipse.jpt.common.utility.internal.collection.MapTools;
import org.eclipse.jpt.common.utility.stack.Stack;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public class SynchronizedDeque<E>
implements Deque<E>,
Serializable {
    private final Deque<E> deque;
    private final Object mutex;
    private static final long serialVersionUID = 1L;

    public SynchronizedDeque(Deque<E> deque, Object mutex) {
        if (deque == null || mutex == null) {
            throw new NullPointerException();
        }
        this.deque = deque;
        this.mutex = mutex;
    }

    public SynchronizedDeque(Deque<E> deque) {
        if (deque == null) {
            throw new NullPointerException();
        }
        this.deque = deque;
        this.mutex = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueueTail(E element) {
        Object object = this.mutex;
        synchronized (object) {
            this.enqueueTail_(element);
        }
    }

    private void enqueueTail_(E element) {
        this.deque.enqueueTail(element);
        this.mutex.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueueHead(E element) {
        Object object = this.mutex;
        synchronized (object) {
            this.enqueueHead_(element);
        }
    }

    private void enqueueHead_(E element) {
        this.deque.enqueueHead(element);
        this.mutex.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E dequeueHead() {
        Object object = this.mutex;
        synchronized (object) {
            return this.dequeueHead_();
        }
    }

    private E dequeueHead_() {
        Object element = this.deque.dequeueHead();
        this.mutex.notifyAll();
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E dequeueTail() {
        Object object = this.mutex;
        synchronized (object) {
            return this.dequeueTail_();
        }
    }

    private E dequeueTail_() {
        Object element = this.deque.dequeueTail();
        this.mutex.notifyAll();
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peekHead() {
        Object object = this.mutex;
        synchronized (object) {
            return this.deque.peekHead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peekTail() {
        Object object = this.mutex;
        synchronized (object) {
            return this.deque.peekTail();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.mutex;
        synchronized (object) {
            return this.deque.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilEmptyIs(boolean empty) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilEmptyIs_(empty);
        }
    }

    private void waitUntilEmptyIs_(boolean empty) throws InterruptedException {
        while (this.deque.isEmpty() != empty) {
            this.mutex.wait();
        }
    }

    public void waitUntilEmpty() throws InterruptedException {
        this.waitUntilEmptyIs(true);
    }

    public void waitUntilNotEmpty() throws InterruptedException {
        this.waitUntilEmptyIs(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToEnqueueTail(E element) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilEmptyIs_(true);
            this.enqueueTail_(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToEnqueueHead(E element) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilEmptyIs_(true);
            this.enqueueHead_(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object waitToDequeueHead() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilEmptyIs_(false);
            return this.dequeueHead_();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object waitToDequeueTail() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilEmptyIs_(false);
            return this.dequeueTail_();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilEmptyIs(boolean empty, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitUntilEmptyIs_(empty, timeout);
        }
    }

    private boolean waitUntilEmptyIs_(boolean empty, long timeout) throws InterruptedException {
        if (timeout == 0L) {
            this.waitUntilEmptyIs_(empty);
            return true;
        }
        long stop = System.currentTimeMillis() + timeout;
        long remaining = timeout;
        while (this.deque.isEmpty() != empty && remaining > 0L) {
            this.mutex.wait(remaining);
            remaining = stop - System.currentTimeMillis();
        }
        return this.deque.isEmpty() == empty;
    }

    public boolean waitUntilEmpty(long timeout) throws InterruptedException {
        return this.waitUntilEmptyIs(true, timeout);
    }

    public boolean waitUntilNotEmpty(long timeout) throws InterruptedException {
        return this.waitUntilEmptyIs(false, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitToEnqueueTail(E element, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean success = this.waitUntilEmptyIs_(true, timeout);
            if (success) {
                this.enqueueTail_(element);
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitToEnqueueHead(E element, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean success = this.waitUntilEmptyIs_(true, timeout);
            if (success) {
                this.enqueueHead_(element);
            }
            return success;
        }
    }

    public Object waitToDequeueHead(long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean success = this.waitUntilEmptyIs_(false, timeout);
            if (success) {
                return this.dequeueHead_();
            }
            throw new NoSuchElementException();
        }
    }

    public Object waitToDequeueTail(long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean success = this.waitUntilEmptyIs_(false, timeout);
            if (success) {
                return this.dequeueTail_();
            }
            throw new NoSuchElementException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Command command) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        Object object = this.mutex;
        synchronized (object) {
            command.execute();
        }
    }

    public boolean enqueueTailAll(Iterable<? extends E> iterable) {
        return this.enqueueTailAll(iterable.iterator());
    }

    public boolean enqueueHeadAll(Iterable<? extends E> iterable) {
        return this.enqueueHeadAll(iterable.iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enqueueTailAll(Iterator<? extends E> iterator) {
        if (!iterator.hasNext()) {
            return false;
        }
        Object object = this.mutex;
        synchronized (object) {
            return this.enqueueTailAll_(iterator);
        }
    }

    private boolean enqueueTailAll_(Iterator<? extends E> iterator) {
        do {
            this.deque.enqueueTail(iterator.next());
        } while (iterator.hasNext());
        this.mutex.notifyAll();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enqueueHeadAll(Iterator<? extends E> iterator) {
        if (!iterator.hasNext()) {
            return false;
        }
        Object object = this.mutex;
        synchronized (object) {
            return this.enqueueHeadAll_(iterator);
        }
    }

    private boolean enqueueHeadAll_(Iterator<? extends E> iterator) {
        do {
            this.deque.enqueueHead(iterator.next());
        } while (iterator.hasNext());
        this.mutex.notifyAll();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enqueueTailAll(E ... array) {
        int len = array.length;
        if (len == 0) {
            return false;
        }
        Object object = this.mutex;
        synchronized (object) {
            return this.enqueueTailAll_(array, len);
        }
    }

    private boolean enqueueTailAll_(E[] array, int arrayLength) {
        int i = 0;
        do {
            this.deque.enqueueTail(array[i++]);
        } while (i < arrayLength);
        this.mutex.notifyAll();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enqueueHeadAll(E ... array) {
        int len = array.length;
        if (len == 0) {
            return false;
        }
        Object object = this.mutex;
        synchronized (object) {
            return this.enqueueHeadAll_(array, len);
        }
    }

    private boolean enqueueHeadAll_(E[] array, int arrayLength) {
        int i = 0;
        do {
            this.deque.enqueueHead(array[i++]);
        } while (i < arrayLength);
        this.mutex.notifyAll();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enqueueTailAll(Stack<? extends E> stack) {
        if (stack.isEmpty()) {
            return false;
        }
        Object object = this.mutex;
        synchronized (object) {
            return this.enqueueTailAll_(stack);
        }
    }

    private boolean enqueueTailAll_(Stack<? extends E> stack) {
        do {
            this.deque.enqueueTail(stack.pop());
        } while (!stack.isEmpty());
        this.mutex.notifyAll();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enqueueHeadAll(Stack<? extends E> stack) {
        if (stack.isEmpty()) {
            return false;
        }
        Object object = this.mutex;
        synchronized (object) {
            return this.enqueueHeadAll_(stack);
        }
    }

    private boolean enqueueHeadAll_(Stack<? extends E> stack) {
        do {
            this.deque.enqueueHead(stack.pop());
        } while (!stack.isEmpty());
        this.mutex.notifyAll();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enqueueTailAll(Deque<? extends E> q) {
        if (q.isEmpty()) {
            return false;
        }
        Object object = this.mutex;
        synchronized (object) {
            return this.enqueueTailAll_(q);
        }
    }

    private boolean enqueueTailAll_(Deque<? extends E> q) {
        do {
            this.deque.enqueueTail(q.dequeueHead());
        } while (!q.isEmpty());
        this.mutex.notifyAll();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enqueueHeadAll(Deque<? extends E> q) {
        if (q.isEmpty()) {
            return false;
        }
        Object object = this.mutex;
        synchronized (object) {
            return this.enqueueHeadAll_(q);
        }
    }

    private boolean enqueueHeadAll_(Deque<? extends E> q) {
        do {
            this.deque.enqueueHead(q.dequeueTail());
        } while (!q.isEmpty());
        this.mutex.notifyAll();
        return true;
    }

    public ArrayList<E> drainHead() {
        ArrayList result = new ArrayList();
        this.drainHeadTo(result);
        return result;
    }

    public ArrayList<E> drainTail() {
        ArrayList result = new ArrayList();
        this.drainTailTo(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drainHeadTo(Collection<? super E> collection) {
        Object object = this.mutex;
        synchronized (object) {
            return this.drainHeadTo_(collection);
        }
    }

    private boolean drainHeadTo_(Collection<? super E> collection) {
        if (this.deque.isEmpty()) {
            return false;
        }
        return this.drainHeadTo__(collection);
    }

    private boolean drainHeadTo__(Collection<? super E> collection) {
        do {
            collection.add(this.deque.dequeueHead());
        } while (!this.deque.isEmpty());
        this.mutex.notifyAll();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drainTailTo(Collection<? super E> collection) {
        Object object = this.mutex;
        synchronized (object) {
            return this.drainTailTo_(collection);
        }
    }

    private boolean drainTailTo_(Collection<? super E> collection) {
        if (this.deque.isEmpty()) {
            return false;
        }
        return this.drainTailTo__(collection);
    }

    private boolean drainTailTo__(Collection<? super E> collection) {
        do {
            collection.add(this.deque.dequeueTail());
        } while (!this.deque.isEmpty());
        this.mutex.notifyAll();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drainHeadTo(List<? super E> list, int index) {
        Object object = this.mutex;
        synchronized (object) {
            return this.drainHeadTo_(list, index);
        }
    }

    private boolean drainHeadTo_(List<? super E> list, int index) {
        if (this.deque.isEmpty()) {
            return false;
        }
        if (index == list.size()) {
            return this.drainHeadTo__(list);
        }
        ArrayList temp = new ArrayList();
        this.drainHeadTo__(temp);
        list.addAll(index, temp);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drainTailTo(List<? super E> list, int index) {
        Object object = this.mutex;
        synchronized (object) {
            return this.drainTailTo_(list, index);
        }
    }

    private boolean drainTailTo_(List<? super E> list, int index) {
        if (this.deque.isEmpty()) {
            return false;
        }
        if (index == list.size()) {
            return this.drainTailTo__(list);
        }
        ArrayList temp = new ArrayList();
        this.drainTailTo__(temp);
        list.addAll(index, temp);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drainHeadTo(Stack<? super E> stack) {
        Object object = this.mutex;
        synchronized (object) {
            return this.drainHeadTo_(stack);
        }
    }

    private boolean drainHeadTo_(Stack<? super E> stack) {
        if (this.deque.isEmpty()) {
            return false;
        }
        do {
            stack.push(this.deque.dequeueHead());
        } while (!this.deque.isEmpty());
        this.mutex.notifyAll();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drainTailTo(Stack<? super E> stack) {
        Object object = this.mutex;
        synchronized (object) {
            return this.drainTailTo_(stack);
        }
    }

    private boolean drainTailTo_(Stack<? super E> stack) {
        if (this.deque.isEmpty()) {
            return false;
        }
        do {
            stack.push(this.deque.dequeueTail());
        } while (!this.deque.isEmpty());
        this.mutex.notifyAll();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drainHeadTo(Deque<? super E> q) {
        Object object = this.mutex;
        synchronized (object) {
            return this.drainHeadTo_(q);
        }
    }

    private boolean drainHeadTo_(Deque<? super E> q) {
        if (this.deque.isEmpty()) {
            return false;
        }
        do {
            q.enqueueTail(this.deque.dequeueHead());
        } while (!this.deque.isEmpty());
        this.mutex.notifyAll();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drainTailTo(Deque<? super E> q) {
        Object object = this.mutex;
        synchronized (object) {
            return this.drainTailTo_(q);
        }
    }

    private boolean drainTailTo_(Deque<? super E> q) {
        if (this.deque.isEmpty()) {
            return false;
        }
        do {
            q.enqueueHead(this.deque.dequeueTail());
        } while (!this.deque.isEmpty());
        this.mutex.notifyAll();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K> boolean drainHeadTo(Map<K, ? super E> map, Transformer<? super E, ? extends K> keyTransformer) {
        Object object = this.mutex;
        synchronized (object) {
            return this.drainHeadTo_(map, keyTransformer);
        }
    }

    private <K> boolean drainHeadTo_(Map<K, ? super E> map, Transformer<? super E, ? extends K> keyTransformer) {
        if (this.deque.isEmpty()) {
            return false;
        }
        do {
            MapTools.add(map, this.deque.dequeueHead(), keyTransformer);
        } while (!this.deque.isEmpty());
        this.mutex.notifyAll();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K> boolean drainTailTo(Map<K, ? super E> map, Transformer<? super E, ? extends K> keyTransformer) {
        Object object = this.mutex;
        synchronized (object) {
            return this.drainTailTo_(map, keyTransformer);
        }
    }

    private <K> boolean drainTailTo_(Map<K, ? super E> map, Transformer<? super E, ? extends K> keyTransformer) {
        if (this.deque.isEmpty()) {
            return false;
        }
        do {
            MapTools.add(map, this.deque.dequeueTail(), keyTransformer);
        } while (!this.deque.isEmpty());
        this.mutex.notifyAll();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> boolean drainHeadTo(Map<K, V> map, Transformer<? super E, ? extends K> keyTransformer, Transformer<? super E, ? extends V> valueTransformer) {
        Object object = this.mutex;
        synchronized (object) {
            return this.drainHeadTo_(map, keyTransformer, valueTransformer);
        }
    }

    private <K, V> boolean drainHeadTo_(Map<K, V> map, Transformer<? super E, ? extends K> keyTransformer, Transformer<? super E, ? extends V> valueTransformer) {
        if (this.deque.isEmpty()) {
            return false;
        }
        do {
            MapTools.add(map, this.deque.dequeueHead(), keyTransformer, valueTransformer);
        } while (!this.deque.isEmpty());
        this.mutex.notifyAll();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> boolean drainTailTo(Map<K, V> map, Transformer<? super E, ? extends K> keyTransformer, Transformer<? super E, ? extends V> valueTransformer) {
        Object object = this.mutex;
        synchronized (object) {
            return this.drainTailTo_(map, keyTransformer, valueTransformer);
        }
    }

    private <K, V> boolean drainTailTo_(Map<K, V> map, Transformer<? super E, ? extends K> keyTransformer, Transformer<? super E, ? extends V> valueTransformer) {
        if (this.deque.isEmpty()) {
            return false;
        }
        do {
            MapTools.add(map, this.deque.dequeueTail(), keyTransformer, valueTransformer);
        } while (!this.deque.isEmpty());
        this.mutex.notifyAll();
        return true;
    }

    public Object getMutex() {
        return this.mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.mutex;
        synchronized (object) {
            return this.deque.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            s.defaultWriteObject();
        }
    }
}

