/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpmstubby.model;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.internal.rpmstubby.StubbyLog;
import org.eclipse.linuxtools.internal.rpmstubby.parser.PythonEggParser;

public class EggModel {
    private static final String[] VALID_LICENSES = new String[]{"GPL", "Artistic", "MIT", "Apache", "Public", "zlib", "Ricoh", "Vovida", "Intel", "LGPL", "BSD", "QPL", "IBM", "PHP", "CNRI", "CVW", "Python", "Sun", "Jabber"};
    private static final String LONG_DESCRIPTION = "long_description";
    private static final String CLASSIFIERS = "classifiers";
    private static final String INSTALL_REQUIRES = "install_requires";
    private static final String FIX_ME = "#FIXME";
    private PythonEggParser pyEggParser;

    public EggModel(IFile file) {
        try {
            this.pyEggParser = new PythonEggParser(file);
        }
        catch (IOException | CoreException e) {
            StubbyLog.logError(e);
        }
    }

    private String getValue(String option) {
        String str = this.pyEggParser.getValue(option);
        if (str.isEmpty() || this.pyEggParser.checkFunction(str)) {
            str = FIX_ME;
        }
        return str;
    }

    private String getClassifiersList(String keyword) {
        String rc = "";
        List<String> list = this.pyEggParser.getValueList(CLASSIFIERS);
        for (String str : list) {
            if (!str.toLowerCase().contains(keyword)) continue;
            rc = str;
        }
        return rc;
    }

    public List<String> getInstallRequiresList() {
        return this.pyEggParser.getValueList(INSTALL_REQUIRES);
    }

    public String getSimplePackageName() {
        return this.getValue("name");
    }

    public String getPackageName() {
        String simpleName = this.getSimplePackageName();
        if (simpleName.startsWith("python-")) {
            return simpleName;
        }
        return "python-" + simpleName;
    }

    public String getVersion() {
        String version = this.getValue("version");
        if (!this.hasDigits(version)) {
            version = "1 #FIXME";
        }
        return version;
    }

    public boolean hasDigits(String str) {
        return str.matches(".*\\d.*");
    }

    public String getSummary() {
        return this.getValue(LONG_DESCRIPTION);
    }

    public String getLicense() {
        String rawLicense = this.getClassifiersList("license").toLowerCase();
        String license = "";
        String[] stringArray = VALID_LICENSES;
        int n = VALID_LICENSES.length;
        int n2 = 0;
        while (n2 < n) {
            String valid = stringArray[n2];
            if (rawLicense.contains(valid.toLowerCase())) {
                license = String.valueOf(license) + valid + ", ";
            }
            ++n2;
        }
        license = !license.isEmpty() ? license.substring(0, license.length() - 2) : FIX_ME;
        return license;
    }

    public String getURL() {
        return this.getValue("url");
    }

    public String getDescription() {
        return this.getValue("description");
    }
}

