/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.ICompletionReporter;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.core.compiler.ast.nodes.PHPModuleDeclaration;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.strategies.AbstractCompletionStrategy;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPHPScriptRegion;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.context.FileContext;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class InUseTraitStrategy
extends AbstractCompletionStrategy {
    public InUseTraitStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public InUseTraitStrategy(ICompletionContext context) {
        super(context);
    }

    private List<String> getUseTypes() {
        AbstractList useTypes = new LinkedList<String>();
        if (this.getCompanion().getPHPVersion().isLessThan(PHPVersion.PHP5_4)) {
            return useTypes;
        }
        IStructuredDocumentRegion sdRegion = this.getCompanion().getStructuredDocumentRegion();
        int documentOffset = this.getCompanion().getOffset();
        if (documentOffset == sdRegion.getEndOffset()) {
            --documentOffset;
        }
        ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(documentOffset);
        IStructuredDocumentRegion container = sdRegion;
        if (tRegion instanceof ITextRegionContainer) {
            container = (ITextRegionContainer)tRegion;
            tRegion = container.getRegionAtCharacterOffset(this.getCompanion().getOffset());
        }
        if (tRegion != null && tRegion.getType() == "PHP_CLOSE") {
            tRegion = container.getRegionAtCharacterOffset(container.getStartOffset() + tRegion.getStart() - 1);
        }
        if (tRegion != null && tRegion.getType() == "PHP_CONTENT") {
            IPHPScriptRegion phpScriptRegion = (IPHPScriptRegion)tRegion;
            try {
                int startOffset = container.getStartOffset() + phpScriptRegion.getStart();
                ITextRegion startTokenRegion = documentOffset == startOffset ? phpScriptRegion.getPHPToken(0) : phpScriptRegion.getPHPToken(this.getCompanion().getOffset() - startOffset - 1);
                while (true) {
                    if (startTokenRegion.getStart() == 0) {
                        return useTypes;
                    }
                    if (startTokenRegion.getType() == "PHP_CURLY_OPEN") {
                        TextSequence statementText1 = PHPTextSequenceUtilities.getStatement(startOffset + startTokenRegion.getStart() - 1, this.getCompanion().getStructuredDocumentRegion(), true);
                        if ((startTokenRegion = phpScriptRegion.getPHPToken(startTokenRegion.getStart() - statementText1.length())).getType() == "PHP_USE") {
                            String[] types = statementText1.toString().trim().substring(3).trim().split(",");
                            useTypes = new ArrayList();
                            String[] stringArray = types;
                            int n = types.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String type = stringArray[n2];
                                useTypes.add((String)type.trim());
                                ++n2;
                            }
                            return useTypes;
                        }
                        return useTypes;
                    }
                    if (startTokenRegion.getType() == "PHP_CURLY_CLOSE") {
                        return useTypes;
                    }
                    startTokenRegion = phpScriptRegion.getPHPToken(startTokenRegion.getStart() - 1);
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return useTypes;
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        ICompletionContext context = this.getContext();
        if (!(context instanceof AbstractCompletionContext)) {
            return;
        }
        AbstractCompletionContext abstractContext = (AbstractCompletionContext)context;
        int offset = this.getCompanion().getOffset();
        ISourceModule sourceModule = this.getCompanion().getSourceModule();
        List<String> useTypes = this.getUseTypes();
        String prefix = abstractContext.getPrefix();
        PHPModuleDeclaration moduleDeclaration = this.getCompanion().getModuleDeclaration();
        FileContext fileContext = new FileContext(sourceModule, moduleDeclaration, offset);
        ISourceRange replacementRange = this.getReplacementRange(abstractContext);
        for (String useType : useTypes) {
            PHPClassType type;
            IType[] modelElements;
            if (!StringUtils.startsWithIgnoreCase((CharSequence)useType.trim(), (CharSequence)prefix) || (modelElements = PHPTypeInferenceUtils.getModelElements((IEvaluatedType)(type = PHPClassType.fromTraitName(useType, sourceModule, offset)), (ISourceModuleContext)fileContext, offset)) == null) continue;
            IType[] iTypeArray = modelElements;
            int n = modelElements.length;
            int n2 = 0;
            while (n2 < n) {
                IType typeElement = iTypeArray[n2];
                reporter.reportType(typeElement, "", replacementRange, 2);
                ++n2;
            }
        }
    }
}

