/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.table;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.IAnalysisProgressListener;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.internal.analysis.timing.ui.Activator;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.table.Messages;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.table.SegmentStoreContentProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser.FilterCu;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser.IFilterStrings;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TmfFilterAppliedSignal;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TraceCompassFilter;
import org.eclipse.tracecompass.internal.segmentstore.core.arraylist.ArrayListStore;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.tmf.core.TmfStrings;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfSourceLookup;
import org.eclipse.tracecompass.tmf.core.model.timegraph.IElementResolver;
import org.eclipse.tracecompass.tmf.core.segment.ISegmentAspect;
import org.eclipse.tracecompass.tmf.core.signal.TmfDataModelSelectedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.actions.OpenSourceCodeAction;
import org.eclipse.tracecompass.tmf.ui.viewers.table.TmfSimpleTableViewer;

public abstract class AbstractSegmentStoreTableViewer
extends TmfSimpleTableViewer {
    private static final int MAX_ITEMS = 65535;
    private static final Format FORMATTER = new DecimalFormat("###,###.##");
    private static final Logger LOGGER = TraceCompassLog.getLogger(AbstractSegmentStoreTableViewer.class);
    private @Nullable ISegmentStoreProvider fSegmentProvider = null;
    private final @Nullable SegmentStoreProviderProgressListener fListener;
    private @Nullable ITmfTrace fTrace;
    boolean fColumnsCreated = false;
    private @Nullable Job fFilteringJob = null;
    private Set<String> fLocalRegexes = Collections.emptySet();

    public AbstractSegmentStoreTableViewer(TableViewer tableViewer) {
        this(tableViewer, true);
    }

    public AbstractSegmentStoreTableViewer(TableViewer tableViewer, boolean withListener) {
        super(tableViewer);
        this.getTableViewer().setContentProvider((IContentProvider)new SegmentStoreContentProvider());
        this.createColumns();
        this.getTableViewer().getTable().addSelectionListener((SelectionListener)new TableSelectionListener());
        this.addPackListener();
        this.fListener = withListener ? new SegmentStoreProviderProgressListener() : null;
    }

    @VisibleForTesting
    public void setSegmentProvider(ISegmentStoreProvider segmentProvider) {
        this.fSegmentProvider = segmentProvider;
        this.getTableViewer().setContentProvider((IContentProvider)new SegmentStoreContentProvider());
        Table table = this.getTableViewer().getTable();
        table.setRedraw(false);
        while (table.getColumnCount() > 0) {
            table.getColumn(0).dispose();
        }
        this.createColumns();
        this.createProviderColumns();
        this.getTableViewer().getTable().addSelectionListener((SelectionListener)new TableSelectionListener());
        this.addPackListener();
        table.setRedraw(true);
    }

    private void createColumns() {
        for (final ISegmentAspect aspect : ISegmentStoreProvider.getBaseSegmentAspects()) {
            if (aspect.getName().equals(TmfStrings.duration())) {
                this.createColumn(aspect.getName(), new SegmentStoreTableColumnLabelProvider(this){

                    @Override
                    public String getTextForSegment(ISegment input) {
                        return NonNullUtils.nullToEmptyString((Object)FORMATTER.format(aspect.resolve(input)));
                    }
                }, aspect.getComparator());
                continue;
            }
            this.createColumn(aspect.getName(), new SegmentStoreTableColumnLabelProvider(this){

                @Override
                public String getTextForSegment(ISegment input) {
                    return NonNullUtils.nullToEmptyString((Object)TmfTimestampFormat.getDefaulTimeFormat().format(((Long)Objects.requireNonNull(aspect.resolve(input))).longValue()));
                }
            }, aspect.getComparator());
        }
    }

    protected void createProviderColumns() {
        if (!this.fColumnsCreated) {
            ISegmentStoreProvider provider = this.getSegmentProvider();
            if (provider != null) {
                for (final ISegmentAspect aspect : provider.getSegmentAspects()) {
                    this.createColumn(aspect.getName(), new SegmentStoreTableColumnLabelProvider(this){

                        @Override
                        public String getTextForSegment(ISegment input) {
                            return NonNullUtils.nullToEmptyString((Object)aspect.resolve(input));
                        }
                    }, aspect.getComparator());
                }
            }
            this.fColumnsCreated = true;
        }
    }

    public void updateModel(@Nullable Object dataInput) {
        TableViewer tableViewer = this.getTableViewer();
        Display.getDefault().asyncExec(() -> {
            Throwable throwable = null;
            Object var4_5 = null;
            try (TraceCompassLogUtils.ScopeLog sl = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINE, "updateModel", new Object[0]);){
                if (!tableViewer.getTable().isDisposed()) {
                    Object firstElement;
                    tableViewer.getTable().setTopIndex(0);
                    ISelection selection = tableViewer.getSelection();
                    ISegment selected = null;
                    if (!selection.isEmpty() && selection instanceof StructuredSelection && (firstElement = ((StructuredSelection)selection).getFirstElement()) instanceof ISegment) {
                        selected = (ISegment)firstElement;
                    }
                    if (dataInput == null) {
                        tableViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                        tableViewer.setInput(null);
                        tableViewer.setItemCount(0);
                        return;
                    }
                    this.addPackListener();
                    tableViewer.setInput(dataInput);
                    SegmentStoreContentProvider contentProvider = (SegmentStoreContentProvider)this.getTableViewer().getContentProvider();
                    long segmentCount = contentProvider.getSegmentCount();
                    String contentProviderName = contentProvider.getClass().getSimpleName();
                    TraceCompassLogUtils.traceCounter((Logger)LOGGER, (Level)Level.FINE, (String)"SegmentStoreTableViewer#updateModel", (Object[])new Object[]{contentProviderName, segmentCount});
                    if (segmentCount > 65535L) {
                        tableViewer.setItemCount(65535);
                        Activator.getDefault().logWarning("Too many items to display for " + contentProviderName + ". Cannot display " + segmentCount + " in a reasonable timeframe.");
                    } else {
                        tableViewer.setItemCount((int)segmentCount);
                    }
                    boolean found = false;
                    if (selected != null && dataInput instanceof ISegmentStore) {
                        ISegmentStore store = (ISegmentStore)dataInput;
                        for (ISegment segment : store.getIntersectingElements(selected.getEnd())) {
                            if (!this.isSameish(segment, selected)) continue;
                            selection = new StructuredSelection((Object)segment);
                            tableViewer.setSelection(selection, true);
                            found = true;
                            break;
                        }
                    }
                    if (!found) {
                        tableViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        });
    }

    private boolean isSameish(ISegment left, ISegment right) {
        if (!Objects.equals(left.getStart(), right.getStart()) || !Objects.equals(left.getEnd(), right.getEnd())) {
            return false;
        }
        ISegmentStoreProvider segmentProvider = this.getSegmentProvider();
        if (segmentProvider == null) {
            return false;
        }
        for (ISegmentAspect aspect : segmentProvider.getSegmentAspects()) {
            if (Objects.equals(aspect.resolve(left), aspect.resolve(right))) continue;
            return false;
        }
        return true;
    }

    public synchronized void setData(@Nullable ISegmentStoreProvider provider) {
        this.fSegmentProvider = provider;
        if (provider == null) {
            this.updateModel(null);
            return;
        }
        this.createProviderColumns();
        SegmentStoreProviderProgressListener listener = this.fListener;
        if (listener == null) {
            return;
        }
        final ISegmentStore segStore = provider.getSegmentStore();
        Map<@NonNull Integer, @NonNull Predicate<@NonNull Multimap<@NonNull String, @NonNull Object>>> predicates = this.generateRegexPredicate();
        final Predicate<ISegment> predicate = segment -> {
            @NonNull @NonNull Multimap input = ISegmentStoreProvider.getFilterInput((ISegmentStoreProvider)provider, (ISegment)segment);
            boolean activateProperty = false;
            for (Map.Entry mapEntry : predicates.entrySet()) {
                Integer property = Objects.requireNonNull((Integer)mapEntry.getKey());
                Predicate value = Objects.requireNonNull((Predicate)mapEntry.getValue());
                if (property != 1 && property != 4) continue;
                boolean status = value.test(input);
                activateProperty |= status;
            }
            return activateProperty;
        };
        if (segStore != null) {
            Job job = this.fFilteringJob;
            if (job != null) {
                job.cancel();
            }
            if (predicates.isEmpty()) {
                this.updateModel(segStore);
                return;
            }
            this.fFilteringJob = job = new Job(Messages.SegmentStoreTableViewer_FilteringData){

                protected IStatus run(@Nullable IProgressMonitor monitor) {
                    Throwable throwable = null;
                    Object var3_4 = null;
                    try (TraceCompassLogUtils.ScopeLog log = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINE, "SegmentStoreTable:Filtering", new Object[0]);){
                        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
                        ArrayListStore filteredStore = new ArrayListStore();
                        for (ISegment segment : segStore) {
                            if (subMonitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            if (!predicate.test(segment)) continue;
                            filteredStore.add((Object)segment);
                        }
                        if (subMonitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        AbstractSegmentStoreTableViewer.this.updateModel(filteredStore);
                        return Status.OK_STATUS;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            };
            job.schedule();
            return;
        }
        this.updateModel(null);
        provider.addListener((IAnalysisProgressListener)listener);
        if (provider instanceof IAnalysisModule) {
            ((IAnalysisModule)provider).schedule();
        }
    }

    protected Map<Integer, Predicate<Multimap<String, Object>>> generateRegexPredicate() {
        Multimap<Integer, String> regexes = this.getRegexes();
        HashMap<@NonNull Integer, @NonNull Predicate<@NonNull Multimap<@NonNull String, @NonNull Object>>> predicates = new HashMap<Integer, Predicate<Multimap<String, Object>>>();
        for (Map.Entry entry : regexes.asMap().entrySet()) {
            Predicate predicate;
            String regex = IFilterStrings.mergeFilters((Collection)((Collection)entry.getValue()));
            FilterCu cu = FilterCu.compile((String)regex);
            Predicate predicate2 = predicate = cu != null ? cu.generate() : null;
            if (predicate == null) continue;
            predicates.put((Integer)entry.getKey(), predicate);
        }
        return predicates;
    }

    protected abstract @Nullable ISegmentStoreProvider getSegmentStoreProvider(ITmfTrace var1);

    protected void appendToTablePopupMenu(IMenuManager manager, IStructuredSelection sel) {
        final ISegment segment = (ISegment)sel.getFirstElement();
        if (segment != null) {
            IContributionItem openCallsiteAction;
            Action gotoStartTime = new Action(Messages.SegmentStoreTableViewer_goToStartEvent){

                public void run() {
                    AbstractSegmentStoreTableViewer.this.broadcast((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)AbstractSegmentStoreTableViewer.this, TmfTimestamp.fromNanos((long)segment.getStart()), TmfTimestamp.fromNanos((long)segment.getStart()), AbstractSegmentStoreTableViewer.this.fTrace));
                }
            };
            Action gotoEndTime = new Action(Messages.SegmentStoreTableViewer_goToEndEvent){

                public void run() {
                    AbstractSegmentStoreTableViewer.this.broadcast((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)AbstractSegmentStoreTableViewer.this, TmfTimestamp.fromNanos((long)segment.getEnd()), TmfTimestamp.fromNanos((long)segment.getEnd()), AbstractSegmentStoreTableViewer.this.fTrace));
                }
            };
            manager.add((IAction)gotoStartTime);
            manager.add((IAction)gotoEndTime);
            if (segment instanceof ITmfSourceLookup && (openCallsiteAction = OpenSourceCodeAction.create((String)Messages.SegmentStoreTableViewer_lookup, (ITmfSourceLookup)((ITmfSourceLookup)segment), (Shell)this.getTableViewer().getTable().getShell())) != null) {
                manager.add(openCallsiteAction);
            }
        }
    }

    public void dispose() {
        super.dispose();
        Job job = this.fFilteringJob;
        if (job != null) {
            job.cancel();
        }
    }

    public @Nullable ISegmentStoreProvider getSegmentProvider() {
        return this.fSegmentProvider;
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        Job job;
        ITmfTrace trace = signal.getTrace();
        if (trace != this.fTrace && (job = this.fFilteringJob) != null) {
            job.cancel();
        }
        this.fTrace = trace;
        if (trace != null) {
            this.setData(this.getSegmentStoreProvider(trace));
        }
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        Job job;
        ITmfTrace trace = signal.getTrace();
        if (trace != this.fTrace && (job = this.fFilteringJob) != null) {
            job.cancel();
        }
        this.fTrace = trace;
        if (trace != null) {
            this.setData(this.getSegmentStoreProvider(trace));
        }
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        Job job;
        ITmfTrace trace = this.fTrace;
        if (trace == signal.getTrace() && (job = this.fFilteringJob) != null) {
            job.cancel();
        }
        if (TmfTraceManager.getInstance().getActiveTrace() == null) {
            SegmentStoreProviderProgressListener listener;
            ISegmentStoreProvider provider;
            if (!this.getTableViewer().getTable().isDisposed()) {
                this.getTableViewer().setInput(null);
                this.getTableViewer().setItemCount(0);
                this.refresh();
            }
            if ((provider = this.getSegmentProvider()) != null && (listener = this.fListener) != null) {
                provider.removeListener((IAnalysisProgressListener)listener);
            }
            this.fTrace = null;
        }
    }

    @TmfSignalHandler
    public void regexFilterApplied(TmfFilterAppliedSignal signal) {
        this.setData(this.getSegmentProvider());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected Multimap<@NonNull Integer, @NonNull String> getRegexes() {
        TraceCompassFilter globalFilter;
        @NonNull @NonNull HashMultimap regexes = HashMultimap.create();
        ITmfTrace trace = this.fTrace;
        if (trace == null) {
            return regexes;
        }
        Set<String> localRegexes = this.fLocalRegexes;
        if (!localRegexes.isEmpty()) {
            regexes.putAll((Object)1, localRegexes);
        }
        if ((globalFilter = TraceCompassFilter.getFilterForTrace((ITmfTrace)trace)) == null) {
            return regexes;
        }
        regexes.putAll((Object)1, (Iterable)globalFilter.getRegexes());
        return regexes;
    }

    private void addPackListener() {
        this.getControl().addListener(36, new Listener(){

            public void handleEvent(@Nullable Event event) {
                AbstractSegmentStoreTableViewer.this.getControl().removeListener(36, (Listener)this);
                TableViewer tableViewer = AbstractSegmentStoreTableViewer.this.getTableViewer();
                if (tableViewer != null) {
                    TableColumn[] tableColumnArray = tableViewer.getTable().getColumns();
                    int n = tableColumnArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableColumn col = tableColumnArray[n2];
                        col.pack();
                        ++n2;
                    }
                }
            }
        });
    }

    public void setLocalRegexes(Set<String> filterRegexes) {
        if (!filterRegexes.equals(this.fLocalRegexes)) {
            this.fLocalRegexes = ImmutableSet.copyOf(filterRegexes);
            this.setData(this.getSegmentProvider());
        }
    }

    private final class SegmentStoreProviderProgressListener
    implements IAnalysisProgressListener {
        private SegmentStoreProviderProgressListener() {
        }

        public void onComplete(ISegmentStoreProvider activeProvider, ISegmentStore<ISegment> data) {
            if (activeProvider.equals(AbstractSegmentStoreTableViewer.this.fSegmentProvider)) {
                Display.getDefault().asyncExec(() -> AbstractSegmentStoreTableViewer.this.setData(activeProvider));
            }
        }
    }

    private abstract class SegmentStoreTableColumnLabelProvider
    extends ColumnLabelProvider {
        private SegmentStoreTableColumnLabelProvider() {
        }

        public String getText(@Nullable Object input) {
            if (!(input instanceof ISegment)) {
                return "";
            }
            return this.getTextForSegment((ISegment)input);
        }

        public abstract String getTextForSegment(ISegment var1);
    }

    private class TableSelectionListener
    extends SelectionAdapter {
        private TableSelectionListener() {
        }

        public void widgetSelected(@Nullable SelectionEvent e) {
            Multimap metadata;
            ISegment selectedSegment = (ISegment)((SelectionEvent)NonNullUtils.checkNotNull((Object)e)).item.getData();
            ITmfTimestamp start = TmfTimestamp.fromNanos((long)selectedSegment.getStart());
            ITmfTimestamp end = TmfTimestamp.fromNanos((long)selectedSegment.getEnd());
            TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)AbstractSegmentStoreTableViewer.this, start, end, AbstractSegmentStoreTableViewer.this.fTrace));
            if (selectedSegment instanceof IElementResolver && !(metadata = ((IElementResolver)selectedSegment).getMetadata()).isEmpty()) {
                TmfSignalManager.dispatchSignal((TmfSignal)new TmfDataModelSelectedSignal((Object)AbstractSegmentStoreTableViewer.this, metadata));
            }
        }
    }
}

