/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cmake.ui.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.cmake.ui.internal.Messages;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.launch.ui.corebuild.CommonBuildTab;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CMakeBuildTab
extends CommonBuildTab {
    private Button useUiCmakeSettings;
    private Button unixGenButton;
    private Button ninjaGenButton;
    private Text cmakeArgsText;
    private Text buildCommandText;
    private Text cleanCommandText;
    private Label generatorLabel;
    private Label cmakeArgsLabel;
    private Label buildCommandLabel;
    private Label cleanCommandLabel;

    protected String getBuildConfigProviderId() {
        return "org.eclipse.cdt.cmake.core.provider";
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        this.setControl((Control)comp);
        Control tcControl = this.createToolchainSelector(comp);
        tcControl.setLayoutData((Object)new GridData(4, 4, true, false));
        Group cmakeGroup = new Group(comp, 0);
        cmakeGroup.setText(Messages.CMakeBuildTab_Settings);
        cmakeGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        cmakeGroup.setLayout((Layout)new GridLayout());
        this.useUiCmakeSettings = new Button((Composite)cmakeGroup, 32);
        this.useUiCmakeSettings.setText(Messages.CMakeBuildTab_useUICmakeSettings);
        this.useUiCmakeSettings.setToolTipText(Messages.CMakeBuildTab_useUICmakeSettingsTip);
        this.useUiCmakeSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CMakeBuildTab.this.updateEnablement();
                CMakeBuildTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.generatorLabel = new Label((Composite)cmakeGroup, 0);
        this.generatorLabel.setText(Messages.CMakeBuildTab_Generator);
        Composite genComp = new Composite((Composite)cmakeGroup, 2048);
        genComp.setLayout((Layout)new GridLayout(2, true));
        this.unixGenButton = new Button(genComp, 16);
        this.unixGenButton.setText(Messages.CMakeBuildTab_UnixMakefiles);
        this.unixGenButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CMakeBuildTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.ninjaGenButton = new Button(genComp, 16);
        this.ninjaGenButton.setText(Messages.CMakeBuildTab_Ninja);
        this.ninjaGenButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CMakeBuildTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.cmakeArgsLabel = new Label((Composite)cmakeGroup, 0);
        this.cmakeArgsLabel.setText(Messages.CMakeBuildTab_CMakeArgs);
        this.cmakeArgsText = new Text((Composite)cmakeGroup, 2048);
        this.cmakeArgsText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.cmakeArgsText.addModifyListener(e -> this.updateLaunchConfigurationDialog());
        this.buildCommandLabel = new Label((Composite)cmakeGroup, 0);
        this.buildCommandLabel.setText(Messages.CMakeBuildTab_BuildCommand);
        this.buildCommandText = new Text((Composite)cmakeGroup, 2048);
        this.buildCommandText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.buildCommandText.addModifyListener(e -> this.updateLaunchConfigurationDialog());
        this.cleanCommandLabel = new Label((Composite)cmakeGroup, 0);
        this.cleanCommandLabel.setText(Messages.CMakeBuildTab_CleanCommand);
        this.cleanCommandText = new Text((Composite)cmakeGroup, 2048);
        this.cleanCommandText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.cleanCommandText.addModifyListener(e -> this.updateLaunchConfigurationDialog());
    }

    private void updateEnablement() {
        boolean isSelected = this.useUiCmakeSettings.getSelection();
        this.generatorLabel.setEnabled(isSelected);
        this.unixGenButton.setEnabled(isSelected);
        this.ninjaGenButton.setEnabled(isSelected);
        this.cmakeArgsLabel.setEnabled(isSelected);
        this.cmakeArgsText.setEnabled(isSelected);
        this.buildCommandLabel.setEnabled(isSelected);
        this.buildCommandText.setEnabled(isSelected);
        this.cleanCommandLabel.setEnabled(isSelected);
        this.cleanCommandText.setEnabled(isSelected);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        ICBuildConfiguration buildConfig = this.getBuildConfiguration();
        buildConfig.setProperty("cmake.use.ui.overrides", Boolean.toString(false));
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        ICBuildConfiguration buildConfig = this.getBuildConfiguration();
        String generator = buildConfig.getProperty("cmake.generator");
        this.updateGeneratorButtons(generator);
        String cmakeArgs = buildConfig.getProperty("cmake.arguments");
        if (cmakeArgs != null) {
            this.cmakeArgsText.setText(cmakeArgs);
        } else {
            this.cmakeArgsText.setText("");
        }
        String buildCommand = buildConfig.getProperty("cmake.command.build");
        if (buildCommand != null) {
            this.buildCommandText.setText(buildCommand);
        } else {
            this.buildCommandText.setText("");
        }
        String cleanCommand = buildConfig.getProperty("cmake.command.clean");
        if (cleanCommand != null) {
            this.cleanCommandText.setText(cleanCommand);
        } else {
            this.cleanCommandText.setText("");
        }
        boolean isSelected = Boolean.valueOf(buildConfig.getProperty("cmake.use.ui.overrides"));
        this.useUiCmakeSettings.setSelection(isSelected);
        this.updateEnablement();
    }

    private void updateGeneratorButtons(String generator) {
        if (generator == null || generator.equals("Ninja")) {
            this.ninjaGenButton.setSelection(true);
        } else {
            this.unixGenButton.setSelection(true);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        ICBuildConfiguration buildConfig = this.getBuildConfiguration();
        String gen = this.ninjaGenButton.getSelection() ? "Ninja" : "Unix Makefiles";
        buildConfig.setProperty("cmake.generator", gen);
        String cmakeArgs = this.cmakeArgsText.getText().trim();
        if (!cmakeArgs.isEmpty()) {
            buildConfig.setProperty("cmake.arguments", cmakeArgs);
        } else {
            buildConfig.removeProperty("cmake.arguments");
        }
        String buildCommand = this.buildCommandText.getText().trim();
        if (!buildCommand.isEmpty()) {
            buildConfig.setProperty("cmake.command.build", buildCommand);
        } else {
            buildConfig.removeProperty("cmake.command.build");
        }
        String cleanCommand = this.cleanCommandText.getText().trim();
        if (!cleanCommand.isEmpty()) {
            buildConfig.setProperty("cmake.command.clean", cleanCommand);
        } else {
            buildConfig.removeProperty("cmake.command.clean");
        }
        boolean isSelected = this.useUiCmakeSettings.getSelection();
        buildConfig.setProperty("cmake.use.ui.overrides", Boolean.toString(isSelected));
        HashMap<String, String> saved = new HashMap<String, String>();
        saved.put("cmake.use.ui.overrides", Boolean.toString(isSelected));
        this.getBuildConfiguration().setProperties(saved);
    }

    protected void saveProperties(Map<String, String> properties) {
        super.saveProperties(properties);
        properties.put("cmake.generator", this.ninjaGenButton.getSelection() ? "Ninja" : "Unix Makefiles");
        properties.put("cmake.arguments", this.cmakeArgsText.getText().trim());
        properties.put("cmake.command.build", this.buildCommandText.getText().trim());
        properties.put("cmake.command.clean", this.cleanCommandText.getText().trim());
    }

    protected void restoreProperties(Map<String, String> properties) {
        String cmakeArgs;
        block16: {
            super.restoreProperties(properties);
            String gen = properties.get("cmake.generator");
            if (gen == null) break block16;
            switch (gen) {
                case "Ninja": {
                    this.ninjaGenButton.setSelection(true);
                    this.unixGenButton.setSelection(false);
                    break;
                }
                case "Unix Makefiles": {
                    this.ninjaGenButton.setSelection(false);
                    this.unixGenButton.setSelection(true);
                }
            }
        }
        if ((cmakeArgs = properties.get("cmake.arguments")) != null) {
            this.cmakeArgsText.setText(cmakeArgs);
        } else {
            this.cmakeArgsText.setText("");
        }
        String buildCmd = properties.get("cmake.command.build");
        if (buildCmd != null) {
            this.buildCommandText.setText(buildCmd);
        } else {
            this.buildCommandText.setText("");
        }
        String cleanCmd = properties.get("cmake.command.clean");
        if (cleanCmd != null) {
            this.cleanCommandText.setText(cleanCmd);
        } else {
            this.cleanCommandText.setText("");
        }
    }

    public String getName() {
        return Messages.CMakeBuildTab_Cmake;
    }
}

