/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.function.catalog;

import io.github.toolfactory.jvm.function.catalog.BuiltinClassLoaderClassSupplier;
import io.github.toolfactory.jvm.function.catalog.DeepConsulterSupplyFunction;
import io.github.toolfactory.jvm.function.catalog.GetClassByNameFunction;
import io.github.toolfactory.jvm.function.catalog.GetDeclaredFieldFunction;
import io.github.toolfactory.jvm.function.catalog.GetFieldValueFunction;
import io.github.toolfactory.jvm.function.template.ThrowingQuadFunction;
import io.github.toolfactory.jvm.function.template.ThrowingTriFunction;
import io.github.toolfactory.jvm.util.ObjectProvider;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.module.ModuleReader;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;

public interface GetResourcesFunction
extends ThrowingTriFunction<String, Boolean, ClassLoader[], Collection<URL>, Throwable> {
    @Override
    public Collection<URL> apply(String var1, Boolean var2, Collection<ClassLoader> var3) throws Throwable;

    public static class ForJava9
    extends ForJava7 {
        public ForJava9(Map<Object, Object> context) throws Throwable {
            super(context);
        }

        @Override
        protected ThrowingQuadFunction<ClassLoader, String, Boolean, Collection<URL>, Collection<URL>, Throwable> buildResourceFinder(final Map<Object, Object> context) throws Throwable {
            final ObjectProvider functionProvider = ObjectProvider.get(context);
            final MethodHandles.Lookup consulter = (MethodHandles.Lookup)functionProvider.getOrBuildObject(DeepConsulterSupplyFunction.class, context).apply(Class.class);
            final GetClassByNameFunction getClassByNameFunction = functionProvider.getOrBuildObject(GetClassByNameFunction.class, context);
            final GetDeclaredFieldFunction getDeclaredFieldFunction = functionProvider.getOrBuildObject(GetDeclaredFieldFunction.class, context);
            final ThrowingQuadFunction<ClassLoader, String, Boolean, Collection<URL>, Collection<URL>, Throwable> superResourceFinder = super.buildResourceFinder(context);
            return new ThrowingQuadFunction<ClassLoader, String, Boolean, Collection<URL>, Collection<URL>, Throwable>(){
                final Class<?> jdk_internal_loader_BuiltinClassLoaderClass;
                final Class<?> java_lang_module_ModuleReferenceClass;
                final Class<?> jdk_internal_loader_URLClassPathClass;
                final Class<?> jdk_internal_loader_BuiltinClassLoader$loadedModuleClass;
                final Field jdk_internal_loader_BuiltinClassLoader_nameToModuleField;
                final Field jdk_internal_loader_BuiltinClassLoader_ucpField;
                final Field jdk_internal_loader_BuiltinClassLoader_packageToModuleField;
                final GetFieldValueFunction getFieldValueFunction;
                final MethodHandle jdk_internal_loader_BuiltinClassLoader$loadedModule_name;
                final MethodHandle jdk_internal_loader_BuiltinClassLoader_moduleReaderFor;
                final MethodHandle jdk_internal_loader_URLClassPath_findResources;
                {
                    this.jdk_internal_loader_BuiltinClassLoaderClass = (Class)functionProvider.getOrBuildObject(BuiltinClassLoaderClassSupplier.class, context).get();
                    this.java_lang_module_ModuleReferenceClass = (Class)getClassByNameFunction.apply("java.lang.module.ModuleReference", false, this.getClass().getClassLoader(), this.getClass());
                    this.jdk_internal_loader_URLClassPathClass = (Class)getClassByNameFunction.apply("jdk.internal.loader.URLClassPath", false, this.getClass().getClassLoader(), this.getClass());
                    this.jdk_internal_loader_BuiltinClassLoader$loadedModuleClass = (Class)getClassByNameFunction.apply("jdk.internal.loader.BuiltinClassLoader$LoadedModule", false, this.getClass().getClassLoader(), this.getClass());
                    this.jdk_internal_loader_BuiltinClassLoader_nameToModuleField = (Field)getDeclaredFieldFunction.apply(this.jdk_internal_loader_BuiltinClassLoaderClass, "nameToModule");
                    this.jdk_internal_loader_BuiltinClassLoader_ucpField = (Field)getDeclaredFieldFunction.apply(this.jdk_internal_loader_BuiltinClassLoaderClass, "ucp");
                    this.jdk_internal_loader_BuiltinClassLoader_packageToModuleField = (Field)getDeclaredFieldFunction.apply(this.jdk_internal_loader_BuiltinClassLoaderClass, "packageToModule");
                    this.getFieldValueFunction = functionProvider.getOrBuildObject(GetFieldValueFunction.class, context);
                    this.jdk_internal_loader_BuiltinClassLoader$loadedModule_name = consulter.findVirtual(this.jdk_internal_loader_BuiltinClassLoader$loadedModuleClass, "name", MethodType.methodType(String.class));
                    this.jdk_internal_loader_BuiltinClassLoader_moduleReaderFor = consulter.findVirtual(this.jdk_internal_loader_BuiltinClassLoaderClass, "moduleReaderFor", MethodType.methodType(ModuleReader.class, this.java_lang_module_ModuleReferenceClass));
                    this.jdk_internal_loader_URLClassPath_findResources = consulter.findVirtual(this.jdk_internal_loader_URLClassPathClass, "findResources", MethodType.methodType(Enumeration.class, String.class, Boolean.TYPE));
                }

                @Override
                public Collection<URL> apply(ClassLoader classLoader, String resourceRelativePath, Boolean findFirst, Collection<URL> resources) throws Throwable {
                    if (this.jdk_internal_loader_BuiltinClassLoaderClass.isAssignableFrom(classLoader.getClass())) {
                        Enumeration resourceURLS;
                        URL resource;
                        Object moduleName;
                        Object moduleReference2;
                        Map packageToModule = (Map)this.getFieldValueFunction.apply(classLoader, this.jdk_internal_loader_BuiltinClassLoader_packageToModuleField);
                        String packageName = this.toPackageName(resourceRelativePath);
                        Object loadedModule = packageToModule.get(packageName);
                        Map nameToModule = (Map)this.getFieldValueFunction.apply(classLoader, this.jdk_internal_loader_BuiltinClassLoader_nameToModuleField);
                        if (loadedModule != null && (moduleReference2 = nameToModule.get(moduleName = (String)this.jdk_internal_loader_BuiltinClassLoader$loadedModule_name.invokeWithArguments(loadedModule))) != null && (resource = this.findResourceInModule(classLoader, moduleReference2, resourceRelativePath)) != null) {
                            resources.add(resource);
                            if (findFirst.booleanValue()) {
                                return resources;
                            }
                        }
                        for (Object moduleReference2 : nameToModule.values()) {
                            resource = this.findResourceInModule(classLoader, moduleReference2, resourceRelativePath);
                            if (resource == null) continue;
                            resources.add(resource);
                            if (!findFirst.booleanValue()) continue;
                            return resources;
                        }
                        Object ucp = this.getFieldValueFunction.apply(classLoader, this.jdk_internal_loader_BuiltinClassLoader_ucpField);
                        try {
                            resourceURLS = (Enumeration)this.jdk_internal_loader_URLClassPath_findResources.invokeWithArguments(ucp, resourceRelativePath, false);
                        }
                        catch (NullPointerException exc) {
                            if (ucp != null) {
                                throw exc;
                            }
                            return resources;
                        }
                        while (resourceURLS.hasMoreElements()) {
                            resources.add((URL)resourceURLS.nextElement());
                            if (!findFirst.booleanValue()) continue;
                            return resources;
                        }
                        return resources;
                    }
                    return (Collection)superResourceFinder.apply(classLoader, resourceRelativePath, findFirst, resources);
                }

                private String toPackageName(String name) {
                    int index = name.lastIndexOf(47);
                    if (index == -1 || index == name.length() - 1) {
                        return "";
                    }
                    return name.substring(0, index).replace("/", ".");
                }

                private URL findResourceInModule(ClassLoader classLoader, Object moduleReference, String resourceRelativePath) throws Throwable {
                    ModuleReader moduleReader = (ModuleReader)this.jdk_internal_loader_BuiltinClassLoader_moduleReaderFor.invokeWithArguments(classLoader, moduleReference);
                    URI resourceURI = moduleReader.find(resourceRelativePath).orElse(null);
                    if (resourceURI != null) {
                        return resourceURI.toURL();
                    }
                    return null;
                }
            };
        }
    }

    public static class ForJava7
    extends Abst {
        public ForJava7(Map<Object, Object> context) throws Throwable {
            super(context);
        }

        @Override
        protected ThrowingQuadFunction<ClassLoader, String, Boolean, Collection<URL>, Collection<URL>, Throwable> buildResourceFinder(Map<Object, Object> context) throws Throwable {
            return new ThrowingQuadFunction<ClassLoader, String, Boolean, Collection<URL>, Collection<URL>, Throwable>(){

                @Override
                public Collection<URL> apply(ClassLoader classLoader, String resourceRelativePath, Boolean findFirst, Collection<URL> resources) throws IOException {
                    if (findFirst.booleanValue()) {
                        URL resource = classLoader.getResource(resourceRelativePath);
                        if (resource != null) {
                            resources.add(resource);
                        }
                    } else {
                        Enumeration<URL> resourceURLS = classLoader.getResources(resourceRelativePath);
                        while (resourceURLS.hasMoreElements()) {
                            resources.add(resourceURLS.nextElement());
                        }
                    }
                    return resources;
                }
            };
        }
    }

    public static abstract class Abst
    implements GetResourcesFunction {
        protected ThrowingQuadFunction<ClassLoader, String, Boolean, Collection<URL>, Collection<URL>, Throwable> resourceFinder;

        public Abst(Map<Object, Object> context) throws Throwable {
            this.resourceFinder = this.buildResourceFinder(context);
        }

        protected abstract ThrowingQuadFunction<ClassLoader, String, Boolean, Collection<URL>, Collection<URL>, Throwable> buildResourceFinder(Map<Object, Object> var1) throws Throwable;

        @Override
        public Collection<URL> apply(String resourceRelativePath, Boolean findFirst, ClassLoader[] resourceClassLoaders) throws Throwable {
            LinkedHashSet<URL> resources = new LinkedHashSet<URL>();
            if (resourceClassLoaders == null || resourceClassLoaders.length == 0) {
                return this.resourceFinder.apply(Thread.currentThread().getContextClassLoader(), resourceRelativePath, findFirst, resources);
            }
            for (ClassLoader classLoader : resourceClassLoaders) {
                this.resourceFinder.apply(classLoader, resourceRelativePath, findFirst, resources);
            }
            return resources;
        }

        @Override
        public Collection<URL> apply(String resourceRelativePath, Boolean findFirst, Collection<ClassLoader> resourceClassLoaders) throws Throwable {
            LinkedHashSet<URL> resources = new LinkedHashSet<URL>();
            if (resourceClassLoaders == null || resourceClassLoaders.isEmpty()) {
                return this.resourceFinder.apply(Thread.currentThread().getContextClassLoader(), resourceRelativePath, findFirst, resources);
            }
            for (ClassLoader classLoader : resourceClassLoaders) {
                this.resourceFinder.apply(classLoader, resourceRelativePath, findFirst, resources);
            }
            return resources;
        }
    }
}

