/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;

public final class CollectionUtil {
    private CollectionUtil() {
    }

    public static <T> Iterator<T> dump(Iterator<T> it) {
        ArrayList<T> list = new ArrayList<T>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        System.out.println(list);
        return list.iterator();
    }

    public static <NODE> List<NODE> topologicalSort(Collection<NODE> nodes, Function<NODE, Collection<NODE>> edgeProvider) {
        return CollectionUtil.topologicalSort(nodes, edgeProvider, false);
    }

    public static <NODE> List<NODE> topologicalSort(Collection<NODE> nodes, Function<NODE, Collection<NODE>> edgeProvider, boolean reverse) {
        final class NodeInfo<N> {
            N node;
            List<NodeInfo<N>> edgeInfos = new ArrayList<NodeInfo<N>>();
            int indegree;

            NodeInfo(N node) {
                this.node = node;
            }
        }
        HashMap<NODE, NodeInfo<NODE>> infos = new HashMap<NODE, NodeInfo<NODE>>();
        for (NODE node : nodes) {
            infos.put(node, new NodeInfo<NODE>(node));
        }
        for (NODE node : nodes) {
            NodeInfo info = (NodeInfo)infos.get(node);
            Collection<NODE> edges = edgeProvider.apply(node);
            if (edges == null) continue;
            for (NODE NODE : edges) {
                NodeInfo edgeInfo = (NodeInfo)infos.get(NODE);
                if (edgeInfo == null) {
                    throw new IllegalStateException("Edge is not a node: " + NODE);
                }
                info.edgeInfos.add(edgeInfo);
                ++edgeInfo.indegree;
            }
        }
        LinkedList<NodeInfo> queue = new LinkedList<NodeInfo>();
        for (NodeInfo info : infos.values()) {
            if (info.indegree != 0) continue;
            queue.add(info);
        }
        int size = nodes.size();
        ArrayList result = new ArrayList(size);
        while (!queue.isEmpty()) {
            NodeInfo info = (NodeInfo)queue.poll();
            if (reverse) {
                result.add(0, info.node);
            } else {
                result.add(info.node);
            }
            for (NodeInfo nodeInfo : info.edgeInfos) {
                if (--nodeInfo.indegree != 0) continue;
                queue.add(nodeInfo);
            }
        }
        if (result.size() != size) {
            throw new IllegalStateException("Cycle detected");
        }
        return result;
    }

    public static <T> boolean addNotNull(Collection<? super T> c, T e) {
        if (e != null) {
            return c.add(e);
        }
        return false;
    }

    public static <T> Set<T> setOf(Collection<? extends T> c) {
        if (c instanceof Set) {
            return (Set)c;
        }
        return new HashSet<T>(c);
    }

    public static <T> T first(Collection<? extends T> c) {
        Iterator<T> it = c.iterator();
        return it.hasNext() ? (T)it.next() : null;
    }

    public static <K, V> List<K> removeAll(Map<K, V> map, BiPredicate<K, V> predicate) {
        ArrayList<K> keys = new ArrayList<K>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            V value;
            K key = entry.getKey();
            if (!predicate.test(key, value = entry.getValue())) continue;
            keys.add(key);
        }
        for (Object key : keys) {
            map.remove(key);
        }
        return keys;
    }

    public static <K, V> V compute(Map<K, V> map, K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        try {
            return map.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
        }
        catch (KeepMappedValue ex) {
            return (V)ex.mappedValue();
        }
    }

    public static final class KeepMappedValue
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final transient Object mappedValue;

        public KeepMappedValue(Object mappedValue) {
            this.mappedValue = mappedValue;
        }

        public <T> T mappedValue() {
            return (T)this.mappedValue;
        }
    }
}

