/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.transfer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.cdo.transfer.CDOTransfer;
import org.eclipse.emf.cdo.transfer.CDOTransferElement;
import org.eclipse.emf.cdo.transfer.CDOTransferMapping;
import org.eclipse.emf.cdo.transfer.CDOTransferSystem;
import org.eclipse.emf.cdo.transfer.CDOTransferType;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.om.monitor.SubProgressMonitor;

class CDOTransferMappingImpl
implements CDOTransferMapping {
    private final CDOTransfer transfer;
    private final CDOTransferElement source;
    private final CDOTransferMappingImpl parent;
    private List<CDOTransferMapping> children;
    private CDOTransferType transferType;
    private IPath relativePath;
    private CDOTransferMapping.Status status;

    public CDOTransferMappingImpl(CDOTransfer transfer, CDOTransferElement source, CDOTransferMapping parent, IProgressMonitor monitor) {
        CDOTransferType transferType;
        this.transfer = transfer;
        this.source = source;
        this.parent = (CDOTransferMappingImpl)parent;
        this.relativePath = transfer.getPathProvider().getPath(source);
        this.transferType = transferType = transfer.getTransferType(source);
        if (parent != null) {
            this.parent.addChild(this);
        }
        try {
            if (this.isDirectory()) {
                CDOTransferElement[] children = source.getChildren();
                monitor.beginTask("", 1 + children.length);
                monitor.subTask("Mapping " + source);
                monitor.worked(1);
                CDOTransferElement[] cDOTransferElementArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    CDOTransferElement child = cDOTransferElementArray[n2];
                    transfer.map(child, this, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    ++n2;
                }
            } else {
                monitor.beginTask("", 1);
                monitor.subTask("Mapping " + source);
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    public CDOTransferMappingImpl(CDOTransfer transfer) {
        this.transfer = transfer;
        this.source = null;
        this.parent = null;
        this.transferType = CDOTransferType.FOLDER;
        this.relativePath = Path.EMPTY;
    }

    @Override
    public CDOTransfer getTransfer() {
        return this.transfer;
    }

    @Override
    public CDOTransferElement getSource() {
        return this.source;
    }

    @Override
    public CDOTransferMapping getParent() {
        return this.parent;
    }

    @Override
    public boolean isRoot() {
        return this.parent == null;
    }

    @Override
    public boolean isDirectory() {
        if (this.source == null) {
            return true;
        }
        return this.source.isDirectory();
    }

    @Override
    public String getName() {
        return this.relativePath.lastSegment();
    }

    @Override
    public void setName(String name) {
        this.setRelativePath(this.relativePath.removeLastSegments(1).append(name));
    }

    @Override
    public IPath getRelativePath() {
        return this.relativePath;
    }

    @Override
    public void setRelativePath(IPath path) {
        if (!ObjectUtil.equals((Object)this.relativePath, (Object)path)) {
            IPath oldPath = this.relativePath;
            this.relativePath = path;
            this.unsetStatusRecursively();
            this.transfer.relativePathChanged(this, oldPath, path);
        }
    }

    @Override
    public void setRelativePath(String path) {
        this.setRelativePath((IPath)new Path(path));
    }

    @Override
    public void accept(CDOTransferMapping.Visitor visitor) {
        if (visitor.visit(this) && this.children != null) {
            for (CDOTransferMapping child : this.children) {
                child.accept(visitor);
            }
        }
    }

    @Override
    public CDOTransferMapping[] getChildren() {
        if (ObjectUtil.isEmpty(this.children)) {
            return NO_CHILDREN;
        }
        Object[] result = this.children.toArray(new CDOTransferMapping[this.children.size()]);
        Arrays.sort(result);
        return result;
    }

    @Override
    public CDOTransferMapping getChild(IPath path) {
        if (path.isEmpty()) {
            return this;
        }
        String name = path.segment(0);
        CDOTransferMapping[] cDOTransferMappingArray = this.getChildren();
        int n = cDOTransferMappingArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOTransferMapping child = cDOTransferMappingArray[n2];
            if (name.equals(child.getName())) {
                return child.getChild(path.removeFirstSegments(1));
            }
            ++n2;
        }
        return null;
    }

    @Override
    public CDOTransferMapping getChild(String path) {
        return this.getChild((IPath)new Path(path));
    }

    private void addChild(CDOTransferMapping child) {
        this.ensureChildrenList();
        if (!this.children.contains(child)) {
            this.children.add(child);
            this.transfer.childrenChanged(this, child, CDOTransfer.ChildrenChangedEvent.Kind.MAPPED);
        }
    }

    private void removeChild(CDOTransferMapping child) {
        if (this.children != null && this.children.remove(child)) {
            this.transfer.childrenChanged(this, child, CDOTransfer.ChildrenChangedEvent.Kind.UNMAPPED);
        }
    }

    private void ensureChildrenList() {
        if (this.children == null) {
            this.children = new ArrayList<CDOTransferMapping>();
        }
    }

    @Override
    public void unmap() {
        this.transfer.unmap(this);
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
    }

    @Override
    public CDOTransferType getTransferType() {
        return this.transferType;
    }

    @Override
    public void setTransferType(CDOTransferType transferType) {
        if (!ObjectUtil.equals((Object)this.transferType, (Object)transferType)) {
            CDOTransferType oldType = this.transferType;
            this.transferType = transferType;
            this.transfer.transferTypeChanged(this, oldType, transferType);
        }
    }

    @Override
    public IPath getFullPath() {
        IPath relativePath = this.getRelativePath();
        if (this.isRoot()) {
            return relativePath;
        }
        IPath path = this.parent.getFullPath();
        return path.append(relativePath);
    }

    @Override
    public CDOTransferMapping.Status getStatus() {
        if (this.status == null) {
            this.status = this.calculateStatus();
        }
        return this.status;
    }

    private CDOTransferMapping.Status calculateStatus() {
        CDOTransferMapping.Status status;
        if (this.parent != null && (status = this.parent.getStatus()) != CDOTransferMapping.Status.MERGE) {
            return status;
        }
        CDOTransferSystem targetSystem = this.transfer.getTargetSystem();
        IPath fullPath = this.getFullPath();
        int lastSegment = fullPath.segmentCount();
        int i = 1;
        while (i <= lastSegment) {
            IPath path = fullPath.uptoSegment(i);
            CDOTransferElement target = targetSystem.getElement(path);
            if (target == null) {
                return CDOTransferMapping.Status.NEW;
            }
            boolean sourceDirectory = i == lastSegment ? this.isDirectory() : true;
            boolean targetDirectory = target.isDirectory();
            if (!sourceDirectory || !targetDirectory) {
                return CDOTransferMapping.Status.CONFLICT;
            }
            ++i;
        }
        return CDOTransferMapping.Status.MERGE;
    }

    private void unsetStatusRecursively() {
        if (this.status != null) {
            this.status = null;
            if (this.children != null && !this.children.isEmpty()) {
                for (CDOTransferMapping child : this.children) {
                    ((CDOTransferMappingImpl)child).unsetStatusRecursively();
                }
            }
        }
    }

    @Override
    public CDOTransferElement getTarget() {
        CDOTransferSystem targetSystem = this.transfer.getTargetSystem();
        IPath fullPath = this.getFullPath();
        return targetSystem.getElement(fullPath);
    }

    @Override
    public int compareTo(CDOTransferMapping o) {
        boolean oDirectory;
        boolean directory = this.isDirectory();
        if (directory != (oDirectory = o.isDirectory())) {
            return directory ? -1 : 1;
        }
        return this.getName().compareTo(o.getName());
    }

    public String toString() {
        return this.getFullPath().toString();
    }
}

